/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.handler.MessageHandler;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.AskUserMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.execution.IParamManager;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AskUserNodeApplicationImpl
extends AbstractNodeApplication<AskUserAction> {
    private static final Log log = LogFactory.getLog(AskUserNodeApplicationImpl.class);

    public AskUserNodeApplicationImpl(Context context, Flow gaiFlow, AskUserAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        AskUserMessage message = this.buildAskUserMessage(this.context, this.gaiFlow, (AskUserAction)this.action, e);
        this.getLog(e).logInput("message", message);
        AskUserCallbackMessage callbackMessage = new AskUserCallbackMessage();
        callbackMessage.setChatSessionId(this.context.getChatSessionId());
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setMessage(message);
        callbackMessage.setStartTs(System.currentTimeMillis());
        FlowCacheData.putCache(this.context.getChatSessionId(), this.context.getChatSessionId() + "_ASK_USER", JSONObject.toJSONString((Object)callbackMessage));
        String userContent = MessageHandler.messageToHistory(message.getElementList());
        MessageConfig messageConfig = new MessageConfig();
        messageConfig.setAskUser(Boolean.TRUE);
        Message chatMessage = MessageService.insertMessage(this.context.getChatSessionId(), userContent, "", messageConfig.toString(), this.context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, this.context.messageIsEnable());
        PushMsgService.pushAskUser(this.context, message.getElementList(), StrUtils.longAsString(chatMessage.getMessageId()), messageConfig, message.isAllowUserInput(), message.isSseAutoClose());
    }

    public AskUserMessage buildAskUserMessage(Context context, Flow flow, AskUserAction askUserAction, Execution e) {
        AskUserMessage message = new AskUserMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(askUserAction.getId());
        message.setElementList(this.toMessages(e, askUserAction));
        message.setAllowUserInput(askUserAction.isAllowUserInput());
        message.setSseAutoClose(askUserAction.isSseAutoClose());
        return message;
    }

    public List<MsgNodeMessage.MessageElement> toMessages(Execution e, AskUserAction askUserAction) {
        IParamManager paramManager = this.getParamManager();
        List<ParamDefinition> paramDefList = askUserAction.getParamByDirection(ParamDirection.BOTH, ParamDirection.OUTPUT, ParamDirection.INPUT);
        ArrayList<MsgNodeMessage.MessageElement> elementList = new ArrayList<MsgNodeMessage.MessageElement>(paramDefList.size());
        paramDefList.forEach(paramDef -> {
            if (paramDef instanceof MessageParamDefinition) {
                MessageParamDefinition messageParamDef = (MessageParamDefinition)paramDef;
                MsgNodeMessage.MessageElement messageElement = new MsgNodeMessage.MessageElement();
                elementList.add(messageElement);
                messageElement.setType(messageParamDef.getMessageType().getValue());
                Object value = paramManager.getParamValue(e, askUserAction, messageParamDef);
                messageElement.setValue(value == null ? "" : value.toString());
            }
        });
        return elementList;
    }
}

