/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.flow.biz.IFlowNodeLog;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.impl.BatchProcessNodeBuilderFactory;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.trace.entity.FlowNodeLog;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BatchProcessNodeApplicationImpl
extends AbstractNodeApplication<BatchAction> {
    private static final Log logger = LogFactory.getLog(BatchProcessNodeApplicationImpl.class);

    public BatchProcessNodeApplicationImpl(Context context, Flow gaiFlow, BatchAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        int minArraySize = -1;
        List<ParamDefinition> inputParamDef = ((BatchAction)this.action).getBatchInputParams();
        for (ParamDefinition paramDefinition : inputParamDef) {
            Object value = this.getParamManager().getParamValue(e, this.action, paramDefinition);
            if (!(value instanceof List)) continue;
            List listValue = (List)value;
            if (minArraySize == -1) {
                minArraySize = listValue.size();
                continue;
            }
            minArraySize = Math.min(minArraySize, listValue.size());
        }
        minArraySize = Math.min(minArraySize, ((BatchAction)this.action).getBatchLimit());
        ArrayList<Integer> batchIndexList = new ArrayList<Integer>(minArraySize);
        for (int i = 0; i < minArraySize; ++i) {
            batchIndexList.add(i);
        }
        this.getParamManager().setParamValue(e, ((BatchAction)this.action).getId(), "BatchIndexArray", ParamDirection.INPUT, batchIndexList);
        IFlowNodeLog batchLog = this.getLog(e);
        FlowCacheData.putCache(this.context.getChatSessionId(), this.getBacthLogIdCacheKey(e), ((FlowNodeLog)batchLog).getId());
    }

    private String getBacthLogIdCacheKey(Execution e) {
        return String.format("FlowNodeLogId-%s-%s", e.getRuntime().getFlow().getId(), ((BatchAction)this.action).getId());
    }

    @Override
    protected void onListenerEvent(Execution e, Event event) {
        if (e.getDefine().getId().equals(BatchProcessNodeBuilderFactory.getBacthProcessBlockNodeId(((BatchAction)this.action).getId())) && event == BatchProcessNodeBuilderFactory.EVENT_SET_VARIABLES) {
            this.setBatchItemVariables(e);
        }
        if (e.getDefine().getId().equals(BatchProcessNodeBuilderFactory.getBacthProcessBlockNodeId(((BatchAction)this.action).getId())) && event == BatchProcessNodeBuilderFactory.EVENT_SET_OUTPUT) {
            this.setBatchOutPutItemVariables(e);
        }
        if (e.getDefine().getId().equals(String.valueOf(((BatchAction)this.action).getId())) && event == Event.ON_COMPLETED) {
            FlowCacheData.clearCache(this.context.getChatSessionId(), this.getBacthLogIdCacheKey(e));
        }
    }

    private void setBatchOutPutItemVariables(Execution e) {
        List<ParamDefinition> outputParamDefList = ((BatchAction)this.action).getBatchOutputParams();
        LinkedHashMap<String, Object> mapParams = new LinkedHashMap<String, Object>(outputParamDefList.size());
        if (this.action instanceof ParallelAction) {
            for (ParamDefinition paramDefinition : outputParamDefList) {
                if (!(paramDefinition instanceof ArrayParamDefinition)) continue;
                ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
                Object refValue = this.getParamManager().getParamValueByPath(e, paramDefinition.getReferencePath());
                String outItemParamName = VariableBuilderFactory.getArrayItemParamName(arrayParamDefinition);
                if (refValue != null) {
                    this.getParamManager().setParamValue(e, ((BatchAction)this.action).getId(), outItemParamName, ParamDirection.OUTPUT, refValue);
                }
                mapParams.put(outItemParamName, refValue);
            }
        } else {
            if (outputParamDefList.isEmpty()) {
                throw new KDBizException(Errors.nodeExecuteError(((BatchAction)this.action).getName(), "\u6279\u91cf\u8c03\u7528\u6a21\u5f0f\u5fc5\u987b\u8bbe\u7f6e\u8f93\u51fa\u53c2\u6570\u3010outputList\u3011\u3002"), new Object[0]);
            }
            for (ParamDefinition paramDefinition : outputParamDefList) {
                if (!paramDefinition.getName().equals("outputList")) continue;
                if (!(paramDefinition instanceof ArrayParamDefinition)) break;
                ArrayParamDefinition outputListParamDef = (ArrayParamDefinition)paramDefinition;
                ObjectParamDefinition itemParamDef = (ObjectParamDefinition)outputListParamDef.getItemDefinition();
                HashMap<String, Object> itemValueMap = new HashMap<String, Object>(itemParamDef.getProperties().size());
                for (ParamDefinition property : itemParamDef.getProperties()) {
                    Object propertyValue = this.getParamManager().getParamValue(e, this.action, property);
                    itemValueMap.put(property.getName(), propertyValue);
                }
                String outItemParamName = VariableBuilderFactory.getArrayItemParamName(outputListParamDef);
                this.getParamManager().setParamValue(e, ((BatchAction)this.action).getId(), outItemParamName, ParamDirection.OUTPUT, itemValueMap);
                mapParams.put(outItemParamName, itemValueMap);
                break;
            }
        }
        FlowNodeLog batchIndexLog = (FlowNodeLog)this.getLog(e);
        batchIndexLog.logOutputParams(mapParams);
        batchIndexLog.logEnd(new Result(Errors.OK));
        TraceUtil.saveFlowLog((FlowNodeLog)this.getLog(e));
    }

    private void setBatchItemVariables(Execution e) {
        List<ParamDefinition> inputParamDef = ((BatchAction)this.action).getBatchInputParams();
        int batchIndex = (Integer)this.getParamManager().getParamValue(e, ((BatchAction)this.action).getId(), "BatchIndex", ParamDirection.INPUT);
        LinkedHashMap<String, Object> mapParams = new LinkedHashMap<String, Object>(inputParamDef.size());
        for (ParamDefinition paramDefinition : inputParamDef) {
            if (!(paramDefinition instanceof ArrayParamDefinition)) continue;
            ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
            List listValue = (List)this.getParamManager().getParamValue(e, this.action, arrayParamDefinition);
            this.getParamManager().setParamValue(e, ((BatchAction)this.action).getId(), VariableBuilderFactory.getArrayItemParamName(arrayParamDefinition), ParamDirection.INPUT, listValue.get(batchIndex));
            mapParams.put(VariableBuilderFactory.getArrayItemParamName(arrayParamDefinition), listValue.get(batchIndex));
        }
        this.getParamManager().setParamValue(e, ((BatchAction)this.action).getId(), VariableBuilderFactory.getArrayItemIndexParamName(), ParamDirection.INPUT, batchIndex);
        mapParams.put(VariableBuilderFactory.getArrayItemIndexParamName(), batchIndex);
        String childLogId = String.format("index_%s", batchIndex);
        String childLogName = String.format("index_%s", batchIndex);
        FlowNodeLog log = (FlowNodeLog)this.getLog(e);
        String parentLogId = FlowCacheData.getCache(this.context.getChatSessionId(), this.getBacthLogIdCacheKey(e));
        log.setId(String.format("%s.%s", parentLogId, childLogId));
        log.setName(childLogName);
        log.setParentId(parentLogId);
        log.logInputParams(mapParams);
        this.setParentLog(e, log);
    }

    @Override
    protected Map<String, Object> getOutputParamMap(Execution e) {
        List<ParamDefinition> paramDefList = ((BatchAction)this.action).getBatchOutputParams();
        HashMap<String, Object> mapResult = new HashMap<String, Object>(paramDefList.size());
        for (ParamDefinition paramDef : paramDefList) {
            String paramName = paramDef.getName();
            Object paramValue = this.getParamManager().getParamValue(e, this.action, paramDef);
            mapResult.put(paramName, paramValue);
        }
        return mapResult;
    }

    @Override
    protected Map<String, Object> getInputParamMap(Execution e) {
        List<ParamDefinition> paramDefList = ((BatchAction)this.action).getBatchInputParams();
        HashMap<String, Object> mapResult = new HashMap<String, Object>(paramDefList.size());
        for (ParamDefinition paramDef : paramDefList) {
            String paramName = paramDef.getName();
            Object paramValue = this.getParamManager().getParamValue(e, this.action, paramDef);
            mapResult.put(paramName, paramValue);
        }
        return mapResult;
    }
}

