/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.BillOperateAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.BillOperateMessage;
import kd.ai.gai.core.flow.biz.application.AbstractParallelNodeApplication;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BillOperateNodeApplicationImpl
extends AbstractParallelNodeApplication<BillOperateAction> {
    private static final Log log = LogFactory.getLog(BillOperateNodeApplicationImpl.class);

    public BillOperateNodeApplicationImpl(Context context, Flow gaiFlow, BillOperateAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        log.info("Bill Operate process run");
        BillOperateMessage message = this.buildBillOperateMessage(e);
        this.getLog(e).logInput("Bill Operate Message ", message);
        this.opetateAction(message, e);
    }

    private void opetateAction(BillOperateMessage message, Execution e) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Object[] ids = message.getIds();
        if (ids == null || ids.length == 0) {
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u8282\u70b9\u6570\u636e\u5f02\u5e38,\u4e1a\u52a1\u5355\u636eids\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u6765\u6e90\u3002", (String)"BillOperateNodeApplication_8", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
        String bizBill = message.getBizBill();
        String bizOperate = message.getBizOperate();
        try {
            String msg;
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)bizOperate, (String)bizBill, (Object[])ids, (OperateOption)OperateOption.create());
            boolean operateStatus = operationResult.isSuccess();
            int billCount = operationResult.getBillCount();
            List successPkIds = operationResult.getSuccessPkIds();
            Set errorIds = Collections.EMPTY_SET;
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (operateStatus) {
                msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BillOperateNodeApplication_0", (String)"ai-gai-core", (Object[])new Object[0]);
            } else {
                errorIds = allErrorOrValidateInfo.stream().map(operateInfo -> String.valueOf(operateInfo.getPkValue())).collect(Collectors.toSet());
                int errorSize = errorIds.size();
                String operateName = BillOperateNodeApplicationImpl.getOperateName(bizBill, bizOperate);
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5171%s%s\u6761\u5355\u636e\uff0c\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761\n", (String)"BillOperateNodeApplication_1", (String)"ai-gai-core", (Object[])new Object[0]), operateName, billCount, successPkIds.size(), errorSize));
                errorMsg.append(ResManager.loadKDString((String)"\u5931\u8d25\u5355\u636e\u8be6\u60c5\uff1a", (String)"BillOperateNodeApplication_2", (String)"ai-gai-core", (Object[])new Object[0]));
                if (allErrorOrValidateInfo.isEmpty()) {
                    errorMsg.append(ResManager.loadKDString((String)("\u3010" + Arrays.toString(ids) + "\u3011\u4e1a\u52a1\u5355\u636eID\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002"), (String)"BillOperateNodeApplication_4", (String)"ai-gai-core", (Object[])new Object[0]));
                } else {
                    allErrorOrValidateInfo.forEach(operateInfo -> errorMsg.append("\n").append(operateInfo.getMessage()));
                }
                msg = errorMsg.toString();
            }
            List successIds = Collections.EMPTY_LIST;
            if (successPkIds != null && !successPkIds.isEmpty()) {
                successIds = successPkIds.stream().map(Object::toString).collect(Collectors.toList());
            }
            dataMap.put("status", operateStatus);
            dataMap.put("successIds", successIds);
            dataMap.put("errorIds", errorIds.isEmpty() ? null : errorIds.toArray());
            dataMap.put("message", msg);
            this.setOutputParams(e, dataMap);
        }
        catch (Exception ex) {
            log.error("Bill Operate error msg:{}", (Object)ex.getMessage(), (Object)ex);
            if (ex instanceof KDException) {
                String billName = MetadataServiceHelper.getDataEntityType((String)bizBill).getDisplayName().getLocaleValue();
                String operateName = BillOperateNodeApplicationImpl.getOperateName(bizBill, bizOperate);
                operateName = StringUtils.isEmpty((String)operateName) ? bizOperate : String.format("%s(%s)", operateName, bizOperate);
                ErrorCode errorCode = Errors.billOperateError(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%s(%s)\u3011,\u4e1a\u52a1\u64cd\u4f5c\u3010%s\u3011\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u65b9\u68c0\u67e5,\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"BillOperateNodeApplication_7", (String)"ai-gai-core", (Object[])new Object[0]), billName, bizBill, operateName, ex.getMessage()));
                throw new KDBizException(errorCode, new Object[0]);
            }
            throw ex;
        }
    }

    @Nullable
    private static String getOperateName(String bizBill, String bizOperate) {
        Map billOperate = EntityMetadataCache.getDataEntityOperate((String)bizBill).stream().filter(op -> bizOperate.equals(op.get("key"))).findFirst().orElse(null);
        String operateName = null;
        if (billOperate != null) {
            operateName = LocaleString.fromMap((Map)((Map)billOperate.get("name"))).getLocaleValue();
        }
        return operateName;
    }

    public BillOperateMessage buildBillOperateMessage(Execution e) {
        BillOperateMessage message = new BillOperateMessage();
        message.setChatSessionId(this.context.getChatSessionId());
        message.setFlowId(this.gaiFlow.getId());
        message.setNodeId(((BillOperateAction)this.action).getId());
        message.setBizBill(((BillOperateAction)this.action).getBizBill());
        message.setBizOperate(((BillOperateAction)this.action).getBizOperate());
        Object[] billIdList = this.getBillIdList((BillOperateAction)this.action, e);
        message.setIds(billIdList);
        return message;
    }

    private Object[] getBillIdList(BillOperateAction action, Execution e) {
        try {
            String bizBill = action.getBizBill();
            List<ParamDefinition> inputParams = action.getInputParams();
            ParamDefinition var = inputParams.get(0);
            List ids = (List)this.getParamManager().getParamValue(e, action, var);
            return BillOperateNodeApplicationImpl.conversionIds(ids, bizBill);
        }
        catch (Exception ex) {
            if (ex instanceof KDBizException) {
                throw ex;
            }
            log.error("bill operate ids input error :{}", (Object)ex.getMessage(), (Object)ex);
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636eids\u6570\u636e\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u8282\u70b9\u5165\u53c2\u3010ids\u3011\u914d\u7f6e", (String)"BillOperateNodeApplication_3", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static Object[] conversionIds(List<String> idList, String bizBill) {
        if (idList == null || idList.isEmpty()) {
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillOperateNodeApplication_5", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
        BillEntityType dataEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)bizBill);
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        try {
            if (primaryKey instanceof LongProp) {
                return idList.stream().map(Long::parseLong).toArray();
            }
            if (primaryKey instanceof VarcharProp) {
                return idList.stream().map(String::valueOf).toArray();
            }
        }
        catch (Exception ex) {
            ErrorCode errorCode = Errors.billIdConvertionError(String.format(ResManager.loadKDString((String)"\u6570\u636e\uff1a%s,\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"BillOperateNodeApplication_6", (String)"ai-gai-core", (Object[])new Object[0]), JsonUtil.toJson(idList), ex.getMessage()));
            log.error("bill operate conversion ids error :{}", (Object)JsonUtil.toJson(errorCode), (Object)ex);
            throw new KDBizException(errorCode, new Object[0]);
        }
        return null;
    }
}

