/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.BillQueryAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.message.BillQueryMessage;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BillQueryNodeApplicationImpl
extends AbstractNodeApplication<BillQueryAction> {
    private static final Log log = LogFactory.getLog(BillQueryNodeApplicationImpl.class);
    public static final String[] patterns = new String[]{"yyyy-MM-dd", "yyyyMMdd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"};

    public BillQueryNodeApplicationImpl(Context context, Flow gaiFlow, BillQueryAction action) {
        super(context, gaiFlow, action);
    }

    public BillQueryMessage buildQueryMessage(Context context, Flow flow, BillQueryAction billQueryAction, Execution e) {
        BillQueryMessage message = new BillQueryMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(billQueryAction.getId());
        Map<String, Object> inputParamMap = this.getInputParamMap(e);
        HashMap<String, String> params = new HashMap<String, String>();
        inputParamMap.entrySet().stream().forEach(paramEntry -> params.put((String)paramEntry.getKey(), String.valueOf(paramEntry.getValue())));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (ParamDefinition var : billQueryAction.getInputParams()) {
            String operation = var.getCustomProperties().get(var.getName());
            if (params.get(var.getName()) == null) continue;
            String value = String.valueOf(params.get(var.getName()));
            Object v = BillQueryNodeApplicationImpl.getPropValue(var.getType().getDesc(), value);
            if (v == null) continue;
            if (operation.equalsIgnoreCase("like")) {
                filters.add(QFilter.like((String)var.getName(), (String)String.valueOf(params.get(var.getName()))));
                continue;
            }
            if (operation.equalsIgnoreCase("not like")) {
                filters.add(QFilter.notLike((String)var.getName(), (String)String.valueOf(params.get(var.getName()))));
                continue;
            }
            if (operation.equalsIgnoreCase("is null")) {
                filters.add(QFilter.isNull((String)var.getName()));
                continue;
            }
            if (operation.equalsIgnoreCase("is not null")) {
                filters.add(QFilter.isNotNull((String)var.getName()));
                continue;
            }
            if (operation.equalsIgnoreCase("in") || operation.equalsIgnoreCase("not in")) continue;
            filters.add(new QFilter(var.getName(), operation, v));
        }
        message.setqFilter(filters.toArray(new QFilter[filters.size()]));
        message.setInputParams(params);
        return message;
    }

    public static Map<String, List<Object>> dynamicCollectionToMapByProperties(DynamicObject[] objs, String properties) {
        String[] propertyArray;
        HashMap<String, List<Object>> dynamicMapList = new HashMap<String, List<Object>>();
        for (String column : propertyArray = properties.split(",")) {
            if (column.isEmpty()) continue;
            ArrayList<Object> list = new ArrayList<Object>(16);
            for (DynamicObject dynamicObject : objs) {
                String trimColum = column.trim();
                list.add(dynamicObject.get(trimColum));
            }
            dynamicMapList.put(column, list);
        }
        return dynamicMapList;
    }

    public static Object getPropValue(String type, String v) {
        if (v == null || v.length() == 0) {
            return null;
        }
        if (type.equalsIgnoreCase("decimal")) {
            v = v.replaceAll(",", "");
            try {
                return new BigDecimal(StringUtils.isEmpty((CharSequence)v) ? "0.00" : v);
            }
            catch (Exception e) {
                log.error("BigDecimal\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return new BigDecimal("0.00");
            }
        }
        if (type.equalsIgnoreCase("Integer")) {
            v = v.replaceAll(",", "");
            try {
                return Integer.valueOf(StringUtils.isEmpty((CharSequence)v) ? "0" : v);
            }
            catch (Exception e) {
                log.error("int\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return Integer.valueOf("0");
            }
        }
        if (type.equalsIgnoreCase("Long")) {
            v = v.replaceAll(",", "");
            try {
                return Long.valueOf(StringUtils.isEmpty((CharSequence)v) ? "0" : v);
            }
            catch (Exception e) {
                log.error("Long\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return Long.valueOf("0");
            }
        }
        if (type.equalsIgnoreCase("String")) {
            return v;
        }
        if (type.equalsIgnoreCase("dateTime") || type.equalsIgnoreCase("date")) {
            Date date = BillQueryNodeApplicationImpl.parseFormatedDate(v);
            return date;
        }
        return null;
    }

    public static Date parseFormatedDate(String inputDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        for (String pattern : patterns) {
            df.applyPattern(pattern);
            df.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date date = df.parse(inputDate, pos);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public static Map<String, String> convert(Map<String, List<Object>> originalMap) {
        if (originalMap == null) {
            return new HashMap<String, String>();
        }
        return originalMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List list = (List)entry.getValue();
            if (list == null) {
                return "null";
            }
            return list.stream().map(String::valueOf).collect(Collectors.joining(", "));
        }));
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        log.info("BillQueryHandler process");
        BillQueryMessage message = this.buildQueryMessage(this.context, this.gaiFlow, (BillQueryAction)this.action, e);
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("id");
        JSONObject root = JSONObject.parseObject((String)((BillQueryAction)this.action).getMetaData());
        if (root != null) {
            JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
            for (int i = 0; i < fieldInfoList.size(); ++i) {
                JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
                JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
                for (QFilter[] plainField : plainFieldList) {
                    String fieldId = plainField.getString("fieldId");
                    if (fieldId.equalsIgnoreCase("id")) continue;
                    filters.add(fieldId);
                }
            }
        }
        String properties = String.join((CharSequence)",", filters);
        HashMap<String, Object> extProperties = new HashMap<String, Object>();
        try {
            int count;
            Object[] objs = BusinessDataServiceHelper.load((String)((BillQueryAction)this.action).getBillId(), (String)properties, (QFilter[])message.getqFilter());
            int n = count = objs == null ? 0 : objs.length;
            if (count == 0) {
                ((BillQueryAction)this.action).setName(e.getDefine().getTitle());
            }
            extProperties.put("count", String.valueOf(count));
            extProperties.put("status", true);
            extProperties.put("metaData", ((BillQueryAction)this.action).getMetaData());
            extProperties.put("message", "null");
            StringBuilder sb = new StringBuilder();
            if (message.getqFilter() != null) {
                for (QFilter qFilter : message.getqFilter()) {
                    sb.append(qFilter.toString());
                    sb.append(",");
                }
            }
            if (sb.length() > 1) {
                extProperties.put("filter", sb.substring(0, sb.length() - 1));
            } else {
                extProperties.put("filter", sb.toString());
            }
            this.setOutputParams(e, extProperties);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)((BillQueryAction)this.action).getBillId());
            List<Map> list = BillQueryNodeApplicationImpl.serializeToMap(objs, (DynamicObjectType)mainEntityType);
            ArrayList<HashMap> lists = new ArrayList<HashMap>(16);
            for (int i = 0; i < list.size(); ++i) {
                this.forMap((HashMap)list.get(i));
                lists.add((HashMap)list.get(i));
            }
            HashMap<String, ArrayList<HashMap>> result = new HashMap<String, ArrayList<HashMap>>();
            result.put("result", lists);
            this.setOutputParams(e, result);
        }
        catch (Exception ex) {
            extProperties.put("status", false);
            extProperties.put("message", "\u67e5\u8be2\u5931\u8d25,\u751f\u6210\u67e5\u8be2\u6761\u4ef6\u5931\u8d25");
            this.setOutputParams(e, extProperties);
            log.error("query message failed:{}" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException(Errors.codeExecuteError(((BillQueryAction)this.action).getName(), ex.getMessage()), new Object[0]);
        }
        this.getLog(e).logInput("message", message);
        ((BillQueryAction)this.action).setName(e.getDefine().getTitle());
    }

    public void forMap(HashMap<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof OrmLocaleValue) {
                map.put(entry.getKey(), ((OrmLocaleValue)entry.getValue()).getLocaleValue());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.forMap((HashMap)entry.getValue());
        }
    }

    public static String serialize(Object[] result, DynamicObjectType dt) {
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(false);
        String[] r = new String[result.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = jsr.serializeToString(result[i], null);
        }
        return JSON.toJSONString((Object)r);
    }

    public static List<Map> serializeToMap(Object[] result, DynamicObjectType dt) {
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(false);
        ArrayList<Map> r = new ArrayList<Map>(result.length);
        for (int i = 0; i < result.length; ++i) {
            Map map = jsr.serializeToMap(result[i], null);
            r.add(map);
        }
        return r;
    }
}

