/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.BillSaveAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.message.BillSaveMessage;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.gptas.webapi.ConversionResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BillSaveNodeApplicationImpl
extends AbstractNodeApplication<BillSaveAction> {
    private Log logger = LogFactory.getLog(BillSaveNodeApplicationImpl.class);

    public BillSaveNodeApplicationImpl(Context context, Flow gaiFlow, BillSaveAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        BillSaveMessage message = this.buildBillSaveMessage(this.context, this.gaiFlow, (BillSaveAction)this.action, e);
        Map<String, Object> inputMap = message.getInputParams();
        Map<String, Object> resultMap = this.BillSaveOperate(inputMap, ((BillSaveAction)this.action).getAppId(), ((BillSaveAction)this.action).getBizId());
        this.setOutputParams(resultMap, e);
    }

    private void setOutputParams(Map<String, Object> resultMap, Execution e) {
        ParamDefinition statusParam = ((BillSaveAction)this.action).getParamByName(((BillSaveAction)this.action).getOutputParamGroup(), "status").get();
        ParamDefinition dataParam = ((BillSaveAction)this.action).getParamByName(((BillSaveAction)this.action).getOutputParamGroup(), "data").get();
        ParamDefinition messageParam = ((BillSaveAction)this.action).getParamByName(((BillSaveAction)this.action).getOutputParamGroup(), "message").get();
        this.getParamManager().setParamValue(e, this.action, statusParam, resultMap.get("status"));
        this.getParamManager().setParamValue(e, this.action, dataParam, resultMap.get("data"));
        this.getParamManager().setParamValue(e, this.action, messageParam, resultMap.get("message"));
    }

    public Map<String, Object> BillSaveOperate(Map<String, Object> billDataMap, String bizAppId, String bizFormId) {
        OperationResult operateResult;
        List errorList;
        StringBuilder errorBuilder;
        Map converMap;
        ConversionResult result;
        Map<Object, Object> resultMap = new HashMap<String, Boolean>(1);
        String pkId = String.valueOf(billDataMap.get("id"));
        Map dataEntityTypeMap = MetadataServiceHelper.getDataEntityType((String)bizFormId).getAllEntities();
        for (Map.Entry entry : dataEntityTypeMap.entrySet()) {
            List data;
            if (entry.getValue() instanceof SubEntryType) {
                String parentEntityName = ((EntityType)entry.getValue()).getParent().getName();
                List parentList = (List)billDataMap.get(parentEntityName);
                if (parentList == null) continue;
                for (Map map : parentList) {
                    List subMap;
                    if (map.isEmpty() || (subMap = (List)map.get(entry.getKey())) == null) continue;
                    Iterator subIterator = subMap.iterator();
                    while (subIterator.hasNext()) {
                        Map subEntryMap = (Map)subIterator.next();
                        if (subEntryMap == null) {
                            subIterator.remove();
                            continue;
                        }
                        if (!subEntryMap.isEmpty()) continue;
                        subIterator.remove();
                    }
                }
                continue;
            }
            if (!(entry.getValue() instanceof EntryType) || (data = (List)billDataMap.get(entry.getKey())) == null) continue;
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (map == null) {
                    iterator.remove();
                    continue;
                }
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
        }
        if (pkId.equals("null")) {
            result = (ConversionResult)DispatchServiceHelper.invokeBOSService((String)bizAppId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{"kd.bos.gptas.webapi.WebApiDataConvertService", "convertData", new Object[]{bizFormId, bizAppId, billDataMap}});
            converMap = result.getErrors();
            if (!converMap.isEmpty()) {
                errorBuilder = new StringBuilder();
                errorList = (List)converMap.get(0);
                for (String errorStr : errorList) {
                    errorBuilder.append(errorStr).append("\n");
                }
                resultMap.put("status", false);
                resultMap.put("message", errorBuilder.toString());
                return resultMap;
            }
            operateResult = SaveServiceHelper.saveOperate((String)"save", (String)bizFormId, (DynamicObject[])new DynamicObject[]{result.getData()});
            resultMap = this.formatResult(operateResult, bizFormId, bizAppId);
        } else {
            result = (ConversionResult)DispatchServiceHelper.invokeBOSService((String)bizAppId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{"kd.bos.gptas.webapi.WebApiDataConvertService", "convertData", new Object[]{bizFormId, bizAppId, pkId, billDataMap}});
            converMap = result.getErrors();
            if (!converMap.isEmpty()) {
                errorBuilder = new StringBuilder();
                errorList = (List)converMap.get(0);
                for (String errorStr : errorList) {
                    errorBuilder.append(errorStr).append("\n");
                }
                resultMap.put("status", false);
                resultMap.put("message", errorBuilder.toString());
                return resultMap;
            }
            operateResult = SaveServiceHelper.saveOperate((String)"save", (String)bizFormId, (DynamicObject[])new DynamicObject[]{result.getData()});
            resultMap = this.formatResult(operateResult, bizFormId, bizAppId);
        }
        return resultMap;
    }

    public Map<String, Object> formatResult(OperationResult operateResult, String entityName, String appId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        boolean saveOperate = operateResult.isSuccess();
        List succcessPkIds = operateResult.getSuccessPkIds();
        int billCounts = operateResult.getBillCount();
        int successCount = succcessPkIds.size();
        int failedCount = billCounts - successCount;
        if (!saveOperate) {
            ValidateResultCollection resultCollection = operateResult.getValidateResult();
            List errors = resultCollection.getValidateErrors();
            JSONObject messageJson = new JSONObject();
            for (ValidateResult error : errors) {
                List errorInfos = error.getAllErrorInfo();
                ArrayList<String> infoMessage = new ArrayList<String>(errorInfos.size());
                for (OperateErrorInfo errorInfo : errorInfos) {
                    String errorMessage = errorInfo.getMessage();
                    infoMessage.add(errorMessage);
                }
                messageJson.put("info", infoMessage);
            }
            messageJson.put("error", (Object)operateResult.getMessage());
            resultMap.put("message", messageJson.toJSONString());
        }
        ArrayList dataArray = new ArrayList(1);
        this.logger.info("bill save successIds:{}", (Object)succcessPkIds);
        for (Object id : succcessPkIds) {
            DynamicObject successDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(String.valueOf(id)), (String)entityName);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            String billNo = "";
            IDataEntityType dataEntityType = successDynamicObject.getDataEntityType();
            if (dataEntityType instanceof BasedataEntityType) {
                billNo = successDynamicObject.getString("number");
            } else if (dataEntityType instanceof EntryType) {
                billNo = successDynamicObject.getString("billno");
            } else if (dataEntityType instanceof BillEntityType) {
                billNo = successDynamicObject.getString("billno");
            }
            dataMap.put("id", id);
            dataMap.put("billNo", billNo);
            dataArray.add(dataMap);
            resultMap.put("data", dataArray.get(0));
        }
        resultMap.put("status", saveOperate);
        return resultMap;
    }

    private BillSaveMessage buildBillSaveMessage(Context context, Flow gaiFlow, BillSaveAction action, Execution e) {
        BillSaveMessage billSaveMessage = new BillSaveMessage();
        billSaveMessage.setChatSessionId(context.getChatSessionId());
        billSaveMessage.setFlowId(gaiFlow.getId());
        billSaveMessage.setNodeId(action.getId());
        billSaveMessage.setBizId(action.getBizId());
        HashMap<String, Object> inputMap = new HashMap<String, Object>(1);
        List<ParamDefinition> inputParams = action.getInputParams();
        for (ParamDefinition inputParam : inputParams) {
            Object paramValue = this.getParamManager().getParamValue(e, action, inputParam);
            inputMap.put(inputParam.getName(), paramValue);
        }
        billSaveMessage.setInputParams(inputMap);
        return billSaveMessage;
    }
}

