/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.message.CodeMessage;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.KScriptUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.script.Script;
import kd.ai.gai.flow.script.Util;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CodeNodeApplicationImpl
extends AbstractNodeApplication<CodeAction> {
    private static final String K_SCRIPT = "kscript";
    private static final Log log = LogFactory.getLog(CodeNodeApplicationImpl.class);

    public CodeNodeApplicationImpl(Context context, Flow gaiFlow, CodeAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        CodeMessage message = this.buildCodeMessage(this.context, this.gaiFlow, (CodeAction)this.action, e);
        this.getLog(e).logInput("message", message);
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>(10);
        String code = message.getCode();
        Map<String, Object> inParams = message.getInParams();
        if (inParams != null) {
            for (Map.Entry<String, Object> stringObjectEntry : inParams.entrySet()) {
                String name = stringObjectEntry.getKey();
                String value = stringObjectEntry.getValue() == null ? "" : stringObjectEntry.getValue().toString();
                code = FlowUtils.fillCode(code, name, value);
            }
        }
        scriptCtx.putAll(Constant.ENGINE.scriptCtx);
        scriptCtx.put("$input", message.getInParams());
        Object result = "";
        if (K_SCRIPT.equals(((CodeAction)this.action).getLanguage())) {
            try {
                String script = KScriptUtils.generateScript((CodeAction)this.action, message.getCode());
                result = KScriptUtils.execScript(script, scriptCtx);
                log.info("code eval result: {}", result);
            }
            catch (Exception ex) {
                String msg = Util.formatException((Exception)ex);
                log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)ex);
                throw new KDException(Errors.codeExecuteError(((CodeAction)this.action).getName(), ex.getMessage()), new Object[0]);
            }
        }
        Script p = null;
        try {
            p = GaiScript.compile(code, scriptCtx);
        }
        catch (Exception ex) {
            log.error("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:{}" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException(Errors.codeCompileError(((CodeAction)this.action).getName(), ex.getMessage()), new Object[0]);
        }
        try {
            result = p.eval(scriptCtx);
            log.info("code eval result: {}", result);
        }
        catch (Exception ex) {
            String msg = Util.formatException((Exception)ex);
            log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)ex);
            throw new KDBizException(Errors.codeExecuteError(((CodeAction)this.action).getName(), ex.getMessage()), new Object[0]);
        }
        String resultStr = StrUtils.getEvalResult(result);
        this.setOutput(e, message, resultStr);
        ((CodeAction)this.action).setName(e.getDefine().getTitle());
    }

    private void setOutput(Execution e, CodeMessage codeMessage, String resultStr) {
        HashMap<String, String> outputDataMap = new HashMap<String, String>(1);
        outputDataMap.put("output", resultStr);
        if (codeMessage.isEnableParseJson()) {
            JSONObject resultJo;
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                log.error("\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a");
                throw new KDBizException(Errors.codeResultParseError(((CodeAction)this.action).getName(), "\u4ee3\u7801\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a\u3002"), new Object[0]);
            }
            try {
                resultJo = JSONObject.parseObject((String)resultStr);
            }
            catch (Exception ex) {
                log.error("\u6267\u884c\u7ed3\u679c\u8f6cJSON\u5f02\u5e38:{}" + ex.getMessage(), (Throwable)ex);
                throw new KDBizException(Errors.codeResultParseError(((CodeAction)this.action).getName(), String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u662f\u6709\u6548JSONObject\u3002", resultStr)), new Object[0]);
            }
            Set keys = resultJo.keySet();
            keys.forEach(key -> outputDataMap.put((String)key, (String)resultJo.get(key)));
        }
        this.setOutputParams(e, outputDataMap);
    }

    public CodeMessage buildCodeMessage(Context context, Flow flow, CodeAction codeAction, Execution e) {
        AtomicReference<String> code = new AtomicReference<String>(codeAction.getCode());
        CodeMessage message = new CodeMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(codeAction.getId());
        message.setEnableParseJson(codeAction.isEnableParseJson());
        message.setLanguage(codeAction.getLanguage());
        LinkedHashMap<String, Object> inParams = new LinkedHashMap<String, Object>();
        inParams.put("chatSessionId", context.getChatSessionId());
        Map<String, Object> inputParamMap = this.getInputParamMap(e);
        if (inputParamMap != null && !inputParamMap.isEmpty()) {
            inParams.putAll(inputParamMap);
        }
        message.setInParams(inParams);
        message.setCode(code.get());
        return message;
    }
}

