/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CvpFlowUtils {
    private static final Log log = LogFactory.getLog(CvpFlowUtils.class);

    public static void fillData(JSONObject jsonObject, Map<String, Object> resultMap) {
        if (resultMap == null || resultMap.isEmpty() || jsonObject == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_PARAM_ERROR), new Object[0]);
        }
        log.info("jsonObject:{},resultMap:{}", (Object)jsonObject.toJSONString(), (Object)JSON.toJSONString(resultMap));
        JSONObject data = jsonObject.getJSONObject("data");
        if (data != null) {
            JSONObject bizOutput = data.getJSONObject("bizOutput");
            JSONObject templateOutput = data.getJSONObject("templateOutput");
            Map templateOutputMap = null;
            Map bizOutputMap = null;
            if (!resultMap.isEmpty()) {
                if (resultMap.get("templateOutput") != null) {
                    templateOutputMap = (Map)resultMap.get("templateOutput");
                }
                if (resultMap.get("bizOutput") != null) {
                    bizOutputMap = (Map)resultMap.get("bizOutput");
                }
            }
            CvpFlowUtils.fillTemplateData(templateOutput, templateOutputMap);
            CvpFlowUtils.fillBizData(bizOutput, bizOutputMap);
            jsonObject.put("data", (Object)data);
        }
    }

    private static void fillBizData(JSONObject bizOutput, Map<String, Object> resultMap) {
        if (bizOutput == null || bizOutput.isEmpty() || resultMap == null || resultMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : bizOutput.entrySet()) {
            JSONObject jsonObject;
            JSONObject data;
            Object value = entry.getValue();
            if (value == null || (data = (jsonObject = (JSONObject)value).getJSONObject("data")) == null) continue;
            HashMap<String, Object> rMap = new HashMap<String, Object>(16);
            for (Map.Entry dataEntry : data.entrySet()) {
                String key = (String)dataEntry.getKey();
                Object value1 = dataEntry.getValue();
                if (value1 == null) continue;
                JSONObject jsonObject1 = (JSONObject)value1;
                rMap.put(key, CvpFlowUtils.setByDataType(jsonObject1, resultMap, key));
            }
            jsonObject.put("data", rMap);
            entry.setValue(jsonObject);
        }
    }

    private static void fillTemplateData(JSONObject templateOutput, Map<String, Object> resultMap) {
        if (resultMap == null || resultMap.isEmpty()) {
            log.warn("\u56de\u586b\u5931\u8d25\uff0c\u672a\u63d0\u53d6\u5230\u7ed3\u679c\u6570\u636e");
            resultMap = new HashMap<String, Object>(16);
        }
        if (templateOutput != null && !templateOutput.isEmpty()) {
            for (Map.Entry entry : templateOutput.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                JSONObject dataObj = (JSONObject)value;
                JSONObject dObj = dataObj.getJSONObject("data");
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (dObj == null) continue;
                block1: for (Map.Entry dObjEntry : dObj.entrySet()) {
                    JSONObject jsonObject;
                    String dataType;
                    String fkey = (String)dObjEntry.getKey();
                    Object value1 = dObjEntry.getValue();
                    if (value1 == null || !StringUtils.isNotEmpty((String)(dataType = (jsonObject = (JSONObject)value1).getString("dataType")))) continue;
                    for (Map.Entry<String, Object> resultEntry : resultMap.entrySet()) {
                        String key1 = resultEntry.getKey();
                        Object value2 = resultEntry.getValue();
                        if (!key1.equals(fkey)) continue;
                        if ("common".equals(dataType)) {
                            map.put(fkey, value2 != null ? value2.toString() : "");
                            continue block1;
                        }
                        if ("entry".equals(dataType)) {
                            JSONArray value3 = jsonObject.getJSONArray("value");
                            Object o1 = value3.get(0);
                            JSONObject jsonObject1 = (JSONObject)o1;
                            map.put(fkey, CvpFlowUtils.setDataForEntry(value2, jsonObject1));
                            continue block1;
                        }
                        log.warn("\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a{}", (Object)dataType);
                        continue block1;
                    }
                }
                dataObj.put("data", map);
                entry.setValue(dataObj);
            }
        }
    }

    private static List<Map<String, String>> setDataForEntry(Object valueArr, JSONObject treeFieldsTable) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        if (valueArr != null) {
            List valueList = (List)valueArr;
            for (Map jsonObject2 : valueList) {
                HashMap<String, String> map1 = new HashMap<String, String>();
                block1: for (Map.Entry rEntry : jsonObject2.entrySet()) {
                    String key3 = (String)rEntry.getKey();
                    Object value5 = rEntry.getValue();
                    for (Map.Entry tvEntry : treeFieldsTable.entrySet()) {
                        String key2 = (String)tvEntry.getKey();
                        if (!key2.equals(key3)) continue;
                        map1.put(key2, value5.toString());
                        continue block1;
                    }
                }
                HashMap map2 = new HashMap(treeFieldsTable.size());
                map2.putAll(treeFieldsTable);
                for (Map.Entry kEntry : map2.entrySet()) {
                    String key2 = (String)kEntry.getKey();
                    if (map1.containsKey(key2)) continue;
                    map1.put(key2, "");
                }
                list.add(map1);
            }
        }
        return list;
    }

    private static Object setByDataType(JSONObject jsonObject1, Map<String, Object> resultMap, String key) {
        String dataType = jsonObject1.getString("dataType");
        if ("common".equals(dataType)) {
            return CvpFlowUtils.getCommonStr(resultMap, key);
        }
        if ("base".equals(dataType)) {
            JSONObject value2 = jsonObject1.getJSONObject("value");
            return CvpFlowUtils.getBaseStr(resultMap, key, value2);
        }
        if ("entry".equals(dataType)) {
            JSONArray value2 = jsonObject1.getJSONArray("value");
            return CvpFlowUtils.getEntryStr(resultMap, key, value2);
        }
        log.warn("\u672a\u77e5\u7ed3\u6784\u8d4b\u503c");
        throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_CVP_STRUCT_ERROR), new Object[0]);
    }

    private static List<Map<String, Object>> getEntryStr(Map<String, Object> resultMap, String entryKey, JSONArray value2) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        if (value2 != null && !value2.isEmpty()) {
            Object o = value2.get(0);
            JSONObject jsonObject = (JSONObject)o;
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key1 = (String)entry.getKey();
                Object value = entry.getValue();
                JSONObject jsonObject1 = (JSONObject)value;
                if (jsonObject1 == null) continue;
                String dataType = jsonObject1.getString("dataType");
                if ("common".equals(dataType)) {
                    String entryCommonKey = entryKey.concat(".").concat(key1);
                    List<String> values = CvpFlowUtils.getEntryFieldStr(resultMap, entryCommonKey);
                    if (values.isEmpty()) continue;
                    for (int i = 0; i < values.size(); ++i) {
                        Map<String, String> map = null;
                        if (!list.isEmpty() && list.size() >= i + 1) {
                            map = (Map)list.get(i);
                        } else {
                            map = new HashMap<String, String>(16);
                            list.add(map);
                        }
                        map.put(key1, values.get(i));
                    }
                    continue;
                }
                if (!"base".equals(dataType)) continue;
                JSONObject value1 = jsonObject1.getJSONObject("value");
                for (Map.Entry vEntry : value1.entrySet()) {
                    String key = (String)vEntry.getKey();
                    String entryBaseKey = entryKey.concat(".").concat(key1).concat(".").concat(key);
                    List<Map<String, String>> values = CvpFlowUtils.getEntryBaseFields(resultMap, entryBaseKey, key);
                    if (values.isEmpty()) continue;
                    for (int i = 0; i < values.size(); ++i) {
                        Map<String, Map<String, String>> map = null;
                        if (!list.isEmpty() && list.size() >= i + 1) {
                            map = (Map)list.get(i);
                        } else {
                            map = new HashMap(16);
                            list.add(map);
                        }
                        if (map.containsKey(key1)) {
                            Object o1 = map.get(key1);
                            ((Map)o1).putAll(values.get(i));
                            log.info("\u57fa\u7840\u8d44\u6599\u653e\u5165\u5c5e\u6027\uff1a{}", (Object)JSON.toJSONString(values.get(i)));
                            continue;
                        }
                        map.put(key1, values.get(i));
                    }
                }
            }
        }
        return list;
    }

    private static List<Map<String, String>> getEntryBaseFields(Map<String, Object> resultMap, String entryBaseKey, String fkey) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        if (StringUtils.isNotEmpty((String)entryBaseKey) && StringUtils.isNotEmpty((String)fkey) && resultMap != null && !resultMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                List strs;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!entryBaseKey.equals(key)) continue;
                if (value instanceof String) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put(fkey, value.toString());
                    list.add(map);
                    break;
                }
                if (!(value instanceof List) || (strs = (List)value).isEmpty()) break;
                for (Object str : strs) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put(fkey, str.toString());
                    list.add(map);
                }
            }
        }
        log.info("getEntryBaseFields:{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private static List<String> getEntryFieldStr(Map<String, Object> resultMap, String keys) {
        ArrayList<String> list = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)keys) && resultMap != null && !resultMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!keys.equals(key)) continue;
                if (value instanceof String) {
                    list.add(value.toString());
                    break;
                }
                if (!(value instanceof List)) break;
                List value2 = (List)value;
                list.addAll(value2);
                break;
            }
        }
        return list;
    }

    private static Map<String, String> getBaseStr(Map<String, Object> resultMap, String baseKey, JSONObject value1) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (value1 != null && !value1.isEmpty()) {
            block0: for (Map.Entry entry : value1.entrySet()) {
                String fKey = (String)entry.getKey();
                String baseKeyStr = baseKey.concat(".").concat(fKey);
                for (Map.Entry<String, Object> resultEntry : resultMap.entrySet()) {
                    String rKey = resultEntry.getKey();
                    Object rValue = resultEntry.getValue();
                    String valueStr = "";
                    if (rValue != null) {
                        if (rValue instanceof String) {
                            valueStr = rValue.toString();
                        } else if (rValue.getClass().isArray()) {
                            List rValueList = (List)rValue;
                            valueStr = (String)rValueList.get(0);
                        }
                    }
                    if (!rKey.equals(baseKeyStr)) continue;
                    map.put(fKey, valueStr);
                    continue block0;
                }
            }
        }
        return map;
    }

    private static String getCommonStr(Map<String, Object> resultMap, String key) {
        for (Map.Entry<String, Object> resultEntry : resultMap.entrySet()) {
            String key1 = resultEntry.getKey();
            Object value2 = resultEntry.getValue();
            if (!key.equals(key1)) continue;
            if (value2 instanceof String) {
                return value2.toString();
            }
            if (value2 == null || !value2.getClass().isArray()) continue;
            List value2List = (List)value2;
            return (String)value2List.get(0);
        }
        return "";
    }
}

