/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.var.FlowVariableService;
import kd.ai.gai.core.helper.ClusterWaiter;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class EndNodeApplicationImpl
extends AbstractNodeApplication<End> {
    private static final Log log = LogFactory.getLog(EndNodeApplicationImpl.class);
    private FlowVariableService flowVariableService = FlowVariableService.getInstance();

    public EndNodeApplicationImpl(Context context, Flow gaiFlow, End action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        Result flowResult = new Result(Errors.OK);
        PushMsgService.pushEndOutput(this.context, this.gaiFlow.getId(), this.toStringMap(this.getOutputParamMap(e)));
        flowResult.setStatus(Result.Status.END);
        flowResult.setData(this.toStringMap(this.getOutputParamMap(e)));
        String key = String.format("%s_%s", this.context.getChatSessionId(), this.gaiFlow.getDefId());
        FlowCacheData.putCache(this.context.getChatSessionId(), key, JSON.toJSONString((Object)flowResult));
        ClusterWaiter.release(key);
        this.flowVariableService.storeFlowVariables(this.context.getChatSessionId(), e, this.gaiFlow);
        PushMsgService.pushWaitingDone(this.context);
        this.clearFlowCacheData(this.context, this.gaiFlow);
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(this.context.getSlideenv(), this.context.getChatTraceId(), this.context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
    }

    private void clearFlowCacheData(Context context, Flow flow) {
        String chatSessionId = context.getChatSessionId();
        long flowId = flow.getId();
        FlowCacheData.clearFlowNodeData(chatSessionId, flowId, flow.getStart().getId());
        for (Action action : flow.getActions()) {
            FlowCacheData.clearFlowNodeData(chatSessionId, flowId, action.getId());
        }
        FlowCacheData.clearFlow(chatSessionId, flowId);
    }
}

