/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.handler.SysOperateHandler;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.OperationType;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class JavaActionNodeApplicationImpl
extends AbstractNodeApplication<JavaPluginAction> {
    private static final Log log = LogFactory.getLog(JavaActionNodeApplicationImpl.class);

    public JavaActionNodeApplicationImpl(Context context, Flow gaiFlow, JavaPluginAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        JavaActionMessage message = this.buildJavaActionMessage(this.context, this.gaiFlow, (JavaPluginAction)this.action, e);
        this.getLog(e).logInput("message", message);
        if (this.isSysOperation(message)) {
            Map<String, String> bizResult = this.callSysOperation(message);
            this.setOutputParams(e, bizResult);
            return;
        }
        if (message.isFrontOperation()) {
            if (((JavaPluginAction)this.action).isBlockInnerNode() && this.gaiFlow.findActionById(((JavaPluginAction)this.action).getBlockNodeId()).isParallelBlockNode()) {
                throw new KDBizException(Errors.notSupportActionType(ResManager.loadKDString((String)"\u6279\u5904\u7406\u6a21\u5f0f\u4e0d\u652f\u6301\u524d\u7aef\u64cd\u4f5cIGPTFormAction", (String)"JavaActionNodeApplication_0", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
            }
            String bizPageIdOrRootPageId = message.getPageId() == null ? this.context.getRootPageId() : message.getPageId();
            bizPageIdOrRootPageId = bizPageIdOrRootPageId == null ? "" : bizPageIdOrRootPageId;
            Map<String, String> bizResult = this.callAction(this.context, message.getAppId(), message.getClassName(), new Object[]{bizPageIdOrRootPageId, message.getActionName(), message.getParams()});
            String actionResultStr = bizResult.get("actionresult");
            if (StringUtils.isEmpty((String)actionResultStr)) {
                log.warn("\u524d\u7aef\u4e1a\u52a1\u64cd\u4f5c\u6ca1\u6709\u8fd4\u56deactionresult\u3002 {}", (Object)JSONObject.toJSONString((Object)message));
            } else if (this.context.getAssistantPageId() != null) {
                PageCache pageCache = new PageCache(this.context.getAssistantPageId());
                String actionKey = "action_result_" + this.context.getChatSessionId();
                pageCache.put(actionKey, actionResultStr);
                ForwardMessage forwardMessage = new ForwardMessage();
                forwardMessage.setChatSessionId(message.getChatSessionId());
                forwardMessage.setFlowId(message.getFlowId());
                forwardMessage.setNodeId(message.getNodeId());
                String forwardMessageKey = "forwardMessage_" + this.context.getChatSessionId();
                pageCache.put(forwardMessageKey, JSONObject.toJSONString((Object)forwardMessage));
                PushMsgService.pushForward(this.context, ForwardType.javaAction, actionKey, forwardMessageKey);
                FlowUtils.suspend(this.context.getChatSessionId(), this.gaiFlow.getId(), e.getRuntime());
            }
            this.setOutputParams(e, bizResult);
        } else {
            Map<String, String> bizResult = this.callAction(this.context, message.getAppId(), message.getClassName(), new Object[]{message.getActionName(), message.getParams()});
            this.setOutputParams(e, bizResult);
            ((JavaPluginAction)this.action).setName(e.getDefine().getTitle());
        }
    }

    public Map<String, String> callSysOperation(JavaActionMessage message) {
        SysOperateHandler sysOperateHandler = new SysOperateHandler();
        return sysOperateHandler.invokeAction(message.getActionName(), message.getParams());
    }

    private boolean isSysOperation(JavaActionMessage message) {
        return message.getClassName().trim().equals(SysOperateHandler.class.getName());
    }

    public Map<String, String> callAction(Context context, String appId, String className, Object[] bizParams) {
        FlowCacheData.restoreRequestContext(context.getChatSessionId());
        Object ret = DispatchServiceHelper.invokeBOSService((String)appId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{className, "invokeAction", bizParams});
        if (ret instanceof Map) {
            return (Map)ret;
        }
        log.error("{} : {} \u8c03\u7528\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<String,String>, \u8fd4\u56de\u503c: {} ", new Object[]{appId, className, ret});
        return Collections.emptyMap();
    }

    public JavaActionMessage buildJavaActionMessage(Context context, Flow flow, JavaPluginAction javaPluginAction, Execution e) {
        JavaActionMessage message = new JavaActionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setPageId(context.getBizPageId());
        message.setFlowId(flow.getId());
        message.setNodeId(javaPluginAction.getId());
        message.setAppId(javaPluginAction.getAppId());
        message.setClassName(javaPluginAction.getServiceName());
        message.setActionName(javaPluginAction.getAction());
        OperationType operationType = OperationType.valueOf(Integer.parseInt(javaPluginAction.getOperationType()));
        message.setFrontOperation(operationType == OperationType.Client);
        message.setParams(this.toStringMap(this.getInputParamMap(e)));
        return message;
    }

    @Override
    protected Map<String, Object> getInputParamMap(Execution e) {
        Map<String, Object> mapParams = super.getInputParamMap(e);
        mapParams.put("PAGE_ID", this.context.getBizPageId());
        mapParams.put("ROOT_PAGE_ID", this.context.getRootPageId());
        return mapParams;
    }
}

