/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.flow.biz.IFlowNodeLog;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.impl.LoopNodeBuilderFactory;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.trace.entity.FlowNodeLog;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.Execution;

public class LoopNodeApplicationImpl
extends AbstractNodeApplication<LoopAction>
implements DebuggerAction {
    private Map<ArrayParamDefinition, List<Object>> mapLoopArrayValue;

    public LoopNodeApplicationImpl(Context context, Flow gaiFlow, LoopAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
    }

    @Override
    protected void onListenerEvent(Execution e, Event event) {
        if (e.getDefine().getId().equals(LoopNodeBuilderFactory.getLoopBlockNodeId(((LoopAction)this.action).getId())) && event == LoopNodeBuilderFactory.EVENT_SET_OUTPUT_VARIABLES) {
            this.setOutput(e);
        }
        if (e.getDefine().getId().equals(LoopNodeBuilderFactory.getLoopSetVarNodeId(((LoopAction)this.action).getId())) && event == LoopNodeBuilderFactory.EVENT_SET_NEXT_LOOP_VARIABLES) {
            this.setNextLoopVars(e);
        }
    }

    private void breakWhile(Execution e) {
        this.getParamManager().setParamValue(e, ((LoopAction)this.action).getId(), "loopBreakFlag", ParamDirection.INPUT, true);
    }

    private void setNextLoopVars(Execution e) {
        int loopIndex = (Integer)this.getParamManager().getParamValue(e, ((LoopAction)this.action).getId(), "loopIndex", ParamDirection.INPUT);
        boolean isBreak = (Boolean)this.getParamManager().getParamValue(e, ((LoopAction)this.action).getId(), "loopBreakFlag", ParamDirection.INPUT);
        if (isBreak) {
            this.breakWhile(e);
            return;
        }
        loopIndex = loopIndex == -1 ? 0 : ++loopIndex;
        this.initLoopArrayValue(e);
        LinkedHashMap<String, Object> mapParams = new LinkedHashMap<String, Object>(this.mapLoopArrayValue.size());
        for (Map.Entry<ArrayParamDefinition, List<Object>> entry : this.mapLoopArrayValue.entrySet()) {
            if (loopIndex >= entry.getValue().size()) {
                this.breakWhile(e);
                return;
            }
            this.getParamManager().setParamValue(e, ((LoopAction)this.action).getId(), VariableBuilderFactory.getArrayItemParamName(entry.getKey()), ParamDirection.INPUT, entry.getValue().get(loopIndex));
            mapParams.put(VariableBuilderFactory.getArrayItemParamName(entry.getKey()), entry.getValue().get(loopIndex));
        }
        this.getParamManager().setParamValue(e, ((LoopAction)this.action).getId(), VariableBuilderFactory.getArrayItemIndexParamName(), ParamDirection.INPUT, loopIndex);
        this.getParamManager().setParamValue(e, ((LoopAction)this.action).getId(), "loopIndex", ParamDirection.INPUT, loopIndex);
        String childLogId = String.format("index_%s", loopIndex);
        String childLogName = String.format("index_%s", loopIndex);
        IFlowNodeLog childLog = this.getLog(e).createChildLog(childLogId, childLogName);
        this.setParentLog(e, childLog);
        mapParams.put(VariableBuilderFactory.getArrayItemIndexParamName(), loopIndex);
        childLog.logInputParams(mapParams);
    }

    private void initLoopArrayValue(Execution e) {
        List<ParamDefinition> loopArrParamDefs = ((LoopAction)this.action).getParamByGroup("LOOP_ARR_GROUP");
        if (this.mapLoopArrayValue == null) {
            this.mapLoopArrayValue = new HashMap<ArrayParamDefinition, List<Object>>(loopArrParamDefs.size());
            loopArrParamDefs.forEach(paramDefinition -> {
                List listValue = (List)this.getParamManager().getParamValue(e, this.action, (ParamDefinition)paramDefinition);
                this.mapLoopArrayValue.put((ArrayParamDefinition)paramDefinition, listValue);
            });
        }
    }

    private void setOutput(Execution e) {
        List<ParamDefinition> outputParams = ((LoopAction)this.action).getOutputParams();
        outputParams.forEach(paramDefinition -> {
            Object value = this.getParamManager().getParamValue(e, this.action, (ParamDefinition)paramDefinition);
            Object refValue = this.getParamManager().getParamValueByPath(e, paramDefinition.getReferencePath());
            int refNodeId = paramDefinition.getReferencePath().getNodeIdAtInt();
            if (this.gaiFlow.getBlockNodeIdByActionId(refNodeId) == ((LoopAction)this.action).getId()) {
                List<Object> listValue = this.toListValue(value);
                listValue.add(refValue);
                this.getParamManager().setParamValue(e, this.action, (ParamDefinition)paramDefinition, listValue);
            } else {
                this.getParamManager().setParamValue(e, this.action, (ParamDefinition)paramDefinition, refValue);
            }
        });
        int loopIndex = (Integer)this.getParamManager().getParamValue(e, ((LoopAction)this.action).getId(), "loopIndex", ParamDirection.INPUT);
        FlowNodeLog loopLog = (FlowNodeLog)this.getLog(e);
        String childLogId = String.format("index_%s", loopIndex);
        loopLog.getChildLogs().get(childLogId).logEnd(new Result(Errors.OK));
    }

    public List<Object> toListValue(Object value) {
        if (value instanceof List) {
            List listValue = (List)value;
            return listValue;
        }
        return new ArrayList<Object>(1);
    }

    @Override
    protected Map<String, Object> getInputParamMap(Execution e) {
        List<ParamDefinition> paramDefList = ((LoopAction)this.action).getParamByGroup(((LoopAction)this.action).getInputParamGroup());
        paramDefList.addAll(((LoopAction)this.action).getParamByGroup("LOOP_ARR_GROUP"));
        HashMap<String, Object> mapResult = new HashMap<String, Object>(paramDefList.size());
        for (ParamDefinition paramDef : paramDefList) {
            String paramName = paramDef.getName();
            Object paramValue = this.getParamManager().getParamValue(e, this.action, paramDef);
            mapResult.put(paramName, paramValue);
        }
        return mapResult;
    }
}

