/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.execution.IParamManager;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MessageNodeApplicationImpl
extends AbstractNodeApplication<MessageAction> {
    private static final Log log = LogFactory.getLog(MessageNodeApplicationImpl.class);

    public MessageNodeApplicationImpl(Context context, Flow gaiFlow, MessageAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        MsgNodeMessage message = this.buildNodeMessage(this.gaiFlow, (MessageAction)this.action, e);
        this.getLog(e).logInput("message", message.getElementList());
        if (StopStreamHandler.isStopped(this.context.getChatSessionId(), message.getFlowId())) {
            log.warn("flow {} is stopped.", (Object)message.getFlowId());
            return;
        }
        List<MsgNodeMessage.MessageElement> messageElementList = message.getElementList();
        String userContent = MessageNodeApplicationImpl.messageToHistory(messageElementList);
        SLIDEENV assistantDevice = this.context.getSlideenv();
        HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>();
        tagMap.put("replaceLast", message.isReplaceLastMessage());
        tagMap.put("concatLast", false);
        Message chatMessage = MessageService.insertMessage(this.context.getChatSessionId(), userContent, "", JSON.toJSONString(tagMap), this.context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, this.context.messageIsEnable());
        this.judgeIfSaveMessage((MessageAction)this.action, chatMessage);
        PushMsgService.pushMultiMsg(this.context, message.isReplaceLastMessage(), messageElementList, StrUtils.longAsString(chatMessage.getMessageId()), this.action);
        ((MessageAction)this.action).setName(e.getDefine().getTitle());
    }

    private void judgeIfSaveMessage(MessageAction action, Message chatMessage) {
        if (!action.isSaveMessage()) {
            DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((Object)chatMessage.getMessageId(), (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
            messageDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{messageDo});
        }
    }

    public static String messageToHistory(List<MsgNodeMessage.MessageElement> messageElementList) {
        StringBuilder inputBuilder = new StringBuilder();
        for (MsgNodeMessage.MessageElement item : messageElementList) {
            if (item.getType().equals(MessageType.Text.getValue())) {
                inputBuilder.append(item.getValue()).append(" \r\n");
                continue;
            }
            if (item.getType().equals(MessageType.HyperLink.getValue())) {
                inputBuilder.append("[gaiurl]<urlhref>").append(item.getValue()).append("</urlhref>[/gaiurl]");
                continue;
            }
            if (item.getType().equals(MessageType.Iframe.getValue())) {
                inputBuilder.append("[gaiiframe]").append(item.getValue()).append("[/gaiiframe]");
                continue;
            }
            if (!item.getType().equals(MessageType.Picture.getValue())) continue;
            inputBuilder.append("[gaiimgurl]").append(item.getValue()).append("[/gaiimgurl]");
        }
        return inputBuilder.toString();
    }

    public MsgNodeMessage buildNodeMessage(Flow flow, MessageAction messageAction, Execution e) {
        MsgNodeMessage message = new MsgNodeMessage();
        message.setFlowId(flow.getId());
        message.setElementList(this.toMessages(e, messageAction));
        message.setReplaceLastMessage(messageAction.isReplaceLastMessage());
        return message;
    }

    public List<MsgNodeMessage.MessageElement> toMessages(Execution e, MessageAction messageAction) {
        IParamManager paramManager = this.getParamManager();
        List<ParamDefinition> paramDefList = messageAction.getParamByDirection(ParamDirection.BOTH, ParamDirection.OUTPUT, ParamDirection.INPUT);
        ArrayList<MsgNodeMessage.MessageElement> elementList = new ArrayList<MsgNodeMessage.MessageElement>(paramDefList.size());
        paramDefList.forEach(paramDef -> {
            if (paramDef instanceof MessageParamDefinition) {
                MessageParamDefinition messageParamDef = (MessageParamDefinition)paramDef;
                MsgNodeMessage.MessageElement messageElement = new MsgNodeMessage.MessageElement();
                elementList.add(messageElement);
                messageElement.setType(messageParamDef.getMessageType().getValue());
                Object value = paramManager.getParamValue(e, messageAction, messageParamDef);
                messageElement.setValue(value == null ? "" : value.toString());
            }
        });
        return elementList;
    }
}

