/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.biz.callback.PromptNodeCallbackImpl;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class PromptNodeApplicationImpl
extends AbstractNodeApplication<LLMAction> {
    private static final Log log = LogFactory.getLog(PromptNodeApplicationImpl.class);
    private static final int USER_HISTORY_COUNT = 200;

    public PromptNodeApplicationImpl(Context context, Flow gaiFlow, LLMAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        long start = System.currentTimeMillis();
        LLMActionMessage message = this.buildLLMActionMessage(e);
        this.getLog(e).logInput("message", message);
        LLMActionCallbackMessage callbackMessage = new LLMActionCallbackMessage();
        callbackMessage.setErrCode(Errors.OK.getCode());
        callbackMessage.setParseOutput(true);
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setPageId(this.context.getAssistantPageId());
        callbackMessage.setChatSessionId(this.context.getChatSessionId());
        callbackMessage.setGlobalSessionId(this.context.getGlobalSessionId());
        callbackMessage.setMergeLastMessageCard(message.isMergeLastMessageCard());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        int promptType = ((LLMAction)this.action).getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            llmMessage.setUserInput(message.getUserInput());
            llmMessage.setPromptId(message.getPromptId());
            llmMessage.setRepoIdList(message.getRepoIdList());
        } else {
            LLM llm;
            Prompt prompt = new Prompt();
            prompt.setId(2002989110637102080L);
            String serviceNumber = message.getLlm();
            prompt.setServiceNumber(message.getLlm());
            Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
            if (service == null || service.isEmpty()) {
                throw new KDBizException(Errors.NO_AICC_SERVICE, new Object[0]);
            }
            String llmNumber = (String)service.get("llm");
            if (kd.bos.util.StringUtils.isEmpty((String)llmNumber)) {
                llmNumber = serviceNumber;
            }
            if ((llm = LLM.parse(llmNumber)) == null) {
                throw new KDBizException(Errors.NO_LLM_4_AICC_SERVICE(llmNumber), new Object[0]);
            }
            prompt.setLlm(llm);
            prompt.setRemembercount(0);
            prompt.setLlmStyle(LlmStyle.PRECISION);
            prompt.setReference(Boolean.FALSE);
            prompt.setChunkIdList(null);
            String userPrompt = message.getPromptTemplateContent().getUserPrompt();
            String sysPrompt = message.getPromptTemplateContent().getSysPrompt();
            Map<String, String> paramMap = message.getParams();
            String filledUserPrompt = this.fillVariable(userPrompt, paramMap);
            String filledSysPrompt = this.fillVariable(sysPrompt, paramMap);
            prompt.setPrompt(filledSysPrompt);
            llmMessage.setUserInput(filledUserPrompt);
            prompt.setPromptType(((LLMAction)this.action).getPromptType());
            List<ParamDefinition> outputParamDefList = ((LLMAction)this.action).getParamByGroup(((LLMAction)this.action).getOutputParamGroup());
            ArrayList<PromptOutVar> promptOutVarList = new ArrayList<PromptOutVar>(outputParamDefList.size());
            for (ParamDefinition paramDef : outputParamDefList) {
                PromptOutVar promptOutVar = new PromptOutVar();
                promptOutVar.setVar(paramDef.getName());
                promptOutVar.setName(paramDef.getDescription());
                if (paramDef.getName().equalsIgnoreCase(OutPreVar.GPT_OUTPUT.getVar())) {
                    promptOutVar.setJsonAnalysis(false);
                } else {
                    promptOutVar.setJsonAnalysis(true);
                }
                promptOutVarList.add(promptOutVar);
            }
            prompt.setPromptOutVarList(promptOutVarList);
            llmMessage.setPrompt(prompt);
        }
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(message.getParams());
        llmMessage.setSync(message.isSync());
        Result result = HandlerFactory.runHandler(this.context, llmMessage);
        result.setCallback(!message.isSync());
        if (!result.getErrorCode().equals((Object)Errors.OK)) {
            log.info("flow error result {}", (Object)JsonUtil.toJson(result));
            if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                PromptNodeApplicationImpl.flowEnd(this.context, this.gaiFlow.getId(), result.getErrorCode(), result.getErrorCode().getMessage());
                return;
            }
            PromptNodeApplicationImpl.flowError(this.context, this.gaiFlow.getId(), result.getErrorCode());
            return;
        }
        long end = System.currentTimeMillis();
        Node node = this.gaiFlow.findNodeById(((LLMAction)this.action).getId());
        TraceUtil.saveFlowNodeLog(result, this.context, this.gaiFlow, node, message, this.action, start, end, result.getData());
        if (message.isSync()) {
            this.getLog(e).logMetaData("taskId", result.getData().get("taskId"));
            PromptNodeApplicationImpl.syncCallback(result, callbackMessage);
            new PromptNodeCallbackImpl(this.context, this.gaiFlow, (LLMAction)this.action).inject(e, callbackMessage);
        } else {
            this.getLog(e).logMetaData("taskId", result.getTaskId());
        }
    }

    public static void syncCallback(Result result, LLMParsedMessage callbackMessage) {
        Map<String, String> data = result.getData();
        callbackMessage.setLlmValue(data.get("llmValue"));
        callbackMessage.setAllMsg(data.get("llmValue"));
        callbackMessage.setTaskId(data.get("taskId"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)data.get("jsonValue"))) {
            callbackMessage.setJsonValue((Map)SerializationUtils.fromJsonString((String)data.get("jsonValue"), Map.class));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)data.get("citationInfos"))) {
            List citationInfos = SerializationUtils.fromJsonStringToList((String)data.get("citationInfos"), KnowledgeCitationData.class);
            callbackMessage.setCitationInfos(citationInfos);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)data.get("searchInfos"))) {
            List searchInfos = SerializationUtils.fromJsonStringToList((String)data.get("searchInfos"), LLMSearchInfo.class);
            callbackMessage.setSearchInfos(searchInfos);
        }
        callbackMessage.setStream(false);
        callbackMessage.setEnd(true);
    }

    public static Result flowEnd(Context context, long flowId, ErrorCode errorCode, String msg) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        flowErrorMessage.setMsg(msg);
        log.info("flow end {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static Result flowError(Context context, long flowId, ErrorCode errorCode) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        log.info("flow error {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public LLMActionMessage buildLLMActionMessage(Execution e) {
        LLMActionMessage message = new LLMActionMessage();
        message.setChatSessionId(this.context.getChatSessionId());
        message.setFlowId(this.gaiFlow.getId());
        message.setNodeId(((LLMAction)this.action).getId());
        message.setStream(((LLMAction)this.action).isStream());
        message.setMergeLastMessageCard(((LLMAction)this.action).isMergeLastMessageCard());
        int promptType = ((LLMAction)this.action).getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            message.setPromptId(((LLMAction)this.action).getLlmPromptId());
            message.setUserInput(this.getUserInput(e));
            message.setRepoIdList(this.getRepoIdList(e));
            message.setParams(this.toStringMap(this.getInputParamMap(e)));
        } else {
            message.setLlm(((LLMAction)this.action).getLlm());
            message.setPromptTemplateContent(((LLMAction)this.action).getPromptTemplateContent());
            message.setParams(this.toStringMap(this.getInputParamMap(e)));
        }
        if (((LLMAction)this.action).isBlockInnerNode() && this.gaiFlow.findNodeById(((LLMAction)this.action).getBlockNodeId()).isParallelBlockNode()) {
            message.setSync(true);
        }
        return message;
    }

    private List<Long> getRepoIdList(Execution e) {
        Object repoIds;
        Optional<ParamDefinition> repoParamDef = ((LLMAction)this.action).getParamByName(((LLMAction)this.action).getInputParamGroup(), "repoMapper");
        if (repoParamDef.isPresent() && (repoIds = this.getParamManager().getParamValue(e, this.action, repoParamDef.get())) != null && kd.bos.util.StringUtils.isNotEmpty((String)repoIds.toString())) {
            String[] idArray = repoIds.toString().split(",");
            ArrayList<Long> repoIdList = new ArrayList<Long>(idArray.length);
            for (String idStr : idArray) {
                repoIdList.add(Long.parseLong(idStr.trim()));
            }
            return repoIdList;
        }
        return Collections.emptyList();
    }

    @Override
    protected String getUserInput(Execution e) {
        Optional<ParamDefinition> userInputParam = ((LLMAction)this.action).getParamByName("DEFAULT_GROUP", "userInputMapper");
        Object userInputValue = "";
        userInputValue = userInputParam.isPresent() ? this.getParamManager().getParamValue(e, this.action, userInputParam.get()) : super.getUserInput(e);
        return userInputValue == null ? "" : userInputValue.toString();
    }

    public String fillVariable(String template, Map<String, String> variableMap) {
        if (StringUtils.isBlank((CharSequence)template) || variableMap == null || variableMap.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            template = StringUtils.replace((String)template, (String)("{{" + key + "}}"), (String)value);
        }
        return template;
    }
}

