/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.BillNLQueryAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.QueryEntityConfig;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.QueryEntityCallbackMessage;
import kd.ai.gai.core.engine.message.QueryEntityMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.EntityMetaService;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class QueryEntityNodeApplicationImpl
extends AbstractNodeApplication<BillNLQueryAction> {
    private static final Log log = LogFactory.getLog(QueryEntityNodeApplicationImpl.class);
    private static final String queryEntiyKey = "entity_key";

    public QueryEntityNodeApplicationImpl(Context context, Flow gaiFlow, BillNLQueryAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        LLM llm;
        log.info("QueryEntityHandler process");
        long start = System.currentTimeMillis();
        QueryEntityMessage message = this.buildQueryEntityMessage(e);
        this.getLog(e).logInput("message", message);
        QueryEntityConfig queryEntityConfig = message.getQueryEntityConfig();
        String serviceNumber = queryEntityConfig.getLlm();
        String metaData = ((BillNLQueryAction)this.action).getMetaData();
        String selectProperties = null;
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("id");
        JSONObject root = JSONObject.parseObject((String)((BillNLQueryAction)this.action).getMetaData());
        if (root != null) {
            JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
            for (int i = 0; i < fieldInfoList.size(); ++i) {
                JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
                JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
                for (JSONObject plainField : plainFieldList) {
                    String fieldId = plainField.getString("fieldId");
                    if (fieldId.equalsIgnoreCase("id")) continue;
                    filters.add(fieldId);
                }
            }
        }
        selectProperties = String.join((CharSequence)",", filters);
        String billId = ((BillNLQueryAction)this.action).getBillId();
        QueryEntityCallbackMessage queryEntityCallbackMessage = new QueryEntityCallbackMessage();
        queryEntityCallbackMessage.setErrCode(Errors.OK.getCode());
        queryEntityCallbackMessage.setParseOutput(false);
        queryEntityCallbackMessage.setFlowId(message.getFlowId());
        queryEntityCallbackMessage.setNodeId(message.getNodeId());
        queryEntityCallbackMessage.setPageId(this.context.getAssistantPageId());
        queryEntityCallbackMessage.setChatSessionId(this.context.getChatSessionId());
        queryEntityCallbackMessage.setGlobalSessionId(this.context.getGlobalSessionId());
        queryEntityCallbackMessage.setShowMessage(false);
        queryEntityCallbackMessage.setStartTs(start);
        queryEntityCallbackMessage.setEntityNumber(billId);
        queryEntityCallbackMessage.setSelectProperties(selectProperties);
        queryEntityCallbackMessage.setMetaData(metaData);
        FlowRuntime runtime = e.getRuntime();
        Map runtimeDoc = runtime.toJson();
        queryEntityCallbackMessage.setRuntimeDoc(runtimeDoc);
        queryEntityCallbackMessage.setMemoryProperties(JsonUtil.toJson(e.getMemory().getProperties()));
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(queryEntityCallbackMessage);
        queryEntityConfig.setVarMap(this.toStringMap(this.getInputParamMap(e)));
        Map<String, String> varMap = queryEntityConfig.getVarMap();
        Prompt prompt = new Prompt();
        prompt.setId(2002989110637102080L);
        prompt.setServiceNumber(serviceNumber);
        Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
        if (service == null || service.isEmpty()) {
            throw new KDBizException(Errors.NO_AICC_SERVICE, new Object[0]);
        }
        String llmNumber = (String)service.get("llm");
        if (kd.bos.util.StringUtils.isEmpty((String)llmNumber)) {
            llmNumber = serviceNumber;
        }
        if ((llm = LLM.parse(llmNumber)) == null) {
            throw new KDBizException(Errors.NO_LLM_4_AICC_SERVICE(llmNumber), new Object[0]);
        }
        prompt.setLlm(llm);
        prompt.setRemembercount(0);
        prompt.setLlmStyle(LlmStyle.PRECISION);
        prompt.setPrompt(queryEntityConfig.getSysPrompt());
        prompt.setReference(false);
        String userPrompt = queryEntityConfig.getUserPrompt();
        log.info("varMap : {}", varMap);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        log.info("paramMap : {}", paramMap);
        String filter = ((BillNLQueryAction)this.action).getFilter();
        ArrayList<String> entityList = new ArrayList<String>(10);
        entityList.add(billId);
        List<String> stringList = QueryEntityNodeApplicationImpl.extractFieldId(filter);
        String entity = (String)EngineCache.getAppCache(this.context.getChatSessionId()).get(queryEntiyKey, String.class);
        if (entity == null) {
            entity = EntityMetaService.entityMetaQueryFilter(entityList, stringList);
            EngineCache.getAppCache(this.context.getChatSessionId()).put(queryEntiyKey, (Object)entity);
        }
        String filledUserPrompt = this.fillVariable(userPrompt, varMap);
        llmMessage.setUserInput(filledUserPrompt);
        paramMap.put("entity", entity);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        paramMap.put("today", simpleDateFormat.format(new Date()));
        String filledSysPrompt = this.fillVariable(prompt.getPrompt(), paramMap);
        prompt.setPrompt(filledSysPrompt);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(false);
        llmMessage.setParamMap(paramMap);
        llmMessage.setSync(message.isSync());
        message.setSync(false);
        Result result = HandlerFactory.runHandler(this.context, llmMessage);
        this.getLog(e).logMetaData("taskId", result.getTaskId());
        result.setCallback(!message.isSync());
        if (!result.getErrorCode().equals((Object)Errors.OK)) {
            log.info("flow error result {}", (Object)JsonUtil.toJson(result));
            if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                QueryEntityNodeApplicationImpl.flowEnd(this.context, this.gaiFlow.getId(), result.getErrorCode(), result.getErrorCode().getMessage());
                return;
            }
            QueryEntityNodeApplicationImpl.flowError(this.context, this.gaiFlow.getId(), result.getErrorCode());
            return;
        }
        this.getLog(e).logMetaData("taskId", result.getTaskId());
    }

    public static Result flowEnd(Context context, long flowId, ErrorCode errorCode, String msg) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        flowErrorMessage.setMsg(msg);
        log.info("flow end {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static Result flowError(Context context, long flowId, ErrorCode errorCode) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        log.info("flow error {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static List<String> extractFieldId(String jsonString) {
        JSONObject root = JSONObject.parseObject((String)jsonString);
        JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
        ArrayList<String> fieldIdList = new ArrayList<String>();
        for (int i = 0; i < fieldInfoList.size(); ++i) {
            JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
            JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
            for (int j = 0; j < plainFieldList.size(); ++j) {
                JSONObject plainField = plainFieldList.getJSONObject(j);
                String fieldId = plainField.getString("fieldId");
                if (fieldId == null) continue;
                fieldIdList.add(fieldId);
            }
        }
        return fieldIdList;
    }

    public QueryEntityMessage buildQueryEntityMessage(Execution e) {
        QueryEntityMessage message = new QueryEntityMessage();
        QueryEntityConfig queryEntityConfig = ((BillNLQueryAction)this.action).getQueryENtityConfig();
        String userInput = this.getUserInput(e);
        queryEntityConfig.setUserInput(userInput);
        message.setQueryEntityConfig(queryEntityConfig);
        message.setChatSessionId(this.context.getChatSessionId());
        message.setFlowId(this.gaiFlow.getId());
        message.setNodeId(((BillNLQueryAction)this.action).getId());
        message.setSync(false);
        return message;
    }

    public String fillVariable(String template, Map<String, String> variableMap) {
        if (StringUtils.isBlank((CharSequence)template) || variableMap == null || variableMap.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            template = StringUtils.replace((String)template, (String)("{{" + key + "}}"), (String)value);
        }
        return template;
    }
}

