/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.repo.GaiRepoSearchData;
import kd.ai.gai.core.domain.mservice.GaiRagSearchParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RetrievalConfig;
import kd.ai.gai.core.engine.message.RepoMessage;
import kd.ai.gai.core.flow.biz.application.AbstractParallelNodeApplication;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.KmServiceHelper;
import kd.ai.gai.core.rag.service.RagService;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.result.DocumentRepoResult;
import kd.ai.gai.core.repo.result.MetaRepoResult;
import kd.ai.gai.core.repo.result.RepoSearchResult;
import kd.ai.gai.core.repo.result.StructuredRepoResult;
import kd.ai.gai.core.repo.result.UniversalRepoResult;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.structured.QureyStructuredNodeDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchStructuredDataParam;
import kd.ai.gai.core.search.index.param.structured.StructuredNodeData;
import kd.ai.gai.core.search.index.param.structured.StructuredRowData;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RepoNodeApplicationImpl
extends AbstractParallelNodeApplication<RepoAction> {
    private static final Log log = LogFactory.getLog(RepoNodeApplicationImpl.class);

    public RepoNodeApplicationImpl(Context context, Flow gaiFlow, RepoAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        long start = System.currentTimeMillis();
        log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u5904\u7406\u5f00\u59cb");
        this.checkLicense();
        RepoMessage message = this.buildRepoMessage(e);
        this.getLog(e).logInput("message", message);
        this.executeKnowledgeSearch(e, message);
        this.finishProcessing(e);
    }

    private void checkLicense() {
        if (Context.needCheckLicense(this.context)) {
            log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u68c0\u7d22\u8bb8\u53ef\u68c0\u67e5-\u5f00\u59cb");
            GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
            log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u68c0\u7d22\u8bb8\u53ef\u68c0\u67e5-\u5b8c\u6210");
        }
    }

    private void executeKnowledgeSearch(Execution e, RepoMessage message) {
        RepoSearchResult result;
        String repoType;
        switch (repoType = ((RepoAction)this.action).getRepoType()) {
            case "select": 
            case "dynamic": {
                result = this.searchDocumentRepository(message);
                break;
            }
            case "structure": {
                result = this.searchStructuredRepository(message);
                break;
            }
            case "meta": {
                result = this.searchMetaRepository(message);
                break;
            }
            case "universal": {
                result = this.searchUniversalRepository(message);
                break;
            }
            case "dynamic_universal": {
                result = this.searchDynamicUniversalRepository(message);
                break;
            }
            default: {
                throw new KDBizException(Errors.notSupportRepoType(repoType), new Object[0]);
            }
        }
        this.setOutputParameter(e, result);
    }

    private RepoMessage buildRepoMessage(Execution e) {
        RepoMessage message = new RepoMessage();
        message.setChatSessionId(this.context.getChatSessionId());
        message.setFlowId(this.gaiFlow.getId());
        message.setNodeId(((RepoAction)this.action).getId());
        message.setRepoType(((RepoAction)this.action).getRepoType());
        Object value = this.getParamManager().getParamValue(e, ((RepoAction)this.action).getId(), "query", ParamDirection.INPUT);
        message.setQuery(String.valueOf(value));
        RetrievalConfig retrievalConfig = ((RepoAction)this.action).getRetrievalConfig();
        if (retrievalConfig != null) {
            message.setSimilarity(retrievalConfig.getSimilarity());
            String mode = retrievalConfig.getMode();
            if ("TEXT_QA".equals(mode)) {
                message.setSimilarity(0.0f);
            }
            message.setRerankModelNumber(retrievalConfig.getRerankModelNumber());
            message.setTopK(retrievalConfig.getTopK());
            message.setRequestType(mode);
        }
        if ("dynamic".equals(((RepoAction)this.action).getRepoType())) {
            List<Long> repoIds = this.getDynamicRepositoryIds(e);
            message.setRepoIdList(repoIds);
        } else if ("select".equals(((RepoAction)this.action).getRepoType())) {
            message.setRepoIdList(((RepoAction)this.action).getRepoList());
        }
        message.setUniversalIdList(((RepoAction)this.action).getUniversalIdList());
        if (StringUtils.equals((CharSequence)((RepoAction)this.action).getRepoType(), (CharSequence)"dynamic_universal")) {
            JSONArray jsonArr = this.getUniversalDyRepoIds(e);
            message.setUniversalDyRepoInfo(jsonArr);
        }
        message.setStructureId(((RepoAction)this.action).getStructureId());
        message.setMetaIdList(((RepoAction)this.action).getMetaIdList());
        message.setReRank(((RepoAction)this.action).isReRank());
        return message;
    }

    private void setOutputParameter(Execution e, RepoSearchResult<?> result) {
        ParamDefinition outputParam = ((RepoAction)this.action).getParamByName(((RepoAction)this.action).getOutputParamGroup(), "outputList").orElseThrow(() -> new RuntimeException("setOutputParameter error, can't find result"));
        this.getParamManager().setParamValue(e, this.action, outputParam, result.getItems());
    }

    private DocumentRepoResult searchDocumentRepository(RepoMessage message) {
        GaiRagSearchParams searchParams = new GaiRagSearchParams(message.getRepoIdList(), message.getTopK(), message.getSimilarity(), message.getQuery(), message.getRequestType(), message.isReRank());
        List<GaiRepoSearchData> searchDataList = RagService.retrievalComponent(this.context, searchParams);
        DocumentRepoResult result = new DocumentRepoResult();
        result.setQuery(message.getQuery());
        result.setSimilarity(message.getSimilarity());
        result.setTopK(message.getTopK());
        result.convertToItems(searchDataList);
        log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c\u6570\u91cf:[{}]", (Object)searchParams.toString(), (Object)searchDataList.size());
        return result;
    }

    private StructuredRepoResult searchStructuredRepository(RepoMessage message) {
        SearchStructuredDataParam searchParams = new SearchStructuredDataParam(message.getStructureId(), message.getQuery(), message.getTopK(), message.getSimilarity(), message.isReRank());
        StructuredRowData searchResult = StructuredRepoServiceHelper.search(searchParams);
        log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c\u6570\u91cf:[{}]", (Object)searchParams.toString(), (Object)searchResult.getDataList().size());
        StructuredRepoResult result = new StructuredRepoResult();
        result.setQuery(message.getQuery());
        result.setSimilarity(message.getSimilarity());
        result.setTopK(message.getTopK());
        List<Map<String, Object>> dataList = searchResult.getDataList();
        if (dataList == null || dataList.isEmpty()) {
            result.setItems(new ArrayList<String>(1));
        } else if (searchResult.getType().equals(RepoConstant.RepoType.LEVEL.getType())) {
            ArrayList<Long> dataIdList = new ArrayList<Long>(10);
            for (Map<String, Object> item : dataList) {
                Object idO;
                if (item == null || (idO = item.get("id")) == null) continue;
                dataIdList.add(Long.parseLong(idO + ""));
            }
            QureyStructuredNodeDataParam param = new QureyStructuredNodeDataParam(message.getStructureId(), dataIdList);
            List<StructuredNodeData> structuredNodeData = StructuredRepoServiceHelper.queryNodeData(param);
            JSONArray structArr = JSONArray.parseArray((String)JSON.toJSONString(structuredNodeData));
            ArrayList<String> structs = new ArrayList<String>(structArr.size());
            for (int i = 0; i < structArr.size(); ++i) {
                structs.add(structArr.getString(i));
            }
            result.setItems(structs);
        } else {
            JSONArray structArr = JSONArray.parseArray((String)JSON.toJSONString(dataList));
            ArrayList<String> structs = new ArrayList<String>(structArr.size());
            for (int i = 0; i < structArr.size(); ++i) {
                structs.add(structArr.getString(i));
            }
            result.setItems(structs);
        }
        return result;
    }

    private MetaRepoResult searchMetaRepository(RepoMessage message) {
        JSONObject paramJsonObj = new JSONObject();
        paramJsonObj.put("query", (Object)message.getQuery());
        paramJsonObj.put("entityIds", message.getMetaIdList());
        paramJsonObj.put("searchType", (Object)message.getRequestType());
        paramJsonObj.put("topK", (Object)message.getTopK());
        paramJsonObj.put("threshold", (Object)Float.valueOf(message.getSimilarity()));
        paramJsonObj.put("rerank", (Object)message.isReRank());
        Map resultMap = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"RetrievalService", (String)"retrieval", (Object[])new Object[]{paramJsonObj.toJSONString()});
        log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u5143\u6a21\u578b\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}]", (Object)paramJsonObj.toJSONString());
        MetaRepoResult result = new MetaRepoResult();
        result.setQuery(message.getQuery());
        result.setSimilarity(message.getSimilarity());
        result.setTopK(message.getTopK());
        List datas = (List)resultMap.get("results");
        result.convertToItems(datas);
        return result;
    }

    private UniversalRepoResult searchUniversalRepository(RepoMessage message) {
        List<Long> universalIdList = message.getUniversalIdList().stream().map(Long::valueOf).collect(Collectors.toList());
        String requestType = message.getRequestType();
        JSONArray resultJsonArr = KmServiceHelper.retrieval(message.getQuery(), universalIdList, requestType, message.getTopK(), StringUtils.equals((CharSequence)requestType, (CharSequence)"TEXT_QA") ? 0.0f : message.getSimilarity(), message.isReRank(), message.getRerankModelNumber());
        if ((StringUtils.equals((CharSequence)requestType, (CharSequence)"Q_ONLY") || StringUtils.equals((CharSequence)requestType, (CharSequence)"QA_ONLY")) && CollectionUtils.isEmpty((Collection)resultJsonArr)) {
            resultJsonArr = KmServiceHelper.retrieval(message.getQuery(), universalIdList, "TEXT_QA", message.getTopK(), 0.0f, message.isReRank(), message.getRerankModelNumber());
        }
        log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u901a\u7528\u77e5\u8bc6\u5e93\u68c0\u7d22,\u67e5\u8be2:[{}],\u77e5\u8bc6\u5e93:[{}],\u68c0\u7d22\u7ed3\u679c\u6570\u91cf:[{}]", new Object[]{message.getQuery(), universalIdList, resultJsonArr.size()});
        UniversalRepoResult result = new UniversalRepoResult();
        result.setQuery(message.getQuery());
        result.setSimilarity(message.getSimilarity());
        result.setTopK(message.getTopK());
        result.convertToItems(resultJsonArr);
        return result;
    }

    private UniversalRepoResult searchDynamicUniversalRepository(RepoMessage message) {
        JSONArray universalDyRepoJsonArr = message.getUniversalDyRepoInfo();
        if (CollectionUtils.isEmpty((Collection)universalDyRepoJsonArr)) {
            log.error("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b),\u77e5\u8bc6\u5e93\u4fe1\u606f\u4e3a\u7a7a");
            throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
        }
        ArrayList repoList = Lists.newArrayListWithExpectedSize((int)universalDyRepoJsonArr.size());
        for (int i = 0; i < universalDyRepoJsonArr.size(); ++i) {
            JSONObject repoJsonObj = universalDyRepoJsonArr.getJSONObject(i);
            Long repoId = repoJsonObj.getLong("ukmId");
            HashMap repoMap = Maps.newHashMapWithExpectedSize((int)2);
            repoMap.put("k", repoId);
            JSONArray groupNumberJsonArr = repoJsonObj.getJSONArray("groupNumber");
            if (CollectionUtils.isNotEmpty((Collection)groupNumberJsonArr)) {
                String[] groupArr = new String[groupNumberJsonArr.size()];
                for (int j = 0; j < groupNumberJsonArr.size(); ++j) {
                    groupArr[j] = groupNumberJsonArr.getString(j);
                }
                repoMap.put("g", groupArr);
            }
            repoList.add(repoMap);
        }
        String requestType = message.getRequestType();
        JSONArray resultJsonArr = KmServiceHelper.retrievalWithGroup(message.getQuery(), repoList, requestType, message.getTopK(), StringUtils.equals((CharSequence)requestType, (CharSequence)"TEXT_QA") ? 0.0f : message.getSimilarity(), message.isReRank(), message.getRerankModelNumber());
        if (CollectionUtils.isEmpty((Collection)resultJsonArr) && (StringUtils.equals((CharSequence)requestType, (CharSequence)"Q_ONLY") || StringUtils.equals((CharSequence)requestType, (CharSequence)"QA_ONLY"))) {
            resultJsonArr = KmServiceHelper.retrievalWithGroup(message.getQuery(), repoList, "TEXT_QA", message.getTopK(), 0.0f, message.isReRank(), message.getRerankModelNumber());
        }
        log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b)\u68c0\u7d22,\u68c0\u7d22\u7ed3\u679c:[{}]", (Object)resultJsonArr.toJSONString());
        UniversalRepoResult result = new UniversalRepoResult();
        result.setQuery(message.getQuery());
        result.setSimilarity(message.getSimilarity());
        result.setTopK(message.getTopK());
        result.convertToItems(resultJsonArr);
        return result;
    }

    private List<Long> getDynamicRepositoryIds(Execution execution) {
        ParamDefinition repoParam = ((RepoAction)this.action).getParamByName("DEFAULT_GROUP", "repoMapper").orElse(null);
        if (repoParam == null) {
            return new ArrayList<Long>();
        }
        try {
            Object repoValue = this.getParamManager().getParamValue(execution, this.action, repoParam);
            if (repoValue == null) {
                return new ArrayList<Long>();
            }
            String repoIds = repoValue.toString();
            return Arrays.stream(repoIds.split(",")).map(String::trim).map(Long::parseLong).collect(Collectors.toList());
        }
        catch (Exception ex) {
            log.error("\u52a8\u6001\u77e5\u8bc6\u5e93ID\u83b7\u53d6\u5931\u8d25", (Throwable)ex);
            throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
        }
    }

    private JSONArray getUniversalDyRepoIds(Execution execution) {
        ParamDefinition universalRepoMapper = ((RepoAction)this.action).getParamByName("DEFAULT_GROUP", "universalRepoMapper").orElse(null);
        if (universalRepoMapper == null) {
            return new JSONArray();
        }
        try {
            Object repoValue = this.getParamManager().getParamValue(execution, this.action, universalRepoMapper);
            if (repoValue == null) {
                return new JSONArray();
            }
            return JSONArray.parseArray((String)repoValue.toString());
        }
        catch (Exception ex) {
            log.error("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b),\u83b7\u53d6\u77e5\u8bc6\u5e93\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
            throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
        }
    }

    private void finishProcessing(Execution e) {
        ((RepoAction)this.action).setName(e.getDefine().getTitle());
    }
}

