/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.FlowFile;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.Attachment;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.engine.sys.action.ChatHistoryMessageAction;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.execution.IParamManager;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class StartNodeApplicationImpl
extends AbstractNodeApplication<Start>
implements Application,
DebuggerAction {
    private static final Log logger = LogFactory.getLog(StartNodeApplicationImpl.class);
    private static final int USER_HISTORY_COUNT = 200;

    public StartNodeApplicationImpl(Context context, Flow gaiFlow, Start action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        StartFlowMessage startFlowMessage = (StartFlowMessage)JSON.parseObject((String)((String)e.get("startFlowMessage")), StartFlowMessage.class);
        this.setOutputParams(e, startFlowMessage);
        PushMsgService.pushWaiting(this.context, this.gaiFlow.getId(), null);
    }

    private void setOutputParams(Execution e, StartFlowMessage startFlowMessage) {
        List<ParamDefinition> outputParams = ((Start)this.action).getParamByDirection(ParamDirection.BOTH, ParamDirection.OUTPUT);
        Map<String, String> mapInParams = startFlowMessage.getInParams();
        IParamManager paramManager = this.getParamManager();
        block20: for (ParamDefinition paramDefinition : outputParams) {
            if (paramDefinition.isConstant()) continue;
            switch (paramDefinition.getName()) {
                case "system.user_input": {
                    paramManager.setParamValue(e, this.action, paramDefinition, mapInParams.getOrDefault("system.user_input", startFlowMessage.getUserInput()));
                    continue block20;
                }
                case "system.chat_sessionid": {
                    paramManager.setParamValue(e, this.action, paramDefinition, this.context.getChatSessionId());
                    continue block20;
                }
                case "system.skill_id": {
                    paramManager.setParamValue(e, this.action, paramDefinition, startFlowMessage.getProcessId());
                    continue block20;
                }
                case "system.chat_history": {
                    UserHistoryMessage[] userHistoryMessage = ChatHistoryService.getByChatSessionId(200, this.context.getChatSessionId());
                    paramManager.setParamValue(e, this.action, paramDefinition, JsonUtil.toJson(userHistoryMessage));
                    continue block20;
                }
                case "system.user_chat_history": {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("chatSessionId", this.context.getChatSessionId());
                    params.put("enableTop", "true");
                    params.put("top", "10");
                    Map<String, String> chatHistoryMessages = new ChatHistoryMessageAction().invokeAction("", params);
                    paramManager.setParamValue(e, this.action, paramDefinition, chatHistoryMessages.getOrDefault("history", "[]"));
                    continue block20;
                }
                case "system.chat_environment": {
                    paramManager.setParamValue(e, this.action, paramDefinition, this.context.getClientType());
                    continue block20;
                }
                case "system.files": {
                    this.setFiles(e, paramDefinition, mapInParams.getOrDefault("system.user_gai_attachments_id", ""));
                    continue block20;
                }
                case "system.execute_date": {
                    paramManager.setParamValue(e, this.action, paramDefinition, KDDateUtils.now());
                    continue block20;
                }
            }
            if (!mapInParams.containsKey(paramDefinition.getName())) continue;
            paramManager.setParamValue(e, this.action, paramDefinition, mapInParams.get(paramDefinition.getName()));
        }
    }

    private void setFiles(Execution e, ParamDefinition filesParamDefinition, String fieldIds) {
        List<String> fieldIdList = Arrays.asList(fieldIds.split(","));
        List<Attachment> attachments = FileService.queryAttachmentList(fieldIdList);
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>(attachments.size());
        for (Attachment attachment : attachments) {
            FlowFile flowFile = new FlowFile();
            flowFile.setId(attachment.getAttPk());
            flowFile.setName(attachment.getFileName());
            flowFile.setUrl(attachment.getFileUrl());
            flowFiles.add(flowFile);
        }
        this.getParamManager().setParamValue(e, this.action, filesParamDefinition, flowFiles);
    }
}

