/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPI;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.agent.tool.ToolService;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.ToolMessage;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.service.agent.CosmicOpenAPIService;
import kd.ai.gai.core.service.agent.MCPService;
import kd.ai.gai.core.service.agent.RestfulAPIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ToolNodeApplicationImpl
extends AbstractNodeApplication<ToolAction> {
    private static final Log log = LogFactory.getLog(ToolNodeApplicationImpl.class);
    private static final int DEFAULT_PAGE_SIZE = 10;

    public ToolNodeApplicationImpl(Context context, Flow gaiFlow, ToolAction action) {
        super(context, gaiFlow, action);
    }

    public boolean isJSONValid(String json) {
        try {
            JSON.parse((String)json);
            return true;
        }
        catch (JSONException ex) {
            return false;
        }
    }

    private BaseResult functionCall(Map<String, Object> toolRequestParams) {
        String type = (String)toolRequestParams.get("type");
        switch (ToolConstant.ToolType.valueOf(type.toUpperCase())) {
            case RESTFUL_API: {
                return this.restfulApi(toolRequestParams);
            }
            case MCP_TOOL: {
                return this.callMcpTool(toolRequestParams);
            }
            case COSMIC_ACTION: {
                return ToolService.toolService(toolRequestParams);
            }
            case INTERNAL_MCP: {
                return this.callInternalMcpTool(toolRequestParams);
            }
        }
        return null;
    }

    private BaseResult callInternalMcpTool(Map<String, Object> toolRequestParams) {
        Object operationId = toolRequestParams.get("operationId");
        Long apiId = Long.parseLong(String.valueOf(operationId));
        HashMap param = (HashMap)toolRequestParams.get("params");
        if (param == null) {
            param = new HashMap();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        for (Map.Entry entry : param.entrySet()) {
            Boolean isJson = this.isJSONValid(String.valueOf(entry.getValue()));
            if (isJson.booleanValue()) {
                body.put((String)entry.getKey(), JSON.parse((String)String.valueOf(entry.getValue())));
                continue;
            }
            body.put((String)entry.getKey(), entry.getValue());
        }
        if (!body.containsKey("pageSize")) {
            body.put("pageSize", 10);
        }
        log.info("openApiFunction data:{}", (Object)JSONObject.toJSONString(param.get("data")));
        body.put("optionvariables", ImmutableMap.builder().put((Object)"mutex_ignoremodify", (Object)"true").put((Object)"isStrict", (Object)"false").put((Object)"ignoreValidation", (Object)"true").build());
        log.info("openApiFunction param:{}", (Object)JSONObject.toJSONString(param));
        HashMap<String, String> header = new HashMap<String, String>(0);
        CosmicOpenAPI api = new CosmicOpenAPI(apiId, body, header);
        OpenApiResult result = CosmicOpenAPIService.getService().call(api);
        log.info("openApiFunction result:{}", (Object)JSONObject.toJSONString((Object)result));
        BaseResult br = new BaseResult(result != null ? JSONObject.toJSONString((Object)result) : "");
        br.setErrCode(result != null ? result.getErrorCode() : "1");
        br.setErrMsg(result != null ? result.getMessage() : "");
        return br;
    }

    public BaseResult callMcpTool(Map<String, Object> toolRequestParams) {
        AgentTool agentTool = AgentToolService.getAgentTool((Long)toolRequestParams.get("toolId"));
        JSONObject configTag = agentTool.getConfigTag();
        MCPTool mcpTool = new MCPTool();
        JSONObject toolParams = new JSONObject();
        Object operationId = toolRequestParams.get("operationId");
        toolParams.put("operationId", operationId);
        toolParams.put("parameters", toolRequestParams.get("params"));
        mcpTool.setToolId((Long)toolRequestParams.get("toolId"));
        mcpTool.setToolParams(toolParams);
        mcpTool.setChatSessionId(String.valueOf(toolRequestParams.get("chatSessionId")));
        log.info("mcp operationId:{}", operationId);
        log.info("tool function api.mcpTool:{}, configTag:{}", (Object)JSONObject.toJSONString((Object)mcpTool), (Object)configTag);
        BaseResult result = MCPService.getService().callApi(configTag.toJSONString(), mcpTool);
        log.info("mcp result:{}", (Object)result.toString());
        return result;
    }

    public BaseResult restfulApi(Map<String, Object> toolRequestParams) {
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolRequestParams.get("toolId"), (String)"gai_tool");
        String configTag = tool.getString("config_tag");
        Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(configTag, new String[0]);
        OperationParam operationParam = operationParamMap.get(toolRequestParams.get("operationId"));
        RestfulAPI api = new RestfulAPI();
        JSONObject body = new JSONObject();
        JSONArray getParameters = new JSONArray();
        Map params = (Map)toolRequestParams.get("params");
        for (Map.Entry entry : params.entrySet()) {
            Boolean isJson = this.isJSONValid((String)entry.getValue());
            if (isJson.booleanValue()) {
                body.put((String)entry.getKey(), JSON.parse((String)((String)entry.getValue())));
            } else {
                body.put((String)entry.getKey(), entry.getValue());
            }
            JSONObject json = new JSONObject();
            json.put("name", entry.getKey());
            json.put("value", entry.getValue());
            getParameters.add((Object)json);
        }
        JSONObject toolParams = new JSONObject();
        toolParams.put("operationId", toolRequestParams.get("operationId"));
        JSONArray parameters = new JSONArray();
        toolParams.put("parameters", (Object)parameters);
        if (operationParam.getMethod().equalsIgnoreCase("post")) {
            JSONObject requestBody = new JSONObject();
            requestBody.put("contentType", (Object)"application/json");
            requestBody.put("body", (Object)body);
            toolParams.put("requestBody", (Object)requestBody);
        } else {
            parameters.addAll((Collection)getParameters);
        }
        api.setToolParams(toolParams);
        api.setToolId((Long)toolRequestParams.get("toolId"));
        api.setChatSessionId(String.valueOf(toolRequestParams.get("chatSessionId")));
        log.info("restful toolRequestParams:{}", (Object)toolRequestParams.toString());
        BaseResult result = RestfulAPIService.getService().call(api);
        return result;
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        ToolMessage message = this.buildToolMessage(this.context, this.gaiFlow, (ToolAction)this.action, e);
        this.getLog(e).logInput("message", message);
        Map<String, Object> toolRequestParams = this.buildToolRequestParams(message);
        BaseResult toolResult = this.functionCall(toolRequestParams);
        if (toolResult == null) {
            log.info("flow error result: tool request return NULL");
            throw new KDException(Errors.TOOL_NO_RETURN, new Object[0]);
        }
        toolResult.setToolType((String)toolRequestParams.get("type"));
        if (toolResult.getToolType().equals(ToolConstant.ToolType.COSMIC_ACTION.getType()) && !toolResult.getErrCode().equals(BaseResult.SUCCESS)) {
            log.info("flow error result {}", (Object)JsonUtil.toJson(toolResult));
            throw new KDException(Errors.TOOL_REQUEST_FAILED, new Object[0]);
        }
        JSONObject jsonObject = toolResult.getDataAsJSONObject();
        log.info("jsonObject:{}", (Object)jsonObject.toJSONString());
        this.setOutputParams(e, new HashMap(jsonObject));
    }

    public ToolMessage buildToolMessage(Context context, Flow flow, ToolAction toolAction, Execution e) {
        ToolMessage message = new ToolMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setPageId(context.getBizPageId());
        message.setFlowId(flow.getId());
        message.setNodeId(toolAction.getId());
        message.setToolId(toolAction.getToolId());
        message.setToolType(toolAction.getToolType());
        message.setToolName(toolAction.getToolName());
        message.setOperationId(toolAction.getOperationId());
        message.setOperationName(toolAction.getOperationName());
        Map<String, String> params = this.toStringMap(this.getInputParamMap(e));
        message.setInputParams(params);
        return message;
    }

    private Map<String, Object> buildToolRequestParams(ToolMessage message) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("toolId", message.getToolId());
        requestParams.put("type", message.getToolType());
        requestParams.put("operationId", message.getOperationId());
        requestParams.put("operationName", message.getOperationName());
        requestParams.put("toolName", message.getToolName());
        requestParams.put("chatSessionId", message.getChatSessionId());
        requestParams.put("params", message.getInputParams());
        return requestParams;
    }
}

