/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VisionAction;
import kd.ai.gai.core.engine.message.VisionMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.flow.TemplateTypeCodeEnum;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.biz.application.CvpFlowUtils;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.vision.CustomTempTransformServiceImpl;
import kd.ai.gai.core.flow.vision.IeTransformServiceImpl;
import kd.ai.gai.core.flow.vision.PresetTransformServiceImpl;
import kd.ai.gai.core.flow.vision.TransformService;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class VisionNodeApplicationImpl
extends AbstractNodeApplication<VisionAction> {
    private static final Log log = LogFactory.getLog(VisionNodeApplicationImpl.class);
    private static final String LOG_PREFIX = "vision-VisionNodeApplicationImpl";
    private static final String DiSTINGUISH_OCR_IMAGE = "distinguishOcrByUrl";
    private static final String OCR_SERVICE = "OcrService";
    private static final String CREATE_TIE_TASK = "createTieTask";
    private static final String QUERY_TIE_TASK_RESULT = "queryTieTaskResult";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public VisionNodeApplicationImpl(Context context, Flow gaiFlow, VisionAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    protected void onApplicationInvoke(Execution e) {
        log.info("vision-VisionNodeApplicationImplvision node application invoke");
        VisionMessage visionMessage = this.buildVisionMessage(this.context, this.gaiFlow, (VisionAction)this.action, e);
        this.getLog(e).logInput("message", visionMessage);
        this.executeVisionService(e, visionMessage);
    }

    private VisionMessage buildVisionMessage(Context context, Flow flow, VisionAction action, Execution e) {
        VisionMessage message = new VisionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(this.gaiFlow.getId());
        message.setNodeId(action.getId());
        message.setBusinessObjectNumber(action.getBusinessObjectNumber());
        message.setTemplateName(action.getTemplateName());
        message.setTemplateNumber(action.getTemplateNumber());
        message.setTemplateType(action.getTemplateType());
        message.setTemplateId(action.getTemplateId());
        message.setBackFill(action.isBackFill());
        message.setBusinessObjectId(action.getBusinessObjectId());
        message.setShowStatus(action.isShowStatus());
        Object attachments = this.getParamManager().getParamValue(e, action.getId(), "attachments", ParamDirection.INPUT);
        message.setAttachmentId(attachments.toString());
        if (message.isBackFill()) {
            message.setAppId(action.getAppId());
            DynamicObject businessObject = BusinessDataServiceHelper.newDynamicObject((String)message.getBusinessObjectNumber());
            businessObject.set("id", (Object)DB.genLongId((String)message.getBusinessObjectNumber()));
            message.setBusinessObjectId(businessObject.getLong("id"));
            message.setMapId(action.getMapId());
        }
        return message;
    }

    private void executeVisionService(Execution e, VisionMessage message) {
        this.sendMsg(message.isShowStatus(), FileStatus.processing, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
        boolean backFill = message.isBackFill();
        String result = "";
        boolean savePermission = true;
        String setValueResult = "";
        if (backFill) {
            savePermission = this.validSaveApiPermission(message.getAppId(), message.getBusinessObjectNumber());
            if (savePermission) {
                result = this.getOcrResult(message, message.getTemplateType(), message.getTemplateNumber(), message.getBusinessObjectNumber(), message.getBusinessObjectId());
                log.info("get ocr result end,backFilldata: {}", (Object)result);
                setValueResult = this.transferResultToNode(result, String.valueOf(message.getTemplateId()), message.getTemplateType(), message.getTemplateNumber(), message.getBusinessObjectNumber(), message.getMapId());
            }
        } else {
            result = this.getOcrResult(message, message.getTemplateType(), message.getTemplateNumber(), message.getBusinessObjectNumber(), message.getBusinessObjectId());
            log.info("get ocr result end, data: {}", (Object)result);
            setValueResult = this.transferResultToNode(result, String.valueOf(message.getTemplateId()), message.getTemplateType(), message.getTemplateNumber(), null, message.getMapId());
        }
        log.info("transferResultToNode result: {}", (Object)setValueResult);
        boolean isSuccess = this.setOutputParameter(e, setValueResult, message, savePermission);
        if (isSuccess) {
            this.sendMsg(message.isShowStatus(), FileStatus.success, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
        }
    }

    private boolean setOutputParameter(Execution e, String result, VisionMessage message, boolean savePermission) {
        ParamDefinition outputParam = ((VisionAction)this.action).getParamByName(((VisionAction)this.action).getOutputParamGroup(), "output").orElseThrow(() -> new RuntimeException("setOutputParameter error, can't find result"));
        HashMap<String, Object> output = new HashMap<String, Object>(4);
        HashMap<String, Map> data = new HashMap<String, Map>(4);
        if (message.isBackFill() && !savePermission) {
            output.put("status", false);
            output.put("message", "not authorized to save the documen");
            output.put("savePermission", false);
            output.put("isBackFill", message.isBackFill());
        } else {
            Map ocrData;
            try {
                ocrData = (Map)objectMapper.readValue(result, Map.class);
            }
            catch (JsonProcessingException ex) {
                this.sendMsg(message.isShowStatus(), FileStatus.fail, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
                throw new KDException(BosErrorCode.canNotCast, new Object[]{ex});
            }
            if (ocrData.get("code") == null || (Integer)ocrData.get("code") != 0) {
                this.sendMsg(message.isShowStatus(), FileStatus.fail, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
                return false;
            }
            Map resultMap = (Map)ocrData.get("data");
            if (resultMap != null && !resultMap.isEmpty()) {
                Map templateOutput = (Map)resultMap.get("templateOutput");
                data.put("templateOutput", templateOutput);
            }
            if (message.isBackFill() && resultMap != null && !resultMap.isEmpty()) {
                Map bizOutput = (Map)resultMap.get("bizOutput");
                data.put("bizOutput", bizOutput);
            }
            output.put("isBackFill", message.isBackFill());
            output.put("data", data);
            output.put("status", true);
            output.put("message", "success");
            output.put("savePermission", savePermission);
        }
        this.getParamManager().setParamValue(e, this.action, outputParam, output);
        Object paramValue = this.getParamManager().getParamValue(e, this.action, outputParam);
        log.info(paramValue.toString());
        return true;
    }

    private String getOcrResult(VisionMessage message, String templateType, String method, String businessObject, long billId) {
        log.info("start getOcrResult:  templateType:{}, templateNumber:{}, businessObjectNumber:{},businessObjectId:{}", new Object[]{templateType, method, businessObject, message.getBusinessObjectNumber(), billId});
        if (templateType.equals("preset") || templateType.equals("custom")) {
            String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)OCR_SERVICE, (String)DiSTINGUISH_OCR_IMAGE, (Object[])new Object[]{businessObject, method, this.getFileUrl(message.getAttachmentId())});
            log.info("distinguishOcrByUrl result:{}", (Object)result);
            if (templateType.equals("custom")) {
                return VisionNodeApplicationImpl.customTemplateTransTool(result, message.getTemplateNumber());
            }
            return result;
        }
        if (templateType.equals("ie")) {
            String pageListStr = "all";
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)OCR_SERVICE, (String)CREATE_TIE_TASK, (Object[])new Object[]{this.getFileUrl(message.getAttachmentId()), pageListStr, method, businessObject, String.valueOf(billId)});
            try {
                Map result = (Map)objectMapper.readValue(resultStr, Map.class);
                if ((Integer)result.get("errorCode") == 0) {
                    return this.getTaskResult(Long.parseLong(((Map)objectMapper.convertValue(result.get("data"), Map.class)).get("taskId").toString()));
                }
                this.sendMsg(message.isShowStatus(), FileStatus.fail, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
            }
            catch (JsonProcessingException e) {
                this.sendMsg(message.isShowStatus(), FileStatus.fail, this.getAttachmentDto(message.getAttachmentId()).getFilename(), message.getAttachmentId());
            }
        }
        return "";
    }

    private String getTaskResult(long taskId) {
        long timeout = 600000L;
        long interval = 2000L;
        long startTime = System.currentTimeMillis();
        while (true) {
            Map datamap;
            if (System.currentTimeMillis() - startTime > timeout) {
                throw new RuntimeException("Task timeout");
            }
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)OCR_SERVICE, (String)QUERY_TIE_TASK_RESULT, (Object[])new Object[]{String.valueOf(taskId)});
            log.info("queryTieTaskResult data: {}", (Object)resultStr);
            Map result = new HashMap();
            try {
                result = (Map)objectMapper.readValue(resultStr, Map.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            if (result == null || result.isEmpty()) {
                throw new KDException(BosErrorCode.nullError, new Object[]{"ocr result is null"});
            }
            int errCode = (Integer)result.get("errorCode");
            if (errCode == 0 && (datamap = (Map)result.get("data")).get("status") != null) {
                switch (datamap.get("status").toString()) {
                    case "success": {
                        return resultStr;
                    }
                    case "cancel": 
                    case "error": {
                        throw new KDException(new ErrorCode("", datamap.get("progress").toString()), new Object[0]);
                    }
                }
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getFileUrl(String fileId) {
        AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)fileId);
        String resourcePath = attachmentDto.getResourcePath();
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        return resourcePath;
    }

    private AttachmentDto getAttachmentDto(String fileId) {
        return AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)fileId);
    }

    private void sendMsg(Map<String, Object> wsMsg) {
        this.pushMessage(this.context, wsMsg, String.valueOf(System.currentTimeMillis()), true, 0);
    }

    private void sendMsg(boolean showStatus, FileStatus fileStatus, String fileName, String taskId) {
        if (!showStatus) {
            return;
        }
        HashMap<String, Object> wsMsg = new HashMap<String, Object>(4);
        List<Map<String, String>> msgList = Collections.singletonList(Collections.singletonMap("msg", fileName + ResManager.loadKDString((String)"\u6587\u4ef6\uff1a", (String)"VisionNodeApplicationImpl_3", (String)"ai-gai-core", (Object[])new Object[0]) + fileStatus.getMsg()));
        wsMsg.put("status", fileStatus.getStatus());
        wsMsg.put("msgList", msgList);
        wsMsg.put("taskId", taskId);
        wsMsg.put("model", "docParse");
        this.sendMsg(wsMsg);
    }

    private void pushMessage(Context context, Map<String, Object> messageMap, String taskId, boolean end, int index) {
        PushMsgService.pushResult(context, ResultActionType.vision.toString(), messageMap);
        String message = JSONObject.toJSONString(messageMap);
        ChatHistoryService.save(context.getChatSessionId(), 0L, Collections.singletonList(new ChatItem(1, message, null)));
        MessageService.insertMessage(context.getChatSessionId(), message, null, null, context.getCurrentSkill(), ChatMessageTypeEnum.VISION, EnableEnum.YES, context.getTraceId());
    }

    private boolean validSaveApiPermission(String keyAppId, String entityNum) {
        log.info("\u63a5\u53e3\u4fdd\u5b58\u6743\u9650\u9a8c\u8bc1,appId:{} ,entityNum:{}", (Object)keyAppId, (Object)entityNum);
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)keyAppId).getAppId();
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)"0=KX5+QVF5+R");
    }

    private String transferResultToNode(String result, String templateId, String templateType, String templateNumber, String bizFormId, long mapId) {
        if (StringUtils.isEmpty((String)result) || StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)templateType)) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_PARAM_ERROR), new Object[0]);
        }
        Map<String, Object> resultMap = this.getExtractKeyValuePair(result, templateId, templateNumber, templateType, mapId);
        String nodeStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"AgentFlowService", (String)"getTemplateAndMappingFields", (Object[])new Object[]{templateId, templateType, bizFormId, String.valueOf(mapId)});
        log.info("getTemplateAndMappingFields: {}", (Object)nodeStr);
        if (StringUtils.isNotEmpty((String)nodeStr)) {
            JSONObject jsonObject = JSON.parseObject((String)nodeStr);
            if (jsonObject != null) {
                int code = jsonObject.getInteger("code");
                log.info("code:{}", (Object)code);
                if (code != 0) {
                    String errorMsg = jsonObject.getString("message");
                    throw new KDBizException(errorMsg);
                }
                CvpFlowUtils.fillData(jsonObject, resultMap);
                return jsonObject.toJSONString();
            }
            log.error("jsonObject is null");
        }
        log.error("node str is null");
        return null;
    }

    private Map<String, Object> getExtractKeyValuePair(String result, String templateId, String templateNumber, String templateType, long mapId) {
        TemplateTypeCodeEnum enumByCode = TemplateTypeCodeEnum.getEnumByCode(templateType);
        if (enumByCode == null) {
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_PARAM_ERROR), new Object[0]);
        }
        String relateFormId = enumByCode.getRelateFormid();
        String properties = "";
        String config = "";
        if (enumByCode == TemplateTypeCodeEnum.OCR_TEMPLATE) {
            properties = "id,number,templateconfig";
            config = "templateconfig";
        } else if (enumByCode == TemplateTypeCodeEnum.IE_PLAN) {
            properties = "id,billno,relateconfig";
            config = "relateconfig";
        }
        DynamicObject bizObj = this.getBizRelateObj(properties, mapId, relateFormId);
        JSONObject bizJSONObj = null;
        if (bizObj != null) {
            bizJSONObj = this.getBizConfigJsonObject(bizObj, config, templateId);
        }
        TransformService transformService = null;
        switch (templateType) {
            case "preset": {
                transformService = new PresetTransformServiceImpl();
                break;
            }
            case "custom": {
                transformService = new CustomTempTransformServiceImpl();
                break;
            }
            case "ie": {
                transformService = new IeTransformServiceImpl();
                break;
            }
            default: {
                throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.VISION_FLOW_NOT_SUPPORT_TEMPLATE), new Object[0]);
            }
        }
        return transformService.transform(result, bizJSONObj, templateNumber);
    }

    private JSONObject getBizConfigJsonObject(DynamicObject bizObj, String config, String templateId) {
        JSONObject jsonObject;
        String configStr = bizObj.getString(config);
        if (StringUtils.isNotEmpty((String)configStr) && (jsonObject = JSON.parseObject((String)configStr)).containsKey((Object)templateId)) {
            return jsonObject.getJSONObject(templateId);
        }
        return null;
    }

    private DynamicObject getBizRelateObj(String properties, long mapId, String relateFormId) {
        if (mapId == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)mapId, (String)relateFormId, (String)properties);
    }

    private static String customTemplateTransTool(String jsonInput, String templateNumber) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(2);
        result.put("code", -1);
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap resultData = new HashMap(8);
            List outerList = (List)mapper.readValue(jsonInput, List.class);
            String jsonStr = (String)outerList.get(0);
            Map parsedJson = (Map)mapper.readValue(jsonStr, Map.class);
            int errorCode = (Integer)parsedJson.get("errorCode");
            result.put("code", errorCode);
            if (errorCode != 0) {
                return jsonStr;
            }
            Map data = (Map)parsedJson.get("data");
            Map recognitionArea = (Map)data.get("recognitionArea");
            Map table = (Map)data.get("table");
            resultData.putAll(recognitionArea);
            table.forEach((k, v) -> {
                List tableAll = (List)v;
                List headers = (List)tableAll.get(0);
                ArrayList tableData = new ArrayList(1);
                for (int i = 1; i < tableAll.size(); ++i) {
                    List row = (List)tableAll.get(i);
                    LinkedHashMap rowMap = new LinkedHashMap();
                    for (int j = 0; j < headers.size(); ++j) {
                        rowMap.put(headers.get(j), j < row.size() ? (String)row.get(j) : "");
                    }
                    tableData.add(rowMap);
                }
                resultData.put(k, tableData);
                HashMap<String, Map> template = new HashMap<String, Map>(4);
                template.put("data", resultData);
                Map templates = Collections.singletonMap(templateNumber, template);
                Map templateOutput = Collections.singletonMap("templateOutput", templates);
                result.put("data", (Integer)((Object)templateOutput));
            });
        }
        catch (Exception e) {
            log.error("ClassCastException");
            return JSON.toJSONString(result);
        }
        return JSON.toJSONString(result);
    }

    private static enum FileStatus {
        success(ResManager.loadKDString((String)"\u62bd\u53d6\u6210\u529f", (String)"VisionNodeApplicationImpl_0", (String)"ai-gai-core", (Object[])new Object[0]), "1"),
        fail(ResManager.loadKDString((String)"\u62bd\u53d6\u5931\u8d25", (String)"VisionNodeApplicationImpl_1", (String)"ai-gai-core", (Object[])new Object[0]), "-1"),
        processing(ResManager.loadKDString((String)"\u6587\u6863\u63d0\u53d6\u4e2d", (String)"VisionNodeApplicationImpl_2", (String)"ai-gai-core", (Object[])new Object[0]), "0");

        private final String msg;
        private final String status;

        private FileStatus(String msg, String status) {
            this.msg = msg;
            this.status = status;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

