/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.callback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.flow.biz.callback.AbstractNodeCallBack;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public final class AskUserNodeCallbackImpl
extends AbstractNodeCallBack<AskUserAction> {
    private static final Log log = LogFactory.getLog(AskUserNodeCallbackImpl.class);

    public AskUserNodeCallbackImpl(Context context, Flow gaiFlow, AskUserAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    public boolean onInject(Execution e, Object params) {
        AskUserCallbackMessage callbackMessage = (AskUserCallbackMessage)params;
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            log.error("\u4f1a\u8bddID\uff08{}\uff09\u7684\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getChatSessionId());
            throw new KDBizException(Errors.getFlowContextIsNull(String.format("chat sessionid:%s flowId:%s", callbackMessage.getChatSessionId(), callbackMessage.getFlowId())), new Object[0]);
        }
        Flow flow = FlowCacheData.getFlowById(callbackMessage.getChatSessionId(), callbackMessage.getFlowId());
        if (flow == null) {
            log.error("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0bID\uff08{}\uff09\u7684\u7f13\u5b58\u4fe1\u606f\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getFlowId());
            throw new KDBizException(Errors.flowInstanceNotExisted(callbackMessage.getFlowId()), new Object[0]);
        }
        HashMap<String, String> outData = new HashMap<String, String>();
        ChatMessage chatMessage = callbackMessage.getChatMessage();
        if (chatMessage.getInParaMap() != null && !chatMessage.getInParaMap().isEmpty()) {
            Map<String, String> inData = chatMessage.getInParaMap();
            List<ParamDefinition> outputParamDefs = ((AskUserAction)this.action).getOutputParams();
            for (ParamDefinition paramDef : outputParamDefs) {
                if (!inData.containsKey(paramDef.getName())) continue;
                outData.put(paramDef.getName(), inData.get(paramDef.getName()));
            }
        }
        if (StringUtils.isNotEmpty((String)chatMessage.getUserInput())) {
            outData.put("askUser_output", chatMessage.getUserInput());
        }
        this.setOutputParams(e, outData);
        return true;
    }

    public String toString() {
        return "";
    }
}

