/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.callback;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.BillNLQueryAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.message.QueryEntityCallbackMessage;
import kd.ai.gai.core.flow.biz.callback.AbstractNodeCallBack;
import kd.ai.gai.core.nl2filter.Filter;
import kd.ai.gai.core.nl2filter.NL2FilterService;
import kd.ai.gai.flow.flow.core.Execution;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class QueryEntityNodeCallbackImpl
extends AbstractNodeCallBack<BillNLQueryAction> {
    private static final Log log = LogFactory.getLog(QueryEntityNodeCallbackImpl.class);

    public QueryEntityNodeCallbackImpl(Context context, Flow gaiFlow, BillNLQueryAction action) {
        super(context, gaiFlow, action);
    }

    @Override
    public boolean onInject(Execution e, Object params) {
        log.info("QueryEntityNodeHandler callback");
        QueryEntityCallbackMessage callbackMessage = (QueryEntityCallbackMessage)params;
        this.setOutputParams(e, callbackMessage);
        return true;
    }

    public void setOutputParams(Execution e, QueryEntityCallbackMessage callbackMessage) {
        String allMsg = callbackMessage.getAllMsg();
        HashMap<String, Object> extProperties = new HashMap<String, Object>();
        try {
            NL2FilterService nl2FilterService = new NL2FilterService();
            Filter filter = nl2FilterService.parseFilter(callbackMessage.getEntityNumber(), allMsg);
            allMsg = allMsg.replaceAll("```json|```", "").trim();
            if (filter != null && filter.getConditions().size() > 0) {
                Object[] dataObjs = nl2FilterService.queryData(callbackMessage.getEntityNumber(), callbackMessage.getSelectProperties(), filter);
                int count = dataObjs == null ? 0 : dataObjs.length;
                extProperties.put("count", String.valueOf(count));
                extProperties.put("status", true);
                extProperties.put("message", allMsg);
                extProperties.put("metaData", ((BillNLQueryAction)this.action).getMetaData());
                extProperties.put("filter", filter.getConditions().toString());
                this.setOutputParams(e, extProperties);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)((BillNLQueryAction)this.action).getBillId());
                List<Map> list = QueryEntityNodeCallbackImpl.serializeToMap(dataObjs, (DynamicObjectType)mainEntityType);
                ArrayList<HashMap> lists = new ArrayList<HashMap>(16);
                for (int i = 0; i < list.size(); ++i) {
                    this.dataProcess((HashMap)list.get(i));
                    lists.add((HashMap)list.get(i));
                }
                HashMap<String, ArrayList<HashMap>> result = new HashMap<String, ArrayList<HashMap>>();
                result.put("result", lists);
                this.setOutputParams(e, result);
            } else {
                extProperties.put("status", false);
                extProperties.put("message", "\u67e5\u8be2\u5931\u8d25,\u751f\u6210\u67e5\u8be2\u6761\u4ef6\u5931\u8d25" + allMsg);
                this.setOutputParams(e, extProperties);
            }
        }
        catch (Exception ex) {
            extProperties.put("message", "\u67e5\u8be2\u5f02\u5e38");
            extProperties.put("status", false);
            this.setOutputParams(e, extProperties);
            log.error("query message failed:{}" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException(Errors.codeExecuteError(((BillNLQueryAction)this.action).getName(), ex.getMessage() + allMsg), new Object[0]);
        }
    }

    public String toString() {
        return "";
    }

    public void dataProcess(HashMap<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof OrmLocaleValue) {
                map.put(entry.getKey(), ((OrmLocaleValue)entry.getValue()).getLocaleValue());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.dataProcess((HashMap)entry.getValue());
        }
    }

    public static String serialize(Object[] result, DynamicObjectType dt) {
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(false);
        String[] r = new String[result.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = jsr.serializeToString(result[i], null);
        }
        return JSON.toJSONString((Object)r);
    }

    public static List<Map> serializeToMap(Object[] result, DynamicObjectType dt) {
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(false);
        ArrayList<Map> r = new ArrayList<Map>(result.length);
        for (int i = 0; i < result.length; ++i) {
            Map map = jsr.serializeToMap(result[i], null);
            r.add(map);
        }
        return r;
    }
}

