/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.flow.build.NodeBuilderFactory;
import kd.ai.gai.core.flow.build.attribute.FlowAttribute;
import kd.ai.gai.core.flow.condition.GaiCondition;
import kd.ai.gai.core.flow.listener.InitVariableListener;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.BlockBuilder;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.FC;
import kd.ai.gai.flow.flow.core.FlowBuilder;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.TransitionBuilder;
import kd.ai.gai.flow.flow.core.plugin.Condition;
import kd.ai.gai.flow.flow.core.plugin.Listener;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlowBuilderFactory {
    private static final Log logger = LogFactory.getLog(FlowBuilderFactory.class);

    public static kd.ai.gai.flow.flow.core.Flow build(Context context, Flow gaiFlow) {
        if (gaiFlow == null) {
            logger.error("chatSessionId\u3010{}\u3011\u6d41\u7a0b\u4e3a\u7a7a\u3002 ", (Object)context.getChatSessionId());
            throw new KDBizException(Errors.flowNotExistedError(context.getChatSessionId()), new Object[0]);
        }
        try {
            FlowBuilder flowBuilder = FC.getFactory().newInstance(String.valueOf(gaiFlow.getId()), gaiFlow.getName());
            String startFlowMessage = "startFlowMessage";
            flowBuilder.variable(startFlowMessage, startFlowMessage, "\u8f93\u5165\u53c2\u6570", FlowUtils.toDataType(VarFieldType.STRING.getType()));
            flowBuilder.addInput(startFlowMessage);
            NodeBuilderFactory.buildNode((BlockBuilder)flowBuilder, context, gaiFlow, gaiFlow.getStart());
            FlowBuilderFactory.buildActions(flowBuilder, context, gaiFlow);
            NodeBuilderFactory.buildNode((BlockBuilder)flowBuilder, context, gaiFlow, gaiFlow.getEnd());
            FlowBuilderFactory.buildTransfers(flowBuilder, context, gaiFlow);
            FlowBuilderFactory.setInitNodeVariableListener(flowBuilder.getRootBuilder());
            kd.ai.gai.flow.flow.core.Flow flow = flowBuilder.end();
            flow.setAttribute(FlowAttribute.GAI_FLOW.name(), (Object)gaiFlow);
            flow.setAttribute(FlowAttribute.PARAM_MODE.name(), (Object)ParamMode.VARIABLE);
            return flow;
        }
        catch (Exception ex) {
            logger.error("\u6d41\u7a0b\u89e3\u6790\u6784\u5efa\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            throw new KDBizException((Throwable)ex, Errors.flowBuildError(ex.getMessage()), new Object[0]);
        }
    }

    private static void setInitNodeVariableListener(NodeBuilder nodeBuilder) {
        NodeBuilder[] nodeChildren;
        nodeBuilder.listener(Event.ON_CREATED, (Listener)new InitVariableListener());
        for (NodeBuilder nodeChild : nodeChildren = nodeBuilder.children()) {
            FlowBuilderFactory.setInitNodeVariableListener(nodeChild);
        }
    }

    private static void buildActions(FlowBuilder flowBuilder, Context context, Flow gaiFlow) {
        List<Action> gaiFlowActions = gaiFlow.getActions();
        for (Action action : gaiFlowActions) {
            if (action.isBlockInnerNode()) continue;
            NodeBuilderFactory.buildNode((BlockBuilder)flowBuilder, context, gaiFlow, action);
        }
    }

    private static void buildTransfers(FlowBuilder flowBuilder, Context context, Flow gaiFlow) {
        List<Transfer> transfers = gaiFlow.getTransfers();
        List<Action> actionList = gaiFlow.getActions();
        List<Transfer> resortTransferList = FlowBuilderFactory.resortTransfers(transfers, gaiFlow.getStart(), actionList, gaiFlow.getEnd());
        for (Transfer transfer : resortTransferList) {
            int fromNodeId = transfer.getFromNodeId();
            int toNodeId = transfer.getToNodeId();
            TransitionBuilder transition = flowBuilder.transition(String.valueOf(transfer.getId()), String.format("%s_%s", fromNodeId, toNodeId), String.valueOf(fromNodeId), String.valueOf(toNodeId), Transition.Type.NORMAL);
            kd.ai.gai.core.engine.flow.Condition gaiCondition = transfer.getCondition();
            if (transition == null || gaiCondition == null || gaiCondition.getConditionRows() == null) continue;
            transition.setCondition((Condition)new GaiCondition(context, gaiFlow, transfer, -1));
        }
    }

    private static List<Transfer> resortTransfers(List<Transfer> transfers, Start start, List<Action> actionList, End end) {
        List<Integer> outTransferOutList;
        ArrayList<Transfer> resortTransferList = new ArrayList<Transfer>(10);
        Map idTransferMap = transfers.stream().collect(Collectors.toMap(Transfer::getId, Function.identity(), (key1, key2) -> key2));
        ArrayList allTransferOutList = new ArrayList();
        ArrayList hasConditionTransferList = new ArrayList();
        List<Integer> startTransferOutList = start.getTransferOutList();
        if (startTransferOutList != null && !startTransferOutList.isEmpty()) {
            startTransferOutList.forEach(i -> {
                Transfer transfer = (Transfer)idTransferMap.get(i);
                if (transfer.getCondition() != null) {
                    hasConditionTransferList.add(transfer);
                } else {
                    allTransferOutList.add(i);
                }
            });
        }
        if (actionList != null && !actionList.isEmpty()) {
            actionList.forEach(action -> {
                List<Integer> transferOutList = action.getTransferOutList();
                if (transferOutList != null && !transferOutList.isEmpty()) {
                    transferOutList.forEach(i -> {
                        Transfer transfer = (Transfer)idTransferMap.get(i);
                        if (transfer.getCondition() != null) {
                            hasConditionTransferList.add(transfer);
                        } else {
                            allTransferOutList.add(i);
                        }
                    });
                }
            });
        }
        if ((outTransferOutList = end.getTransferOutList()) != null && !outTransferOutList.isEmpty()) {
            outTransferOutList.forEach(i -> {
                Transfer transfer = (Transfer)idTransferMap.get(i);
                if (transfer.getCondition() != null) {
                    hasConditionTransferList.add(transfer);
                } else {
                    allTransferOutList.add(i);
                }
            });
        }
        Collections.reverse(allTransferOutList);
        allTransferOutList.forEach(transferId -> {
            Transfer transfer = (Transfer)idTransferMap.get(transferId);
            if (transfer != null) {
                resortTransferList.add(transfer);
            }
        });
        if (!hasConditionTransferList.isEmpty()) {
            resortTransferList.addAll(hasConditionTransferList);
        }
        return resortTransferList;
    }
}

