/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.build.INodeBuilderFactory;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.attribute.NodeAttribute;
import kd.ai.gai.core.flow.build.impl.BasicNodeBuilderFactory;
import kd.ai.gai.core.flow.build.impl.BatchProcessNodeBuilderFactory;
import kd.ai.gai.core.flow.build.impl.LoopNodeBuilderFactory;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.BlockBuilder;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.VariableScopeBuilder;
import kd.ai.gai.flow.flow.core.plugin.Listener;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class NodeBuilderFactory {
    private static final Log logger = LogFactory.getLog(NodeBuilderFactory.class);
    private static final Map<ProcessNodeType, INodeBuilderFactory> mapNodeBuilderFC = new HashMap<ProcessNodeType, INodeBuilderFactory>(2);

    private static INodeBuilderFactory getNodeBuilderFactory(Action action) {
        ProcessNodeType nodeType = action.getNodeType();
        INodeBuilderFactory factory = mapNodeBuilderFC.getOrDefault((Object)nodeType, null);
        if (factory != null) {
            return factory;
        }
        if (action instanceof BatchAction && ((BatchAction)action).isEnableBatch()) {
            return new BatchProcessNodeBuilderFactory();
        }
        return new BasicNodeBuilderFactory();
    }

    public static NodeBuilder buildNode(BlockBuilder parent, Context context, Flow gaiFlow, Action action) {
        INodeBuilderFactory factory = NodeBuilderFactory.getNodeBuilderFactory(action);
        return NodeBuilderFactory.buildNode(factory, parent, context, gaiFlow, action);
    }

    public static NodeBuilder buildNode(INodeBuilderFactory factory, BlockBuilder parent, Context context, Flow gaiFlow, Action action) {
        try {
            NodeBuilder[] children;
            action.compileParamReference(gaiFlow);
            NodeBuilder nodeBuilder = factory.buildNode(parent, context, gaiFlow, action);
            nodeBuilder.setAttribute(NodeAttribute.NODE_ID.name(), (Object)action.getId());
            nodeBuilder.setAttribute(NodeAttribute.REQUIRES_INIT_VARIABLES.name(), (Object)true);
            for (NodeBuilder child : children = nodeBuilder.children()) {
                child.setAttribute(NodeAttribute.NODE_ID.name(), (Object)action.getId());
            }
            List<ParamDefinition> parentScopeDefinitions = factory.getParentScopeDefinitions(action);
            HashSet parentScopesParams = new HashSet(parentScopeDefinitions.size());
            parentScopeDefinitions.forEach(paramDefinition -> {
                VariableBuilderFactory.build((VariableScopeBuilder)parent, action, paramDefinition);
                parentScopesParams.add(paramDefinition.getName() + paramDefinition.getDirection().name());
            });
            List<ParamDefinition> currentScopeDefinitions = factory.getCurrentScopeDefinitions(action);
            currentScopeDefinitions.forEach(paramDefinition -> {
                if (parentScopesParams.contains(paramDefinition.getName() + paramDefinition.getDirection().name())) {
                    return;
                }
                VariableBuilderFactory.build((VariableScopeBuilder)nodeBuilder, action, paramDefinition);
            });
            Listener listener = factory.getListener(context, gaiFlow, action);
            if (listener != null) {
                Event[] events;
                nodeBuilder.setAttribute(NodeAttribute.REQUIRES_TRACE_LOG.name(), (Object)true);
                for (Event event : events = Event.values()) {
                    nodeBuilder.listener(event, listener);
                }
            }
            return nodeBuilder;
        }
        catch (Exception ex) {
            logger.error("\u8282\u70b9\u6784\u5efa\u5931\u8d25", (Throwable)ex);
            throw new KDBizException((Throwable)ex, Errors.flowBuildNodeError(action.getName(), ex.getMessage()), new Object[0]);
        }
    }

    static {
        mapNodeBuilderFC.put(ProcessNodeType.Loop, new LoopNodeBuilderFactory());
        mapNodeBuilderFC.put(ProcessNodeType.Parallel, new BatchProcessNodeBuilderFactory());
    }
}

