/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build;

import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.flow.build.NodeVariableItem;
import kd.ai.gai.core.flow.build.attribute.VariableAttribute;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.flow.flow.core.VariableBuilder;
import kd.ai.gai.flow.flow.core.VariableScopeBuilder;

public class VariableBuilderFactory {
    public static final String SEPERATOR = "_";
    public static final String NAME_SEPERATOR = ".";
    public static final String VARIABLE_PREFIX = "v";
    public static final String INPUT_SUFFIX = "in";
    public static final String OUTPUT_SUFFIX = "out";
    public static final String ARRAY_ITEM_SUFFIX = "[index]";
    public static final String ARRAY_ITEM_DISPLAY_SUFFIX = "item (in %s)";

    public static VariableBuilder build(VariableScopeBuilder scope, Node node, ParamDefinition paramDefinition) {
        NodeVariableItem nodeVariableItem = new NodeVariableItem(node, paramDefinition);
        return VariableBuilderFactory.build(scope, nodeVariableItem);
    }

    public static VariableBuilder build(VariableScopeBuilder scope, NodeVariableItem nodeVariableItem) {
        String varId = VariableBuilderFactory.getVariableId(nodeVariableItem);
        String varName = VariableBuilderFactory.getVariableName(nodeVariableItem);
        String varDisplayName = VariableBuilderFactory.getVariableDisplayName(nodeVariableItem);
        VariableBuilder variableBuilder = scope.variable(varId, varName, varDisplayName, nodeVariableItem.getType());
        if (nodeVariableItem.getDefautValue() != null) {
            variableBuilder.setInitValue(nodeVariableItem.getDefautValue());
        }
        variableBuilder.setAttribute(VariableAttribute.NODE_ID.name(), (Object)nodeVariableItem.getNode().getId());
        variableBuilder.setAttribute(VariableAttribute.REQUIRES_INIT.name(), (Object)true);
        variableBuilder.setAttribute(VariableAttribute.PARAM_DEFINITION.name(), (Object)nodeVariableItem.getParamDefinition());
        return variableBuilder;
    }

    public static String getVariableId(int nodeId, String paramName, ParamDirection paramDirection) {
        return VARIABLE_PREFIX + nodeId + SEPERATOR + VariableBuilderFactory.getParamDirectionSuffix(paramDirection) + SEPERATOR + paramName;
    }

    public static String getVariableId(NodeVariableItem nodeVariableItem) {
        return VariableBuilderFactory.getVariableId(nodeVariableItem.getNode().getId(), nodeVariableItem.getName(), nodeVariableItem.getParamDirection());
    }

    private static String getParamDirectionSuffix(ParamDirection paramDirection) {
        switch (paramDirection) {
            case INPUT: {
                return INPUT_SUFFIX;
            }
            case OUTPUT: 
            case BOTH: {
                return OUTPUT_SUFFIX;
            }
        }
        return "";
    }

    public static String getVariableDisplayName(NodeVariableItem nodeVariableItem) {
        return nodeVariableItem.getNode().getName() + NAME_SEPERATOR + nodeVariableItem.getTitle();
    }

    public static String getVariableName(NodeVariableItem nodeVariableItem) {
        return VariableBuilderFactory.getVariableId(nodeVariableItem);
    }

    public static String getArrayItemParamName(ArrayParamDefinition arrayParamDefinition) {
        return String.format("%s%s", arrayParamDefinition.getName(), ARRAY_ITEM_SUFFIX);
    }

    public static String getArrayItemParamDisplayName(ArrayParamDefinition arrayParamDefinition) {
        return String.format(ARRAY_ITEM_DISPLAY_SUFFIX, arrayParamDefinition.getName());
    }

    public static String getArrayItemIndexParamName() {
        return String.format("%s", "{{index}}");
    }

    public static ParamDirection getDirection(Action curAction, int targetParamActionId) {
        if (curAction == null) {
            return ParamDirection.OUTPUT;
        }
        if (targetParamActionId == curAction.getBlockNodeId() || targetParamActionId == curAction.getId()) {
            return ParamDirection.INPUT;
        }
        return ParamDirection.OUTPUT;
    }
}

