/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build.impl;

import java.util.List;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.biz.NodeApplicationFactory;
import kd.ai.gai.core.flow.biz.NodeCallBackFactory;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.build.INodeBuilderFactory;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.flow.core.BlockBuilder;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BasicNodeBuilderFactory
implements INodeBuilderFactory {
    private static final Log logger = LogFactory.getLog(BasicNodeBuilderFactory.class);

    @Override
    public NodeBuilder buildNode(BlockBuilder parent, Context context, Flow gaiFlow, Action action) {
        try {
            String nodeId = String.valueOf(action.getId());
            if (action instanceof BatchAction && ((BatchAction)action).isEnableBatch()) {
                nodeId = String.format("%s.%s", action.getId(), "innerNode");
            }
            NodeBuilder nodeBuilder = parent.node(nodeId, action.getName());
            AbstractNodeApplication<? extends Action> nodeApplication = NodeApplicationFactory.getNodeApplication(context, gaiFlow, action);
            if (nodeApplication == null) {
                return nodeBuilder;
            }
            boolean isParentBlockSupportCallBack = true;
            if (action.isBlockInnerNode()) {
                Action parentAction = gaiFlow.findActionById(action.getBlockNodeId());
                boolean bl = isParentBlockSupportCallBack = !parentAction.isParallelBlockNode();
            }
            if (isParentBlockSupportCallBack) {
                nodeBuilder.biz(nodeApplication, NodeCallBackFactory.getCallBack(context, gaiFlow, action));
            } else {
                nodeBuilder.biz(nodeApplication);
            }
            return nodeBuilder;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
    }

    @Override
    public List<ParamDefinition> getParentScopeDefinitions(Action action) {
        return action.getOutputParams();
    }

    @Override
    public List<ParamDefinition> getCurrentScopeDefinitions(Action action) {
        if (action instanceof BatchAction) {
            return action.getParamByGroup(action.getInputParamGroup());
        }
        return action.getInputParams();
    }
}

