/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.flow.biz.application.BatchProcessNodeApplicationImpl;
import kd.ai.gai.core.flow.build.INodeBuilderFactory;
import kd.ai.gai.core.flow.build.NodeBuilderFactory;
import kd.ai.gai.core.flow.build.NodeVariableItem;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.impl.BasicNodeBuilderFactory;
import kd.ai.gai.core.flow.connector.server.GaiFlowTaskExecutor;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.flow.connector.server.TaskExecutor;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.dt.DataTypes;
import kd.ai.gai.flow.flow.core.BlockBuilder;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.VariableMapping;
import kd.ai.gai.flow.flow.core.VariableScopeBuilder;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Listener;

public class BatchProcessNodeBuilderFactory
implements INodeBuilderFactory {
    public static Event EVENT_SET_VARIABLES = Event.ON_READY;
    public static Event EVENT_SET_OUTPUT = Event.ON_COMPLETED;
    public static final String PARAM_BATCH_INDEX_ARRAY = "BatchIndexArray";
    public static final String PARAM_BATCH_INDEX = "BatchIndex";
    private VariableMapping inputVarMapping;
    private Set<String> otherDependVariableIds;
    private List<VariableMapping> outputVarMappings;

    @Override
    public NodeBuilder buildNode(BlockBuilder parent, Context context, Flow gaiFlow, Action action) {
        ArrayList<Action> batchProcessChildNodes;
        String nodeId = String.valueOf(action.getId());
        String nodeName = action.getName();
        BatchAction batchProcessAction = (BatchAction)action;
        List<Action> gaiFlowActions = gaiFlow.getActions();
        if (action.isParallelBlockNode()) {
            batchProcessChildNodes = gaiFlowActions.stream().filter(ac -> ac.getBlockNodeId() == action.getId()).collect(Collectors.toList());
        } else {
            batchProcessChildNodes = new ArrayList<Action>(1);
            batchProcessChildNodes.add(action);
        }
        NodeBuilder batchProcessNodeBuilder = parent.node(nodeId, nodeName);
        batchProcessNodeBuilder.biz((Application)new BatchProcessNodeApplicationImpl(context, gaiFlow, batchProcessAction));
        this.prepareRefrenceVariables(batchProcessChildNodes, batchProcessAction, gaiFlow);
        this.buildBatchProcessVariables(batchProcessNodeBuilder, batchProcessAction);
        this.buildBatchProcessBlockNodes(batchProcessNodeBuilder, context, gaiFlow, batchProcessAction, batchProcessChildNodes);
        return batchProcessNodeBuilder;
    }

    @Override
    public List<ParamDefinition> getParentScopeDefinitions(Action action) {
        BatchAction batchAction = (BatchAction)action;
        return batchAction.getBatchOutputParams();
    }

    @Override
    public List<ParamDefinition> getCurrentScopeDefinitions(Action action) {
        BatchAction batchAction = (BatchAction)action;
        List<ParamDefinition> intputParamDefList = batchAction.getBatchInputParams();
        List<ParamDefinition> innerParamDefList = batchAction.getParamByGroup("BATCH_INNER_GROUP");
        ArrayList<ParamDefinition> currentScopeDefinitions = new ArrayList<ParamDefinition>(intputParamDefList.size() + innerParamDefList.size());
        currentScopeDefinitions.addAll(intputParamDefList);
        currentScopeDefinitions.addAll(innerParamDefList);
        return currentScopeDefinitions;
    }

    @Override
    public Listener getListener(Context context, Flow gaiFlow, Action action) {
        return new BatchProcessNodeApplicationImpl(context, gaiFlow, (BatchAction)action);
    }

    private void prepareRefrenceVariables(List<Action> childActions, BatchAction batchProcessAction, Flow gaiFlow) {
        this.otherDependVariableIds = new HashSet<String>(childActions.size());
        for (Action action : childActions) {
            List<ParamDefinition> inputParamDefList = action.getParamByDirection(ParamDirection.INPUT, ParamDirection.BOTH, ParamDirection.OUTPUT);
            for (ParamDefinition paramDef : inputParamDefList) {
                this.addDependVariable(action, paramDef);
            }
            this.addTransferRefrenceVariables(action, gaiFlow);
        }
        List<ParamDefinition> inputParamDefList = batchProcessAction.getParamByDirection(ParamDirection.INPUT, ParamDirection.BOTH, ParamDirection.OUTPUT);
        for (ParamDefinition paramDef : inputParamDefList) {
            this.addDependVariable(batchProcessAction, paramDef);
        }
    }

    private void addTransferRefrenceVariables(Action action, Flow gaiFlow) {
        List<Integer> outTransferList = action.getTransferOutList();
        for (Integer transferId : outTransferList) {
            Transfer transfer = gaiFlow.findTransferById(transferId);
            if (transfer.getCondition() == null) continue;
            Condition condition = transfer.getCondition();
            List<Condition.Row> conditionRows = condition.getConditionRows();
            for (Condition.Row row : conditionRows) {
                int leftRefNodeId = row.getLeftParamPath().getNodeIdAtInt();
                this.otherDependVariableIds.add(VariableBuilderFactory.getVariableId(leftRefNodeId, row.getLeftParamPath().getOutputParamName(), VariableBuilderFactory.getDirection(action, leftRefNodeId)));
                if (row.getValueType() != Condition.ValueType.PARAM) continue;
                int rightRefNodeId = row.getLeftParamPath().getNodeIdAtInt();
                this.otherDependVariableIds.add(VariableBuilderFactory.getVariableId(rightRefNodeId, row.getRightParamPath().getOutputParamName(), VariableBuilderFactory.getDirection(action, rightRefNodeId)));
            }
        }
    }

    private void addDependVariable(Action targetAction, ParamDefinition targetParamDef) {
        if (targetParamDef.isReference()) {
            int refNodeId = Integer.parseInt(targetParamDef.getReferencePath().getNodeId());
            this.otherDependVariableIds.add(VariableBuilderFactory.getVariableId(Integer.parseInt(targetParamDef.getReferencePath().getNodeId()), targetParamDef.getReferencePath().getOutputParamName(), VariableBuilderFactory.getDirection(targetAction, refNodeId)));
        }
    }

    private void buildBatchProcessVariables(NodeBuilder batchProcessNodeBuilder, BatchAction parallelAction) {
        NodeVariableItem batchIndexArrayVarItem = new NodeVariableItem(parallelAction, PARAM_BATCH_INDEX_ARRAY, "\u6279\u5904\u7406\u7d22\u5f15\u6570\u7ec4", (DataType)DataTypes.listType((DataType)DataTypes.INTEGER), ParamDirection.INPUT);
        VariableBuilderFactory.build((VariableScopeBuilder)batchProcessNodeBuilder, batchIndexArrayVarItem);
        NodeVariableItem batchIndexVarItem = new NodeVariableItem(parallelAction, PARAM_BATCH_INDEX, "\u6279\u5904\u7406\u7d22\u5f15", DataTypes.INTEGER, -1, ParamDirection.INPUT);
        VariableBuilderFactory.build((VariableScopeBuilder)batchProcessNodeBuilder, batchIndexVarItem);
        this.inputVarMapping = new VariableMapping(VariableBuilderFactory.getVariableId(batchIndexArrayVarItem), VariableBuilderFactory.getVariableId(batchIndexVarItem));
        List<ParamDefinition> inputParamDefList = parallelAction.getBatchInputParams();
        if (this.otherDependVariableIds == null) {
            this.otherDependVariableIds = new HashSet<String>(inputParamDefList.size());
        }
        inputParamDefList.forEach(paramDefinition -> this.otherDependVariableIds.add(VariableBuilderFactory.getVariableId(parallelAction.getId(), paramDefinition.getName(), paramDefinition.getDirection())));
        List<ParamDefinition> outputParamDefList = parallelAction.getBatchOutputParams();
        this.outputVarMappings = new ArrayList<VariableMapping>(outputParamDefList.size());
        outputParamDefList.forEach(paramDefinition -> {
            if (paramDefinition instanceof ArrayParamDefinition) {
                ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
                NodeVariableItem arrayItemVarItem = new NodeVariableItem(parallelAction, VariableBuilderFactory.getArrayItemParamName(arrayParamDefinition), VariableBuilderFactory.getArrayItemParamName(arrayParamDefinition), arrayParamDefinition.getElementType(), paramDefinition.getDirection());
                VariableBuilderFactory.build((VariableScopeBuilder)batchProcessNodeBuilder, arrayItemVarItem);
                this.outputVarMappings.add(new VariableMapping(VariableBuilderFactory.getVariableId(parallelAction.getId(), paramDefinition.getName(), paramDefinition.getDirection()), VariableBuilderFactory.getVariableId(arrayItemVarItem)));
            }
        });
    }

    private void buildBatchProcessBlockNodes(NodeBuilder batchProcessNodeBuilder, Context context, Flow gaiFlow, BatchAction batchAction, List<Action> batchChildNodes) {
        String nodeName = batchAction.getName();
        String parallelBlockNodeId = BatchProcessNodeBuilderFactory.getBacthProcessBlockNodeId(batchAction.getId());
        String parallelBlockNodeName = String.format("%s.\u6279\u5904\u7406\u5757", nodeName);
        NodeBuilder parallelBlockNode = batchProcessNodeBuilder.node(parallelBlockNodeId, parallelBlockNodeName);
        if (batchAction instanceof ParallelAction) {
            batchChildNodes.forEach(action -> NodeBuilderFactory.buildNode((BlockBuilder)parallelBlockNode, context, gaiFlow, action));
        } else {
            NodeBuilderFactory.buildNode(new BasicNodeBuilderFactory(), (BlockBuilder)parallelBlockNode, context, gaiFlow, batchAction);
        }
        parallelBlockNode.asyncBegin((TaskExecutor)GaiFlowTaskExecutor.INSTANCE.get(), this.inputVarMapping, this.otherDependVariableIds.toArray(new String[0]), this.outputVarMappings.toArray(new VariableMapping[0]), batchAction.getParallelLimit());
        parallelBlockNode.listener(EVENT_SET_VARIABLES, (Listener)new BatchProcessNodeApplicationImpl(context, gaiFlow, batchAction));
        parallelBlockNode.listener(EVENT_SET_OUTPUT, (Listener)new BatchProcessNodeApplicationImpl(context, gaiFlow, batchAction));
        parallelBlockNode.asyncEnd();
    }

    public static String getBacthProcessBlockNodeId(int nodeId) {
        return String.format("%s.block", nodeId);
    }
}

