/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.build.impl;

import java.util.List;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.biz.application.LoopNodeApplicationImpl;
import kd.ai.gai.core.flow.build.INodeBuilderFactory;
import kd.ai.gai.core.flow.build.NodeBuilderFactory;
import kd.ai.gai.core.flow.build.NodeVariableItem;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.flow.dt.DataTypes;
import kd.ai.gai.flow.flow.core.BlockBuilder;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.VariableScopeBuilder;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Condition;
import kd.ai.gai.flow.flow.core.plugin.Listener;
import kd.ai.gai.flow.flow.core.plugin.ext.ScriptCondition;
import kd.bos.exception.KDBizException;

public class LoopNodeBuilderFactory
implements INodeBuilderFactory {
    public static final String PARAM_LOOP_INDEX = "loopIndex";
    public static final String PARAM_LOOP_BREAK_FLAG = "loopBreakFlag";
    public static Event EVENT_SET_NEXT_LOOP_VARIABLES = Event.ON_READY;
    public static Event EVENT_SET_OUTPUT_VARIABLES = Event.ON_CHILDREN_FINISHED;

    @Override
    public NodeBuilder buildNode(BlockBuilder parent, Context context, Flow gaiFlow, Action action) {
        LoopAction loopAction = (LoopAction)action;
        List<Action> gaiFlowActions = gaiFlow.getActions();
        List<Action> loopChildNodes = gaiFlowActions.stream().filter(ac -> ac.getBlockNodeId() == action.getId()).collect(Collectors.toList());
        this.verifyLoop(loopAction, loopChildNodes);
        NodeBuilder loopNodeBuilder = parent.node(String.valueOf(action.getId()), action.getName());
        loopNodeBuilder.biz((Application)new LoopNodeApplicationImpl(context, gaiFlow, loopAction));
        this.buildLoopVariables(loopNodeBuilder, loopAction);
        this.buildLoopBlockNodes(loopNodeBuilder, context, gaiFlow, loopAction, loopChildNodes);
        return loopNodeBuilder;
    }

    @Override
    public List<ParamDefinition> getParentScopeDefinitions(Action action) {
        return action.getOutputParams();
    }

    @Override
    public List<ParamDefinition> getCurrentScopeDefinitions(Action action) {
        return action.getInputParams();
    }

    @Override
    public Listener getListener(Context context, Flow gaiFlow, Action action) {
        return new LoopNodeApplicationImpl(context, gaiFlow, (LoopAction)action);
    }

    private void buildLoopBlockNodes(NodeBuilder loopNodeBuilder, Context context, Flow gaiFlow, LoopAction loopAction, List<Action> loopChildNodes) {
        String nodeId = String.valueOf(loopAction.getId());
        String nodeName = loopAction.getName();
        String startNodeId = LoopNodeBuilderFactory.getLoopStartNodeId(loopAction.getId());
        loopNodeBuilder.node(startNodeId, String.format("%s.\u5f00\u59cb", nodeName));
        String setVarNodeId = LoopNodeBuilderFactory.getLoopSetVarNodeId(loopAction.getId());
        NodeBuilder setVarNode = loopNodeBuilder.node(setVarNodeId, String.format("%s.\u8bbe\u7f6e\u53d8\u91cf", nodeName));
        setVarNode.listener(EVENT_SET_NEXT_LOOP_VARIABLES, (Listener)new LoopNodeApplicationImpl(context, gaiFlow, loopAction));
        String loopBlockNodeId = LoopNodeBuilderFactory.getLoopBlockNodeId(loopAction.getId());
        NodeBuilder loopBlockNode = loopNodeBuilder.node(loopBlockNodeId, String.format("%s.\u5faa\u73af\u4f53", nodeName));
        loopBlockNode.listener(EVENT_SET_OUTPUT_VARIABLES, (Listener)new LoopNodeApplicationImpl(context, gaiFlow, loopAction));
        loopChildNodes.forEach(nodeAction -> NodeBuilderFactory.buildNode((BlockBuilder)loopBlockNode, context, gaiFlow, nodeAction));
        String endNodeId = LoopNodeBuilderFactory.getLoopEndNodeId(loopAction.getId());
        loopNodeBuilder.node(endNodeId, String.format("%s.\u7ed3\u675f", nodeName));
        String startTransitionId = String.format("%s.transition.start", nodeId);
        loopNodeBuilder.getFlowBuilder().transition(startTransitionId, startTransitionId, startNodeId, setVarNodeId, Transition.Type.NORMAL);
        String conditionTransitionId = String.format("%s.transition.condition", nodeId);
        loopNodeBuilder.getFlowBuilder().transition(conditionTransitionId, conditionTransitionId, setVarNodeId, loopBlockNodeId, Transition.Type.NORMAL).setCondition((Condition)new ScriptCondition(String.format("!%s", VariableBuilderFactory.getVariableId(loopAction.getId(), PARAM_LOOP_BREAK_FLAG, ParamDirection.INPUT))));
        String endTransitionId = String.format("%s.transition.end", nodeId);
        loopNodeBuilder.getFlowBuilder().transition(endTransitionId, endTransitionId, setVarNodeId, endNodeId, Transition.Type.NORMAL).setCondition((Condition)new ScriptCondition(String.format("%s", VariableBuilderFactory.getVariableId(loopAction.getId(), PARAM_LOOP_BREAK_FLAG, ParamDirection.INPUT))));
        String loopTransitionId = String.format("%s.transition.loop", nodeId);
        loopNodeBuilder.getFlowBuilder().transition(loopTransitionId, loopTransitionId, loopBlockNodeId, setVarNodeId, Transition.Type.NORMAL);
    }

    private void buildLoopVariables(NodeBuilder loopNodeBuilder, LoopAction loopAction) {
        NodeVariableItem loopIndexVarItem = new NodeVariableItem(loopAction, PARAM_LOOP_INDEX, "\u5faa\u73af\u7d22\u5f15", DataTypes.INTEGER, -1, ParamDirection.INPUT);
        VariableBuilderFactory.build((VariableScopeBuilder)loopNodeBuilder, loopIndexVarItem);
        NodeVariableItem loopBreakVarItem = new NodeVariableItem(loopAction, PARAM_LOOP_BREAK_FLAG, "\u8df3\u51fa\u5faa\u73af\u6807\u5fd7", DataTypes.BOOLEAN, false, ParamDirection.INPUT);
        VariableBuilderFactory.build((VariableScopeBuilder)loopNodeBuilder, loopBreakVarItem);
        List<ParamDefinition> arrParamDefs = loopAction.getParamByGroup("LOOP_ARR_GROUP");
        if (arrParamDefs != null) {
            arrParamDefs.forEach(paramDefinition -> {
                if (!(paramDefinition instanceof ArrayParamDefinition)) {
                    throw new KDBizException("\u5faa\u73af\u6570\u7ec4\u53c2\u6570\u53ea\u652f\u6301\u6570\u7ec4\u7c7b\u578b");
                }
                ArrayParamDefinition arrayParamDefinition = (ArrayParamDefinition)paramDefinition;
            });
        }
    }

    private void verifyLoop(LoopAction action, List<Action> loopChildNodes) {
        List breakLoopNodeIdList = loopChildNodes.stream().filter(childAction -> childAction.getNodeType() == ProcessNodeType.BreakLoop).map(Node::getId).collect(Collectors.toList());
        List<ParamDefinition> loopArrParamDefs = action.getParamByGroup("LOOP_ARR_GROUP");
        if ((loopArrParamDefs == null || loopArrParamDefs.isEmpty()) && breakLoopNodeIdList.isEmpty()) {
            throw new KDBizException(Errors.flowLoopNoBreakLoop(action.getName()), new Object[0]);
        }
    }

    public static String getLoopSetVarNodeId(int loopActionId) {
        return String.format("%s.node.setvar", loopActionId);
    }

    public static String getLoopBlockNodeId(int loopActionId) {
        return String.format("%s.node.block", loopActionId);
    }

    public static String getLoopStartNodeId(int loopActionId) {
        return String.format("%s.node.start", loopActionId);
    }

    public static String getLoopEndNodeId(int loopActionId) {
        return String.format("%s.node.end", loopActionId);
    }
}

