/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.callback;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.application.MessageNodeApplication;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Callback;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public final class AskUserNodeCallback
extends BaseNodeApplication
implements Callback {
    private static final Log log = LogFactory.getLog(MessageNodeApplication.class);

    public void compile(VariableScope scope) {
    }

    public boolean inject(Execution e, Object params) {
        AskUserCallbackMessage callbackMessage = (AskUserCallbackMessage)params;
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            log.error("\u4f1a\u8bddID\uff08{}\uff09\u7684\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getChatSessionId());
            throw new KDBizException(Errors.getFlowContextIsNull(String.format("chat sessionid:%s flowId:%s", callbackMessage.getChatSessionId(), callbackMessage.getFlowId())), new Object[0]);
        }
        Flow flow = FlowCacheData.getFlowById(callbackMessage.getChatSessionId(), callbackMessage.getFlowId());
        if (flow == null) {
            log.error("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0bID\uff08{}\uff09\u7684\u7f13\u5b58\u4fe1\u606f\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getFlowId());
            throw new KDBizException(Errors.flowInstanceNotExisted(callbackMessage.getFlowId()), new Object[0]);
        }
        HashMap<String, String> outData = new HashMap<String, String>();
        AskUserAction askUserAction = (AskUserAction)flow.findActionById(callbackMessage.getNodeId());
        ChatMessage chatMessage = callbackMessage.getChatMessage();
        if (chatMessage.getInParaMap() != null && !chatMessage.getInParaMap().isEmpty()) {
            Map<String, String> inData = chatMessage.getInParaMap();
            for (Var var : askUserAction.getOutputVarList()) {
                String val = inData.get(var.getName());
                if (val == null) continue;
                outData.put(var.getName(), val);
            }
        }
        if (StringUtils.isNotEmpty((String)chatMessage.getUserInput())) {
            outData.put("askUser_output", chatMessage.getUserInput());
        }
        long end = System.currentTimeMillis();
        Node node = flow.findNodeById(callbackMessage.getNodeId());
        TraceUtil.saveFlowNodeLog(new Result(Errors.OK), context, flow, node, callbackMessage.getMessage(), askUserAction, callbackMessage.getStartTs(), end, outData);
        FlowUtils.setNodeProperties(e, callbackMessage.getNodeId(), outData);
        this.cacheDebugVarValue(context, flow, callbackMessage.getNodeId(), e);
        return true;
    }

    public String toString() {
        return "";
    }
}

