/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.condition;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.flow.build.VariableBuilderFactory;
import kd.ai.gai.core.flow.build.attribute.FlowAttribute;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.execution.ParamManagerFactory;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.ScriptEngine;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Condition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiCondition
implements Condition {
    private static final Log log = LogFactory.getLog(GaiCondition.class);
    private static final String VAR_PREFIX = "__GAI_V_";
    private static final char SPACE = ' ';
    private static final String PARSE_FLOAT = "parseFloat";
    private static final int EMPTY_FLOAT_VALUE = -9009000;
    private final Context context;
    private final Flow gaiFlow;
    private final Transfer transfer;
    private final kd.ai.gai.core.engine.flow.Condition gaiCondition;
    private final boolean besides;
    private final int parallelIndex;

    public GaiCondition(Context context, Flow gaiFlow, Transfer transfer, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.transfer = transfer;
        this.gaiCondition = transfer.getCondition();
        this.besides = false;
        this.parallelIndex = parallelIndex;
    }

    public boolean test(Execution e) {
        e.setProperty("EXECUTING_CONDITION", (Object)true);
        e.setProperty("EXECUTING_CONDITION_TONODE_ID", (Object)this.transfer.getToNodeId());
        boolean test = this.besides != this.execCondition(this.context, this.gaiFlow, this.gaiCondition, e, this.parallelIndex);
        log.info("GaiCondition:{} && besides:{}, test:{}, parallelIndex:{}", new Object[]{JSONObject.toJSONString((Object)this.gaiCondition), this.besides, test, this.parallelIndex});
        e.clearProperty("EXECUTING_CONDITION");
        e.clearProperty("EXECUTING_CONDITION_TONODE_ID");
        return test;
    }

    public void compile(VariableScope scope) {
    }

    private boolean execCondition(Context context, Flow gaiFlow, kd.ai.gai.core.engine.flow.Condition condition, Execution e, int parallelIndex) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>();
        AtomicInteger varIndex = new AtomicInteger();
        StringBuilder script = new StringBuilder();
        for (Condition.Row row : condition.getConditionRows()) {
            String varValueRight;
            String varValueLeft;
            if (!row.check()) {
                throw new KDBizException(Errors.conditionConfigError(condition.getName()), new Object[0]);
            }
            String leftVarName = this.getVariableId(e, Integer.parseInt(row.getLeftParamPath().getNodeId()), row.getLeftParamPath().getOutputParamName());
            Condition.ValueType leftVarValueType = this.getNodePropertyValueType(context, gaiFlow, e, parallelIndex, row.getLeftParamPath().getNodeIdAtInt(), row.getLeftParamPath().getOutputParamName());
            String varAlias = varMap.computeIfAbsent(leftVarName, k -> VAR_PREFIX + varIndex.getAndIncrement());
            String finalVarValueLeft = varValueLeft = this.getVarValue(e, row.getLeftParamPath());
            scriptCtx.computeIfAbsent(varAlias, k -> finalVarValueLeft);
            if (script.length() > 0) {
                Condition.RelationType relationType = condition.getRelation();
                if (relationType == null || relationType == Condition.RelationType.AND) {
                    script.append(" && ");
                } else {
                    script.append(" || ");
                }
            }
            if (Condition.Operator.ISNOTNULL == row.getOperator() || Condition.Operator.ISNULL == row.getOperator()) {
                if (Condition.Operator.ISNOTNULL == row.getOperator() && StringUtils.isNotEmpty((CharSequence)varValueLeft)) {
                    script.append("true");
                    continue;
                }
                if (Condition.Operator.ISNULL == row.getOperator() && StringUtils.isEmpty((CharSequence)varValueLeft)) {
                    script.append("true");
                    continue;
                }
                script.append("false");
                continue;
            }
            if (leftVarValueType == Condition.ValueType.DECIMAL) {
                if (StringUtils.isEmpty((CharSequence)varValueLeft)) {
                    log.info("varValueLeft is empty");
                    varValueLeft = String.valueOf(-9009000);
                }
                script.append(PARSE_FLOAT).append("(\"").append(varValueLeft).append("\")");
            } else {
                script.append(varAlias);
            }
            script.append(' ').append((Object)row.getOperator()).append(' ');
            if (Condition.ValueType.TEXT == row.getValueType()) {
                script.append(' ').append('\"').append(row.getText()).append('\"').append(' ');
                continue;
            }
            if (Condition.ValueType.DECIMAL == row.getValueType()) {
                String rowText = row.getText();
                if (StringUtils.isEmpty((CharSequence)rowText)) {
                    log.info("row.getText() is empty");
                    rowText = String.valueOf(-9008999);
                }
                script.append(' ').append(PARSE_FLOAT).append("(\"").append(rowText).append("\")").append(' ');
                continue;
            }
            String rightVarName = this.getVariableId(e, row.getRightParamPath().getNodeIdAtInt(), row.getRightParamPath().getOutputParamName());
            varAlias = varMap.computeIfAbsent(rightVarName, k -> VAR_PREFIX + varIndex.getAndIncrement());
            String finalVarValueRight = varValueRight = this.getVarValue(e, row.getRightParamPath());
            scriptCtx.computeIfAbsent(varAlias, k -> finalVarValueRight);
            Condition.ValueType rightVarValueType = this.getNodePropertyValueType(context, gaiFlow, e, parallelIndex, row.getRightParamPath().getNodeIdAtInt(), row.getRightParamPath().getOutputParamName());
            if (rightVarValueType == Condition.ValueType.DECIMAL) {
                if (StringUtils.isEmpty((CharSequence)varValueRight)) {
                    log.info("varValueRight is empty");
                    varValueRight = String.valueOf(-9008998);
                }
                script.append(' ').append(PARSE_FLOAT).append("(\"").append(varValueRight).append("\")").append(' ');
                continue;
            }
            script.append(' ').append(varAlias).append(' ');
        }
        log.info("script:{}, scriptCtx:{}", (Object)script, (Object)JSONObject.toJSONString(scriptCtx));
        return (Boolean)ScriptEngine.getEngine().runScript(script.toString(), scriptCtx);
    }

    private Condition.ValueType getNodePropertyValueType(Context context, Flow gaiFlow, Execution e, int parallelIndex, int nodeId, String outputParamName) {
        if (ParamMode.VARIABLE.name().equals(gaiFlow.getParamMode())) {
            ParamType paramType;
            Optional<ParamDefinition> paramDefinition = gaiFlow.findActionById(nodeId).getParamByName(outputParamName, ParamVisibility.PUBLIC, ParamVisibility.PRIVATE);
            if (paramDefinition.isPresent() && (ParamType.INTEGER == (paramType = paramDefinition.get().getType()) || ParamType.FLOAT == paramType)) {
                return Condition.ValueType.DECIMAL;
            }
            return Condition.ValueType.TEXT;
        }
        return FlowUtils.getNodePropertyValueType(context, gaiFlow, e, nodeId, outputParamName, parallelIndex);
    }

    private String getVariableId(Execution e, int nodeId, String varName) {
        Action inAction = this.gaiFlow.findActionById(this.transfer.getToNodeId());
        if (this.getParamMode(e) == ParamMode.PROPERTY) {
            return FlowUtils.getPropertyName(nodeId, varName);
        }
        return VariableBuilderFactory.getVariableId(nodeId, varName, VariableBuilderFactory.getDirection(inAction, nodeId));
    }

    private String getVarValue(Execution e, NodeParamPath nodeParamPath) {
        int nodeId = Integer.parseInt(nodeParamPath.getNodeId());
        String varName = nodeParamPath.getOutputParamName();
        if (this.getParamMode(e) == ParamMode.PROPERTY) {
            return FlowUtils.getVarValue(this.context, this.getVariableId(e, nodeId, varName), e, this.parallelIndex);
        }
        Object value = ParamManagerFactory.createParamManager().getParamValueByPath(e, nodeParamPath);
        return value == null ? "" : value.toString();
    }

    private ParamMode getParamMode(Execution e) {
        Object value = e.getDefine().getFlow().getAttribute(FlowAttribute.PARAM_MODE.name());
        if (value == null) {
            return ParamMode.PROPERTY;
        }
        return (ParamMode)((Object)value);
    }
}

