/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.connector.sys.util;

import java.util.Locale;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class DataTypeEqualsUtil {
    private static Pattern iPattern = Pattern.compile("(\\+|-)?\\d+");
    private static Pattern dPattern = Pattern.compile("(\\+|-)?\\d+(\\.\\d+)?");
    private static Pattern datePattern1 = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    private static Pattern datePattern2 = Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2}");
    private static Pattern timePattern1 = Pattern.compile("((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static Pattern timePattern2 = Pattern.compile("((19|20)[0-9]{2})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static Pattern timePattern3 = Pattern.compile("((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9].[0-9]{1,3}");
    private static Pattern timePattern4 = Pattern.compile("((19|20)[0-9]{2})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9].[0-9]{1,3}");

    public static boolean isMatchType(String value, String dataType) {
        String type = dataType.toLowerCase(Locale.ENGLISH);
        if ("string".equals(type)) {
            return true;
        }
        if (value.startsWith("#{") && value.endsWith("}")) {
            return true;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return true;
        }
        if ("datetime".equals(type)) {
            return datePattern1.matcher(value).matches() || datePattern2.matcher(value).matches() || timePattern1.matcher(value).matches() || timePattern2.matcher(value).matches() || timePattern3.matcher(value).matches() || timePattern4.matcher(value).matches();
        }
        if ("integer".equals(type) || "int".equals(type)) {
            return iPattern.matcher(value).matches();
        }
        if ("decimal".equals(type)) {
            return dPattern.matcher(value).matches();
        }
        if ("map".equals(type) || "object".equals(type) || "object[]".equals(type)) {
            return true;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u503c\u548c\u7c7b\u578b(value:%1$s, dataType: %2$s)\uff0c\u65e0\u6cd5\u5224\u65ad!", (String)"DataTypeEqualsUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value, dataType));
    }
}

