/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.connector.sys.util;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.flow.connector.sys.util.ContextUtil;
import kd.ai.gai.core.flow.connector.sys.util.DataTypeEqualsUtil;
import kd.ai.gai.flow.data.LocalCache;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.misc.Triple;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ProxyUserUtil {
    private static final LocalCache<Triple<String, String, String>, Map<String, Object>> USER_CACHE = new LocalCache(1000);
    public static final String SELECTED_FIELDS = "id,name,number,username,usertype,phone,useropenid,entryentity.ispartjob,entryentity.dpt_id";
    public static final String USER_TYPE = "usertype";
    public static final String USER_OPENID = "useropenid";
    public static final String NAME = "name";
    public static final String IS_PART_JOB = "ispartjob";
    public static final String DPT_ID = "dpt_id";
    public static final String ENTRYENTITY = "entryentity";

    public static RequestContext createRequestContext(RequestContext ctx, String proxy_user) {
        return ProxyUserUtil.createRequestContext(ctx, proxy_user, ctx.getLang());
    }

    public static RequestContext createRequestContext(RequestContext ctx, String proxy_user, Lang lang) {
        String tenantId;
        String accountId = ctx.getAccountId();
        Triple key = new Triple((Object)accountId, (Object)(tenantId = ctx.getTenantId()), (Object)proxy_user);
        Map<String, Object> user = (Map<String, Object>)USER_CACHE.get((Object)key);
        if (user == null) {
            user = ProxyUserUtil.get(proxy_user);
            USER_CACHE.put((Object)key, user);
        }
        return ProxyUserUtil.createRequestContext(ctx, user, lang);
    }

    public static RequestContext createRequestContext(RequestContext current, Map<String, Object> user, Lang lang) {
        String accountId = current.getAccountId();
        String tenantId = current.getTenantId();
        String userId = D.s((Object)user.get("id"));
        RequestContext rc = ContextUtil.createRequestContext(accountId, tenantId, userId, D.s((Object)user.get(NAME)));
        rc.setTraceId(current.getTraceId());
        rc.setTenantCode(current.getTenantCode());
        rc.setUserAgent(current.getUserAgent());
        rc.setUserType(D.s((Object)user.get(USER_TYPE)));
        rc.setUserOpenId(D.s((Object)user.get(USER_OPENID)));
        rc.setUid(String.valueOf(userId));
        rc.setLang(lang);
        Object dpt_id = user.get(DPT_ID);
        if (dpt_id != null) {
            rc.setOrgId(D.l((Object)dpt_id));
        }
        return rc;
    }

    public static Map<String, Object> loadUserInfo(DynamicObject info) {
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("id", info.getPkValue());
        user.put(NAME, info.getString(NAME));
        user.put(USER_TYPE, info.getString(USER_TYPE));
        user.put(USER_OPENID, info.getString(USER_OPENID));
        for (DynamicObject entry : info.getDynamicObjectCollection(ENTRYENTITY)) {
            if (entry.getBoolean(IS_PART_JOB)) continue;
            user.put(DPT_ID, entry.getLong(DPT_ID));
        }
        return user;
    }

    public static Map<String, Object> get(String proxy_user) {
        DynamicObject user = DataTypeEqualsUtil.isMatchType(proxy_user, "integer") ? ProxyUserUtil.getByInteger(proxy_user) : ProxyUserUtil.getByString(proxy_user);
        if (user != null) {
            return ProxyUserUtil.loadUserInfo(user);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4ee3\u7406\u7528\u6237%s!", (String)"ProxyUserUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proxy_user));
    }

    private static DynamicObject getByInteger(String proxy_user) {
        QFilter filter = new QFilter("id", "=", (Object)D.l((Object)proxy_user)).or(new QFilter("number", "=", (Object)proxy_user)).or(new QFilter("phone", "=", (Object)proxy_user));
        return BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getByString(String proxy_user) {
        QFilter filter = new QFilter("number", "=", (Object)proxy_user).or(new QFilter("username", "=", (Object)proxy_user));
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{filter});
        if (users.length == 1) {
            return users[0];
        }
        if (users.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5de5\u53f7\u6216\u7528\u6237\u540d: %s,\u6ca1\u6709\u627e\u5230\u4ee3\u7406\u7528\u6237\u3002", (String)"ProxyUserUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proxy_user));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5de5\u53f7\u6216\u7528\u6237\u540d: %s,\u627e\u5230\u591a\u4e2a\u4ee3\u7406\u7528\u6237\u3002", (String)"ProxyUserUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proxy_user));
    }

    public void clearCollection() {
        USER_CACHE.clear();
    }
}

