/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.flow.build.attribute.NodeAttribute;
import kd.ai.gai.core.flow.build.attribute.VariableAttribute;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.execution.ParamManagerFactory;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.Variable;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.plugin.Listener;

public class InitVariableListener
implements Listener {
    public void execute(Execution e) {
        if (e.getDefine() instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)e.getDefine();
            Object bRequireInitVars = nodeImpl.getAttribute(NodeAttribute.REQUIRES_INIT_VARIABLES.name());
            if (bRequireInitVars == null || !((Boolean)bRequireInitVars).booleanValue()) {
                return;
            }
            Object curNodeId = nodeImpl.getAttribute(NodeAttribute.NODE_ID.name());
            if (curNodeId == null) {
                return;
            }
            int currentNodeId = (Integer)curNodeId;
            this.initNodeVariable(e, currentNodeId, nodeImpl.getParent());
            this.initNodeVariable(e, currentNodeId, nodeImpl);
        }
    }

    private void initNodeVariable(Execution e, int currentNodeId, NodeImpl nodeImpl) {
        if (nodeImpl == null) {
            return;
        }
        HashMap mapVariables = new HashMap(nodeImpl.getVariables().size());
        Map<Object, Object> mapInputVariables = new HashMap(1);
        if (nodeImpl.getId().equals(nodeImpl.getFlow().getRoot().getId())) {
            mapVariables.putAll(nodeImpl.getFlow().getVariables());
            mapInputVariables = nodeImpl.getFlow().getInputVariables().stream().collect(Collectors.toMap(VariableImpl::getName, Function.identity()));
        } else {
            mapVariables.putAll(nodeImpl.getVariables());
        }
        for (VariableImpl variable : mapVariables.values()) {
            int varNodeId;
            Object bRequireInit = variable.getAttribute(VariableAttribute.REQUIRES_INIT.name());
            if (bRequireInit == null || !((Boolean)bRequireInit).booleanValue() || currentNodeId != (varNodeId = ((Integer)variable.getAttribute(VariableAttribute.NODE_ID.name())).intValue()) || mapInputVariables.containsKey(variable.getName()) || variable.getAttribute(VariableAttribute.PARAM_DEFINITION.name()) == null) continue;
            ParamDefinition paramDefinition = (ParamDefinition)variable.getAttribute(VariableAttribute.PARAM_DEFINITION.name());
            ParamManagerFactory.createParamManager().initParamValue(e, (Variable)variable, paramDefinition);
        }
    }
}

