/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.node;

import com.alibaba.fastjson.annotation.JSONField;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;

public interface DesignNode {
    public static final String DEFAULT_GROUP = "DEFAULT_GROUP";

    public Map<String, Map<String, ParamDefinition>> getParams();

    public ParamDefinition addParam(String var1, ParamDefinition var2);

    public void addParams(String var1, Collection<ParamDefinition> var2);

    public void setParams(String var1, Collection<ParamDefinition> var2);

    public ParamDefinition removeParam(String var1, String var2);

    public Collection<ParamDefinition> clearGroupParams(String var1);

    public void compileParamReference(Flow var1);

    @Transient
    @JSONField(serialize=false)
    default public List<ParamDefinition> getParamByGroup(String group) {
        Map<String, ParamDefinition> groupParams = this.getParams().get(group);
        return groupParams != null ? new ArrayList<ParamDefinition>(groupParams.values()) : new ArrayList();
    }

    @Transient
    @JSONField(serialize=false)
    default public Optional<ParamDefinition> getParamByName(String group, String paramName) {
        Map<String, ParamDefinition> groupParams = this.getParams().get(group);
        if (groupParams == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(groupParams.get(paramName));
    }

    @Transient
    @JSONField(serialize=false)
    default public Optional<ParamDefinition> getParamByName(String paramName, ParamVisibility ... paramVisibility) {
        HashSet<ParamVisibility> paramVisibilitySet = new HashSet<ParamVisibility>(Arrays.asList(paramVisibility));
        Map<String, Map<String, ParamDefinition>> params = this.getParams();
        for (Map<String, ParamDefinition> paramDefByName : params.values()) {
            for (ParamDefinition paramDefinition : paramDefByName.values()) {
                if (!paramVisibilitySet.contains((Object)paramDefinition.getVisibility()) || !paramDefinition.getName().equals(paramName)) continue;
                return Optional.of(paramDefinition);
            }
        }
        return Optional.empty();
    }

    @Transient
    @JSONField(serialize=false)
    default public List<ParamDefinition> getParamByDirection(ParamDirection ... paramDirections) {
        HashSet<ParamDirection> directions = new HashSet<ParamDirection>(Arrays.asList(paramDirections));
        ArrayList<ParamDefinition> result = new ArrayList<ParamDefinition>();
        for (Map<String, ParamDefinition> groupParams : this.getParams().values()) {
            for (ParamDefinition paramDefinition : groupParams.values()) {
                if (!directions.contains((Object)paramDefinition.getDirection())) continue;
                result.add(paramDefinition);
            }
        }
        return result;
    }

    @Transient
    @JSONField(serialize=false)
    default public List<ParamDefinition> getInputParams() {
        ArrayList<ParamDefinition> result = new ArrayList<ParamDefinition>();
        for (Map<String, ParamDefinition> groupParams : this.getParams().values()) {
            for (ParamDefinition paramDefinition : groupParams.values()) {
                if (!paramDefinition.isInput()) continue;
                result.add(paramDefinition);
            }
        }
        return result;
    }

    @Transient
    @JSONField(serialize=false)
    default public List<ParamDefinition> getOutputParams() {
        ArrayList<ParamDefinition> result = new ArrayList<ParamDefinition>();
        for (Map<String, ParamDefinition> groupParams : this.getParams().values()) {
            for (ParamDefinition paramDefinition : groupParams.values()) {
                if (!paramDefinition.isOutput()) continue;
                result.add(paramDefinition);
            }
        }
        return result;
    }
}

