/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.node;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.BreakLoopAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.MserviceAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.ScriptAction;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.StartLoopAction;
import kd.ai.gai.core.engine.flow.StartParallelAction;
import kd.ai.gai.core.engine.flow.VirtualAction;

public enum ExecutionNodeType {
    START(1, "\u6d41\u7a0b\u5f00\u59cb", Start.class),
    END(2, "\u6d41\u7a0b\u7ed3\u675f", End.class),
    MESSAGE(3, "\u6d88\u606f\u5c55\u793a", MessageAction.class),
    ASK_USER(4, "\u8be2\u95ee\u7528\u6237", AskUserAction.class),
    LLM(5, "\u5927\u6a21\u578b", LLMAction.class),
    LLM_QUESTION_CLASSIFY(51, "\u95ee\u9898\u5206\u7c7b", LLMAction.class),
    LLM_QUESTION_REWRITE(52, "\u95ee\u9898\u6539\u5199", LLMAction.class),
    REPO(6, "\u77e5\u8bc6\u5e93\u67e5\u8be2", RepoAction.class),
    REPO_REPLY(7, "\u77e5\u8bc6\u5e93\u56de\u590d", RepoReplyAction.class),
    SET_VARIABLE(8, "\u8bbe\u7f6e\u53d8\u91cf", SetVariableAction.class),
    CODE(9, "\u4ee3\u7801\u811a\u672c", CodeAction.class),
    SCRIPT(10, "\u811a\u672c", ScriptAction.class),
    LOOP(11, "\u5faa\u73af\u5904\u7406", LoopAction.class),
    START_LOOP(12, "\u5f00\u59cb\u5faa\u73af", StartLoopAction.class),
    BREAK_LOOP(13, "\u4e2d\u65ad\u5faa\u73af", BreakLoopAction.class),
    PARALLEL(14, "\u5e76\u884c\u5904\u7406", ParallelAction.class),
    START_PARALLEL(15, "\u5f00\u59cb\u5e76\u884c", StartParallelAction.class),
    JAVA_PLUGIN(16, "Java\u63d2\u4ef6", JavaPluginAction.class),
    MSERVICE(17, "\u5fae\u670d\u52a1", MserviceAction.class),
    VIRTUAL(18, "\u865a\u62df\u8282\u70b9", VirtualAction.class);

    private final int type;
    private final String desc;
    private final Class<? extends Node> designNodeClass;

    private ExecutionNodeType(int type, String desc, Class<? extends Node> designNodeClass) {
        this.type = type;
        this.desc = desc;
        this.designNodeClass = designNodeClass;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<? extends Node> getDesignNodeClass() {
        return this.designNodeClass;
    }

    public static ExecutionNodeType fromDesignNode(Node designNode, Function<List<ExecutionNodeType>, ExecutionNodeType> selector) {
        if (designNode == null) {
            return null;
        }
        ArrayList<ExecutionNodeType> matchingTypes = new ArrayList<ExecutionNodeType>();
        for (ExecutionNodeType type : ExecutionNodeType.values()) {
            if (!type.getDesignNodeClass().isInstance(designNode)) continue;
            matchingTypes.add(type);
        }
        if (matchingTypes.isEmpty()) {
            return null;
        }
        if (matchingTypes.size() == 1) {
            return (ExecutionNodeType)((Object)matchingTypes.get(0));
        }
        return selector.apply(matchingTypes);
    }

    public static ExecutionNodeType fromDesignNode(Node designNode) {
        return ExecutionNodeType.fromDesignNode(designNode, list -> (ExecutionNodeType)((Object)((Object)list.get(0))));
    }

    public static List<ExecutionNodeType> getAllFromDesignClass(Class<? extends Node> designNodeClass) {
        if (designNodeClass == null) {
            return new ArrayList<ExecutionNodeType>();
        }
        ArrayList<ExecutionNodeType> matchingTypes = new ArrayList<ExecutionNodeType>();
        for (ExecutionNodeType type : ExecutionNodeType.values()) {
            if (!type.getDesignNodeClass().equals(designNodeClass)) continue;
            matchingTypes.add(type);
        }
        return matchingTypes;
    }

    public static ExecutionNodeType fromDesignClass(Class<? extends Node> designNodeClass, Function<List<ExecutionNodeType>, ExecutionNodeType> selector) {
        List<ExecutionNodeType> matchingTypes = ExecutionNodeType.getAllFromDesignClass(designNodeClass);
        if (matchingTypes.isEmpty()) {
            return null;
        }
        if (matchingTypes.size() == 1) {
            return matchingTypes.get(0);
        }
        return selector.apply(matchingTypes);
    }

    public static ExecutionNodeType fromDesignClass(Class<? extends Node> designNodeClass) {
        return ExecutionNodeType.fromDesignClass(designNodeClass, list -> (ExecutionNodeType)((Object)((Object)list.get(0))));
    }

    public static ExecutionNodeType fromType(int type) {
        for (ExecutionNodeType executionNodeType : ExecutionNodeType.values()) {
            if (executionNodeType.getType() != type) continue;
            return executionNodeType;
        }
        return null;
    }
}

