/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.builder;

import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.FormatDateParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;

public class ParamDefinitionBuilder {
    public static BasicParamBuilder string(String name) {
        return new BasicParamBuilder(name, ParamType.STRING);
    }

    public static BasicParamBuilder integer(String name) {
        return new BasicParamBuilder(name, ParamType.INTEGER);
    }

    public static BasicParamBuilder ffloat(String name) {
        return new BasicParamBuilder(name, ParamType.FLOAT);
    }

    public static BasicParamBuilder bool(String name) {
        return new BasicParamBuilder(name, ParamType.BOOLEAN);
    }

    public static BasicParamBuilder date(String name) {
        return new BasicParamBuilder(name, ParamType.DATE);
    }

    public static FormatDateParamBuilder formatDate(String name) {
        return new FormatDateParamBuilder(name);
    }

    public static BasicParamBuilder constantString(String name, String value) {
        BasicParamBuilder builder = ParamDefinitionBuilder.string(name);
        builder.constant(value);
        return builder;
    }

    public static BasicParamBuilder constantInteger(String name, Integer value) {
        BasicParamBuilder builder = ParamDefinitionBuilder.integer(name);
        builder.constant(value);
        return builder;
    }

    public static BasicParamBuilder constantFloat(String name, Double value) {
        BasicParamBuilder builder = ParamDefinitionBuilder.ffloat(name);
        builder.constant(value);
        return builder;
    }

    public static BasicParamBuilder constantBool(String name, Boolean value) {
        BasicParamBuilder builder = ParamDefinitionBuilder.bool(name);
        builder.constant(value);
        return builder;
    }

    public static ObjectParamBuilder object(String name) {
        return new ObjectParamBuilder(name);
    }

    public static ArrayParamBuilder array(String name, ParamDefinition itemDefinition) {
        return new ArrayParamBuilder(name, itemDefinition);
    }

    public static ArrayParamBuilder stringArray(String name) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.string("item").build());
    }

    public static ArrayParamBuilder integerArray(String name) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.integer("item").build());
    }

    public static ArrayParamBuilder floatArray(String name) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.ffloat("item").build());
    }

    public static ArrayParamBuilder booleanArray(String name) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.bool("item").build());
    }

    public static ArrayParamBuilder dateArray(String name) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.date("item").build());
    }

    public static ArrayParamBuilder objectArray(String name, ObjectParamDefinition objectDef) {
        return ParamDefinitionBuilder.array(name, objectDef);
    }

    public static MessageParamBuilder message(String name, MessageType messageType) {
        return new MessageParamBuilder(name, messageType);
    }

    public static MessageParamBuilder textMessage(String name) {
        return ParamDefinitionBuilder.message(name, MessageType.Text);
    }

    public static MessageParamBuilder hyperLinkMessage(String name) {
        return ParamDefinitionBuilder.message(name, MessageType.HyperLink);
    }

    public static MessageParamBuilder pictureMessage(String name) {
        return ParamDefinitionBuilder.message(name, MessageType.Picture);
    }

    public static MessageParamBuilder iframeMessage(String name) {
        return ParamDefinitionBuilder.message(name, MessageType.Iframe);
    }

    public static ArrayParamBuilder messageArray(String name, MessageType messageType) {
        return ParamDefinitionBuilder.array(name, ParamDefinitionBuilder.message("item", messageType).build());
    }

    public static class FormatDateParamBuilder
    implements ParamBuilder<FormatDateParamBuilder, FormatDateParamDefinition> {
        private final FormatDateParamDefinition definition;

        public FormatDateParamBuilder(String name) {
            this.definition = new FormatDateParamDefinition(name);
        }

        public FormatDateParamBuilder format(String format) {
            this.definition.setFormat(format);
            return this;
        }

        @Override
        public FormatDateParamDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public FormatDateParamBuilder description(String description) {
            this.definition.setDescription(description);
            return this;
        }

        @Override
        public FormatDateParamBuilder required(boolean required) {
            this.definition.setRequired(required);
            return this;
        }

        @Override
        public FormatDateParamBuilder direction(ParamDirection direction) {
            this.definition.setDirection(direction);
            return this;
        }

        @Override
        public FormatDateParamBuilder visibility(ParamVisibility visibility) {
            this.definition.setVisibility(visibility);
            return this;
        }

        @Override
        public FormatDateParamBuilder constant(Object value) {
            this.definition.setConstantValue(value);
            return this;
        }

        @Override
        public FormatDateParamBuilder reference(String referencePathStr) {
            this.definition.setReferencePath(referencePathStr);
            return this;
        }

        @Override
        public FormatDateParamBuilder reference(NodeParamPath referencePath) {
            this.definition.setReferencePath(referencePath);
            return this;
        }

        @Override
        public FormatDateParamBuilder makePrivate() {
            this.definition.setVisibility(ParamVisibility.PRIVATE);
            return this;
        }

        @Override
        public FormatDateParamBuilder makePublic() {
            this.definition.setVisibility(ParamVisibility.PUBLIC);
            return this;
        }

        @Override
        public FormatDateParamBuilder asInput() {
            this.definition.setDirection(ParamDirection.INPUT);
            return this;
        }

        @Override
        public FormatDateParamBuilder asOutput() {
            this.definition.setDirection(ParamDirection.OUTPUT);
            return this;
        }

        @Override
        public FormatDateParamBuilder asBoth() {
            this.definition.setDirection(ParamDirection.BOTH);
            return this;
        }

        @Override
        public FormatDateParamDefinition build() {
            return this.definition;
        }
    }

    public static class MessageParamBuilder
    implements ParamBuilder<MessageParamBuilder, MessageParamDefinition> {
        private final MessageParamDefinition definition;

        public MessageParamBuilder(String name, MessageType messageType) {
            this.definition = new MessageParamDefinition(name, messageType);
        }

        @Override
        public MessageParamDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public MessageParamBuilder description(String description) {
            this.definition.setDescription(description);
            return this;
        }

        @Override
        public MessageParamBuilder required(boolean required) {
            this.definition.setRequired(required);
            return this;
        }

        @Override
        public MessageParamBuilder direction(ParamDirection direction) {
            this.definition.setDirection(direction);
            return this;
        }

        @Override
        public MessageParamBuilder visibility(ParamVisibility visibility) {
            this.definition.setVisibility(visibility);
            return this;
        }

        @Override
        public MessageParamBuilder constant(Object value) {
            this.definition.setConstantValue(value);
            return this;
        }

        @Override
        public MessageParamBuilder reference(String referencePathStr) {
            this.definition.setReferencePath(referencePathStr);
            return this;
        }

        @Override
        public MessageParamBuilder reference(NodeParamPath referencePath) {
            this.definition.setReferencePath(referencePath);
            return this;
        }

        @Override
        public MessageParamBuilder makePrivate() {
            this.definition.setVisibility(ParamVisibility.PRIVATE);
            return this;
        }

        @Override
        public MessageParamBuilder makePublic() {
            this.definition.setVisibility(ParamVisibility.PUBLIC);
            return this;
        }

        @Override
        public MessageParamBuilder asInput() {
            this.definition.setDirection(ParamDirection.INPUT);
            return this;
        }

        @Override
        public MessageParamBuilder asOutput() {
            this.definition.setDirection(ParamDirection.OUTPUT);
            return this;
        }

        @Override
        public MessageParamBuilder asBoth() {
            this.definition.setDirection(ParamDirection.BOTH);
            return this;
        }

        @Override
        public MessageParamDefinition build() {
            return this.definition;
        }
    }

    public static class ArrayParamBuilder
    implements ParamBuilder<ArrayParamBuilder, ArrayParamDefinition> {
        private final ArrayParamDefinition definition;

        public ArrayParamBuilder(String name, ParamDefinition itemDefinition) {
            if (itemDefinition == null) {
                throw new IllegalArgumentException("\u6570\u7ec4\u9879\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.definition = new ArrayParamDefinition(name, itemDefinition);
        }

        @Override
        public ArrayParamDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public ArrayParamBuilder description(String description) {
            this.definition.setDescription(description);
            return this;
        }

        @Override
        public ArrayParamBuilder required(boolean required) {
            this.definition.setRequired(required);
            return this;
        }

        @Override
        public ArrayParamBuilder direction(ParamDirection direction) {
            this.definition.setDirection(direction);
            return this;
        }

        @Override
        public ArrayParamBuilder visibility(ParamVisibility visibility) {
            this.definition.setVisibility(visibility);
            return this;
        }

        @Override
        public ArrayParamBuilder constant(Object value) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("\u6570\u7ec4\u53c2\u6570\u5e38\u91cf\u503c\u5fc5\u987b\u662fList\u7c7b\u578b");
            }
            this.definition.setConstantValue(value);
            return this;
        }

        @Override
        public ArrayParamBuilder reference(String referencePathStr) {
            this.definition.setReferencePath(referencePathStr);
            return this;
        }

        @Override
        public ArrayParamBuilder reference(NodeParamPath referencePath) {
            this.definition.setReferencePath(referencePath);
            return this;
        }

        @Override
        public ArrayParamBuilder makePrivate() {
            this.definition.setVisibility(ParamVisibility.PRIVATE);
            return this;
        }

        @Override
        public ArrayParamBuilder makePublic() {
            this.definition.setVisibility(ParamVisibility.PUBLIC);
            return this;
        }

        @Override
        public ArrayParamBuilder asInput() {
            this.direction(ParamDirection.INPUT);
            return this;
        }

        @Override
        public ArrayParamBuilder asOutput() {
            this.direction(ParamDirection.OUTPUT);
            return this;
        }

        @Override
        public ArrayParamBuilder asBoth() {
            this.direction(ParamDirection.BOTH);
            return this;
        }

        @Override
        public ArrayParamDefinition build() {
            this.validateDirectionConsistency();
            return this.definition;
        }

        private void validateDirectionConsistency() {
            ParamDefinition itemDef = this.definition.getItemDefinition();
            ParamDirection arrayDirection = this.definition.getDirection();
            if (arrayDirection == null) {
                arrayDirection = itemDef.getDirection();
                this.definition.setDirection(arrayDirection);
            } else if (itemDef.getDirection() != arrayDirection) {
                itemDef.setDirection(arrayDirection);
            }
        }
    }

    public static class ObjectParamBuilder
    implements ParamBuilder<ObjectParamBuilder, ObjectParamDefinition> {
        private final ObjectParamDefinition definition;

        public ObjectParamBuilder(String name) {
            this.definition = new ObjectParamDefinition(name);
        }

        @Override
        public ObjectParamDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public ObjectParamBuilder description(String description) {
            this.definition.setDescription(description);
            return this;
        }

        @Override
        public ObjectParamBuilder required(boolean required) {
            this.definition.setRequired(required);
            return this;
        }

        @Override
        public ObjectParamBuilder direction(ParamDirection direction) {
            this.definition.setDirection(direction);
            return this;
        }

        @Override
        public ObjectParamBuilder visibility(ParamVisibility visibility) {
            this.definition.setVisibility(visibility);
            return this;
        }

        public ObjectParamBuilder property(ParamDefinition property) {
            if (this.definition.getDirection() != null && property.getDirection() != ParamDirection.BOTH && this.definition.getDirection() != property.getDirection()) {
                ParamDirection objDirection = this.definition.getDirection();
                property.setDirection(objDirection);
            }
            this.definition.addProperty(property);
            return this;
        }

        @Override
        public ObjectParamBuilder constant(Object value) {
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException("\u5bf9\u8c61\u53c2\u6570\u5e38\u91cf\u503c\u5fc5\u987b\u662fMap\u7c7b\u578b");
            }
            this.definition.setConstantValue(value);
            return this;
        }

        @Override
        public ObjectParamBuilder reference(String referencePathStr) {
            this.definition.setReferencePath(referencePathStr);
            return this;
        }

        @Override
        public ObjectParamBuilder reference(NodeParamPath referencePath) {
            this.definition.setReferencePath(referencePath);
            return this;
        }

        @Override
        public ObjectParamBuilder makePrivate() {
            this.definition.setVisibility(ParamVisibility.PRIVATE);
            return this;
        }

        @Override
        public ObjectParamBuilder makePublic() {
            this.definition.setVisibility(ParamVisibility.PUBLIC);
            return this;
        }

        @Override
        public ObjectParamBuilder asInput() {
            this.direction(ParamDirection.INPUT);
            return this;
        }

        @Override
        public ObjectParamBuilder asOutput() {
            this.direction(ParamDirection.OUTPUT);
            return this;
        }

        @Override
        public ObjectParamBuilder asBoth() {
            this.direction(ParamDirection.BOTH);
            return this;
        }

        @Override
        public ObjectParamDefinition build() {
            this.validateDirectionConsistency();
            return this.definition;
        }

        private void validateDirectionConsistency() {
            if (this.definition.getProperties() == null || this.definition.getProperties().isEmpty()) {
                return;
            }
            ParamDirection objDirection = this.definition.getDirection();
            if (objDirection == null) {
                objDirection = this.definition.getProperties().get(0).getDirection();
                this.definition.setDirection(objDirection);
            }
            for (ParamDefinition property : this.definition.getProperties()) {
                if (property.getDirection() == objDirection) continue;
                property.setDirection(objDirection);
            }
        }
    }

    public static class BasicParamBuilder
    implements ParamBuilder<BasicParamBuilder, BasicParamDefinition> {
        private final BasicParamDefinition definition;

        public BasicParamBuilder(String name, ParamType type) {
            this.definition = new BasicParamDefinition(name, type);
        }

        @Override
        public BasicParamDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public BasicParamBuilder description(String description) {
            this.definition.setDescription(description);
            return this;
        }

        @Override
        public BasicParamBuilder required(boolean required) {
            this.definition.setRequired(required);
            return this;
        }

        @Override
        public BasicParamBuilder direction(ParamDirection direction) {
            this.definition.setDirection(direction);
            return this;
        }

        @Override
        public BasicParamBuilder visibility(ParamVisibility visibility) {
            this.definition.setVisibility(visibility);
            return this;
        }

        @Override
        public BasicParamBuilder constant(Object value) {
            this.definition.setConstantValue(value);
            return this;
        }

        @Override
        public BasicParamBuilder reference(String referencePathStr) {
            this.definition.setReferencePath(referencePathStr);
            return this;
        }

        @Override
        public BasicParamBuilder reference(NodeParamPath referencePath) {
            this.definition.setReferencePath(referencePath);
            return this;
        }

        @Override
        public BasicParamBuilder makePrivate() {
            this.definition.setVisibility(ParamVisibility.PRIVATE);
            return this;
        }

        @Override
        public BasicParamBuilder makePublic() {
            this.definition.setVisibility(ParamVisibility.PUBLIC);
            return this;
        }

        @Override
        public BasicParamBuilder asInput() {
            this.definition.setDirection(ParamDirection.INPUT);
            return this;
        }

        @Override
        public BasicParamBuilder asOutput() {
            this.definition.setDirection(ParamDirection.OUTPUT);
            return this;
        }

        @Override
        public BasicParamBuilder asBoth() {
            this.definition.setDirection(ParamDirection.BOTH);
            return this;
        }

        @Override
        public BasicParamDefinition build() {
            return this.definition;
        }
    }

    public static interface ParamBuilder<T extends ParamBuilder<T, P>, P extends ParamDefinition> {
        public P getDefinition();

        public T description(String var1);

        public T required(boolean var1);

        public T direction(ParamDirection var1);

        public T visibility(ParamVisibility var1);

        public T constant(Object var1);

        public T reference(String var1);

        public T reference(NodeParamPath var1);

        public T makePrivate();

        public T makePublic();

        public T asInput();

        public T asOutput();

        public T asBoth();

        public P build();
    }
}

