/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.core.flow.param.helper.ParamValueHelper;
import kd.ai.gai.flow.flow.core.Execution;

public class ParamPathBuilder {
    public static PathBuilder from(String nodeId, String paramName) {
        return new PathBuilder(nodeId, paramName);
    }

    public static PathBuilder builder(String nodeId, String paramName) {
        return new PathBuilder(nodeId, paramName);
    }

    public static NodeParamPath parseReferenceString(String referenceString) {
        return ParamPathHelper.parseFullPath(referenceString);
    }

    public static void setReferencePath(ParamDefinition paramDef, String nodeId, String paramName, List<String> propertyPath) {
        NodeParamPath path = new NodeParamPath(nodeId, paramName, propertyPath);
        paramDef.setReferencePath(path);
    }

    public static String createReferenceString(String nodeId, String paramName, String ... propertySegments) {
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(propertySegments));
        return ParamPathHelper.generateFullPath(nodeId, paramName, segments);
    }

    public static class PathBuilder {
        private final String nodeId;
        private final String paramName;
        private final List<String> pathSegments = new ArrayList<String>();

        private PathBuilder(String nodeId, String paramName) {
            this.nodeId = nodeId;
            this.paramName = paramName;
        }

        public PathBuilder property(String propertyName) {
            this.pathSegments.add(propertyName);
            return this;
        }

        public PathBuilder index(int index) {
            this.pathSegments.add(String.valueOf(index));
            return this;
        }

        public PathBuilder allItems() {
            this.pathSegments.add("*");
            return this;
        }

        public PathBuilder allItemsProperty(String propertyName) {
            this.pathSegments.add("*." + propertyName);
            return this;
        }

        public NodeParamPath build() {
            return new NodeParamPath(this.nodeId, this.paramName, this.pathSegments);
        }

        public String buildReferenceString() {
            return ParamPathHelper.generateFullPath(this.nodeId, this.paramName, this.pathSegments);
        }

        public Object getValue(Execution execution) {
            NodeParamPath path = this.build();
            return ParamValueHelper.resolveValue((Object)execution, path);
        }
    }
}

