/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;

public class ParamValueBuilder {
    public static Builder forDefinition(ParamDefinition definition) {
        return new Builder(definition);
    }

    private static Object buildFromFlatData(ParamDefinition definition, Map<String, Object> flatData, String currentPath) {
        if (definition instanceof ObjectParamDefinition) {
            return ParamValueBuilder.buildObjectFromFlatData((ObjectParamDefinition)definition, flatData, currentPath);
        }
        if (definition instanceof ArrayParamDefinition) {
            return ParamValueBuilder.buildArrayFromFlatData((ArrayParamDefinition)definition, flatData, currentPath);
        }
        return flatData.get(currentPath);
    }

    private static Map<String, Object> buildObjectFromFlatData(ObjectParamDefinition definition, Map<String, Object> flatData, String currentPath) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ParamDefinition property : definition.getProperties()) {
            String propertyName = property.getName();
            String propertyPath = currentPath.isEmpty() ? propertyName : currentPath + "." + propertyName;
            Object propertyValue = ParamValueBuilder.buildFromFlatData(property, flatData, propertyPath);
            if (propertyValue == null && !property.isRequired()) continue;
            result.put(propertyName, propertyValue);
        }
        return result;
    }

    private static List<Object> buildArrayFromFlatData(ArrayParamDefinition definition, Map<String, Object> flatData, String currentPath) {
        ArrayList<Object> result = new ArrayList<Object>();
        ParamDefinition itemDef = definition.getItemDefinition();
        HashMap<Integer, Boolean> indexes = new HashMap<Integer, Boolean>();
        for (String key : flatData.keySet()) {
            int closeBracket;
            if (!key.startsWith(currentPath + "[") || (closeBracket = key.indexOf(93, currentPath.length() + 1)) <= 0) continue;
            String indexStr = key.substring(currentPath.length() + 1, closeBracket);
            try {
                int index = Integer.parseInt(indexStr);
                indexes.put(index, true);
            }
            catch (NumberFormatException index) {}
        }
        ArrayList sortedIndexes = new ArrayList(indexes.keySet());
        Collections.sort(sortedIndexes);
        Iterator iterator = sortedIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            String indexPath = currentPath + "[" + index + "]";
            Object itemValue = ParamValueBuilder.buildFromFlatData(itemDef, flatData, indexPath);
            if (itemValue == null) continue;
            result.add(itemValue);
        }
        return result;
    }

    public static class ArrayItemsBuilder {
        private final Builder builder;
        private final String arrayPath;

        private ArrayItemsBuilder(Builder builder, String arrayPath) {
            this.builder = builder;
            this.arrayPath = arrayPath;
        }

        public ArrayItemsBuilder item(Object value) {
            int index = this.builder.arrayIndexCounters.getOrDefault(this.arrayPath, 0);
            this.builder.arrayIndexCounters.put(this.arrayPath, index + 1);
            ArrayParamDefinition arrayDef = (ArrayParamDefinition)this.builder.context.definition;
            ParamDefinition itemDef = arrayDef.getItemDefinition();
            if (!(itemDef instanceof BasicParamDefinition) && !(itemDef instanceof MessageParamDefinition)) {
                throw new IllegalArgumentException("\u6570\u7ec4\u9879\u4e0d\u662f\u57fa\u672c\u7c7b\u578b\u6216\u6d88\u606f\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528object\u6216array\u65b9\u6cd5\u3002\u6570\u7ec4\u9879\u7c7b\u578b: " + new BuildContext("", itemDef).getDefinitionTypeName());
            }
            this.builder.flatData.put(this.arrayPath + "[" + index + "]", value);
            return this;
        }

        public ArrayItemsBuilder items(Iterable<?> values) {
            for (Object value : values) {
                this.item(value);
            }
            return this;
        }

        public ArrayItemsBuilder object(Consumer<Builder> objectBuilder) {
            int index = this.builder.arrayIndexCounters.getOrDefault(this.arrayPath, 0);
            this.builder.arrayIndexCounters.put(this.arrayPath, index + 1);
            ArrayParamDefinition arrayDef = (ArrayParamDefinition)this.builder.context.definition;
            ParamDefinition itemDef = arrayDef.getItemDefinition();
            if (!(itemDef instanceof ObjectParamDefinition)) {
                throw new IllegalArgumentException("\u6570\u7ec4\u9879\u4e0d\u662f\u5bf9\u8c61\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528item\u65b9\u6cd5\u3002\u6570\u7ec4\u9879\u7c7b\u578b: " + new BuildContext("", itemDef).getDefinitionTypeName());
            }
            BuildContext oldContext = this.builder.context;
            this.builder.context = oldContext.arrayItem(index, itemDef);
            objectBuilder.accept(this.builder);
            this.builder.context = oldContext;
            return this;
        }

        public ArrayItemsBuilder array(Consumer<ArrayItemsBuilder> arrayItemBuilder) {
            int index = this.builder.arrayIndexCounters.getOrDefault(this.arrayPath, 0);
            this.builder.arrayIndexCounters.put(this.arrayPath, index + 1);
            ArrayParamDefinition arrayDef = (ArrayParamDefinition)this.builder.context.definition;
            ParamDefinition itemDef = arrayDef.getItemDefinition();
            if (!(itemDef instanceof ArrayParamDefinition)) {
                throw new IllegalArgumentException("\u6570\u7ec4\u9879\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u9002\u5f53\u7684\u65b9\u6cd5\u3002\u6570\u7ec4\u9879\u7c7b\u578b: " + new BuildContext("", itemDef).getDefinitionTypeName());
            }
            BuildContext oldContext = this.builder.context;
            this.builder.context = oldContext.arrayItem(index, itemDef);
            String nestedArrayPath = this.builder.context.path;
            this.builder.arrayIndexCounters.put(nestedArrayPath, 0);
            ArrayItemsBuilder nestedBuilder = new ArrayItemsBuilder(this.builder, nestedArrayPath);
            arrayItemBuilder.accept(nestedBuilder);
            this.builder.arrayIndexCounters.remove(nestedArrayPath);
            this.builder.context = oldContext;
            return this;
        }
    }

    public static class Builder {
        private final ParamDefinition rootDefinition;
        private final Map<String, Object> flatData = new HashMap<String, Object>();
        private BuildContext context;
        private final Map<String, Integer> arrayIndexCounters = new HashMap<String, Integer>();

        private Builder(ParamDefinition definition) {
            this.rootDefinition = definition;
            this.context = BuildContext.root(definition);
        }

        public Builder setValue(Object value) {
            if (!this.context.isValueType()) {
                throw new IllegalArgumentException("\u5f53\u524d\u4e0a\u4e0b\u6587\u4e0d\u662f\u57fa\u672c\u7c7b\u578b\u6216\u6d88\u606f\u7c7b\u578b\uff0c\u65e0\u6cd5\u76f4\u63a5\u8bbe\u7f6e\u503c\u3002\u5f53\u524d\u7c7b\u578b: " + this.context.getDefinitionTypeName() + "\uff0c\u8def\u5f84: " + this.context.path);
            }
            this.flatData.put(this.context.path, value);
            return this;
        }

        public Builder setValue(String fieldName, Object value) {
            ParamDefinition fieldDef = this.getFieldDefinition(fieldName);
            if (!new BuildContext("", fieldDef).isValueType()) {
                throw new IllegalArgumentException("\u5b57\u6bb5 '" + fieldName + "' \u4e0d\u662f\u57fa\u672c\u7c7b\u578b\u6216\u6d88\u606f\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528object\u6216array\u65b9\u6cd5\u3002\u5b57\u6bb5\u7c7b\u578b: " + new BuildContext("", fieldDef).getDefinitionTypeName());
            }
            String fieldPath = this.context.path.isEmpty() ? fieldName : this.context.path + "." + fieldName;
            this.flatData.put(fieldPath, value);
            return this;
        }

        public Builder object(String fieldName, Consumer<Builder> objectBuilder) {
            ParamDefinition fieldDef = this.getFieldDefinition(fieldName);
            if (!(fieldDef instanceof ObjectParamDefinition)) {
                throw new IllegalArgumentException("\u5b57\u6bb5 '" + fieldName + "' \u4e0d\u662f\u5bf9\u8c61\u7c7b\u578b\u3002\u5b57\u6bb5\u7c7b\u578b: " + new BuildContext("", fieldDef).getDefinitionTypeName());
            }
            BuildContext oldContext = this.context;
            this.context = oldContext.field(fieldName, fieldDef);
            objectBuilder.accept(this);
            this.context = oldContext;
            return this;
        }

        public Builder array(String fieldName, Consumer<ArrayItemsBuilder> arrayBuilder) {
            ParamDefinition fieldDef = this.getFieldDefinition(fieldName);
            if (!(fieldDef instanceof ArrayParamDefinition)) {
                throw new IllegalArgumentException("\u5b57\u6bb5 '" + fieldName + "' \u4e0d\u662f\u6570\u7ec4\u7c7b\u578b\u3002\u5b57\u6bb5\u7c7b\u578b: " + new BuildContext("", fieldDef).getDefinitionTypeName());
            }
            BuildContext oldContext = this.context;
            this.context = oldContext.field(fieldName, fieldDef);
            String arrayPath = this.context.path;
            this.arrayIndexCounters.put(arrayPath, 0);
            ArrayItemsBuilder itemsBuilder = new ArrayItemsBuilder(this, arrayPath);
            arrayBuilder.accept(itemsBuilder);
            this.arrayIndexCounters.remove(arrayPath);
            this.context = oldContext;
            return this;
        }

        public Builder array(Consumer<ArrayItemsBuilder> arrayBuilder) {
            if (!(this.rootDefinition instanceof ArrayParamDefinition)) {
                throw new IllegalArgumentException("\u6839\u53c2\u6570\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u65b9\u6cd5\u3002\u6839\u53c2\u6570\u7c7b\u578b: " + BuildContext.root(this.rootDefinition).getDefinitionTypeName());
            }
            String arrayPath = "";
            this.arrayIndexCounters.put(arrayPath, 0);
            ArrayItemsBuilder itemsBuilder = new ArrayItemsBuilder(this, arrayPath);
            arrayBuilder.accept(itemsBuilder);
            this.arrayIndexCounters.remove(arrayPath);
            return this;
        }

        public Object build() {
            Object result = ParamValueBuilder.buildFromFlatData(this.rootDefinition, this.flatData, "");
            return this.rootDefinition.narrow(result);
        }

        private ParamDefinition getFieldDefinition(String fieldName) {
            if (this.context.definition instanceof ObjectParamDefinition) {
                ObjectParamDefinition objDef = (ObjectParamDefinition)this.context.definition;
                ParamDefinition fieldDef = objDef.getProperty(fieldName);
                if (fieldDef == null) {
                    throw new IllegalArgumentException("\u5728\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230\u5b57\u6bb5: '" + fieldName + "'");
                }
                return fieldDef;
            }
            if (this.context.definition instanceof ArrayParamDefinition) {
                throw new IllegalArgumentException("\u5f53\u524d\u4e0a\u4e0b\u6587\u662f\u6570\u7ec4\u7c7b\u578b (" + this.context.path + ")\uff0c\u4e0d\u80fd\u76f4\u63a5\u8bbe\u7f6e\u5b57\u6bb5\u3002\u5982\u679c\u8981\u64cd\u4f5c\u6570\u7ec4\u9879\uff0c\u8bf7\u4f7f\u7528\u5bf9\u5e94\u7684\u6570\u7ec4\u65b9\u6cd5\u3002\u5982\u679c\u5f53\u524d\u662f\u6839\u7ea7\u6570\u7ec4\uff0c\u8bf7\u4f7f\u7528\u65e0\u53c2\u6570\u7684 array() \u65b9\u6cd5\u3002");
            }
            if (this.context.isValueType()) {
                throw new IllegalArgumentException("\u5f53\u524d\u4e0a\u4e0b\u6587\u662f\u57fa\u672c\u7c7b\u578b\u6216\u6d88\u606f\u7c7b\u578b (" + this.context.getDefinitionTypeName() + ")\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5b57\u6bb5 '" + fieldName + "'\u3002\u8bf7\u76f4\u63a5\u4f7f\u7528 setValue() \u65b9\u6cd5\u3002");
            }
            throw new IllegalArgumentException("\u5f53\u524d\u4e0a\u4e0b\u6587\u7c7b\u578b (" + this.context.getDefinitionTypeName() + ") \u4e0d\u652f\u6301\u8bbe\u7f6e\u5b57\u6bb5\u3002");
        }
    }

    private static class BuildContext {
        private final String path;
        private final ParamDefinition definition;

        private BuildContext(String path, ParamDefinition definition) {
            this.path = path;
            this.definition = definition;
        }

        static BuildContext root(ParamDefinition definition) {
            return new BuildContext("", definition);
        }

        BuildContext field(String fieldName, ParamDefinition fieldDef) {
            String newPath = this.path.isEmpty() ? fieldName : this.path + "." + fieldName;
            return new BuildContext(newPath, fieldDef);
        }

        BuildContext arrayItem(int index, ParamDefinition itemDef) {
            String newPath = this.path + "[" + index + "]";
            return new BuildContext(newPath, itemDef);
        }

        String getDefinitionTypeName() {
            if (this.definition instanceof BasicParamDefinition) {
                return "\u57fa\u672c\u7c7b\u578b(" + (Object)((Object)this.definition.getType()) + ")";
            }
            if (this.definition instanceof ObjectParamDefinition) {
                return "\u5bf9\u8c61\u7c7b\u578b";
            }
            if (this.definition instanceof ArrayParamDefinition) {
                return "\u6570\u7ec4\u7c7b\u578b";
            }
            return this.definition.getClass().getSimpleName();
        }

        boolean isValueType() {
            return this.definition instanceof BasicParamDefinition;
        }
    }
}

