/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.converter;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.converter.annotation.ParamDefinitionAnnotations;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;

class AnnotatedJavaBeanToParamDefinitionConverter {
    AnnotatedJavaBeanToParamDefinitionConverter() {
    }

    public static ParamDefinition fromClass(Class<?> beanClass, String paramName) {
        return AnnotatedJavaBeanToParamDefinitionConverter.fromClass(beanClass, paramName, new ConversionContext());
    }

    private static ParamDefinition fromClass(Class<?> beanClass, String paramName, ConversionContext context) {
        if (context.isProcessed(beanClass)) {
            return ParamDefinitionBuilder.object(paramName).build();
        }
        String cacheKey = beanClass.getName() + "#" + paramName;
        ParamDefinition cachedDefinition = context.getFromCache(cacheKey);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        context.addProcessedClass(beanClass);
        ParamDefinitionAnnotations.Description classDescAnno = beanClass.getAnnotation(ParamDefinitionAnnotations.Description.class);
        ParamDefinitionAnnotations.Direction classDirectionAnno = beanClass.getAnnotation(ParamDefinitionAnnotations.Direction.class);
        ParamDefinitionAnnotations.Visibility classVisibilityAnno = beanClass.getAnnotation(ParamDefinitionAnnotations.Visibility.class);
        if (AnnotatedJavaBeanToParamDefinitionConverter.isBasicType(beanClass)) {
            BasicParamDefinition basicDef = AnnotatedJavaBeanToParamDefinitionConverter.createBasicParamDefinition(beanClass, paramName);
            AnnotatedJavaBeanToParamDefinitionConverter.applyClassLevelAnnotations(basicDef, classDescAnno, classDirectionAnno, classVisibilityAnno);
            context.putToCache(cacheKey, basicDef);
            return basicDef;
        }
        if (Collection.class.isAssignableFrom(beanClass)) {
            ArrayParamDefinition arrayDef = ParamDefinitionBuilder.stringArray(paramName).build();
            AnnotatedJavaBeanToParamDefinitionConverter.applyClassLevelAnnotations(arrayDef, classDescAnno, classDirectionAnno, classVisibilityAnno);
            context.putToCache(cacheKey, arrayDef);
            return arrayDef;
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            ObjectParamDefinition objDef = ParamDefinitionBuilder.object(paramName).build();
            AnnotatedJavaBeanToParamDefinitionConverter.applyClassLevelAnnotations(objDef, classDescAnno, classDirectionAnno, classVisibilityAnno);
            context.putToCache(cacheKey, objDef);
            return objDef;
        }
        ParamDefinitionBuilder.ObjectParamBuilder builder = ParamDefinitionBuilder.object(paramName);
        if (classDescAnno != null) {
            builder.description(classDescAnno.value());
        }
        if (classDirectionAnno != null) {
            switch (classDirectionAnno.value()) {
                case INPUT: {
                    builder.asInput();
                    break;
                }
                case OUTPUT: {
                    builder.asOutput();
                    break;
                }
                case BOTH: {
                    builder.asBoth();
                }
            }
        }
        if (classVisibilityAnno != null) {
            switch (classVisibilityAnno.value()) {
                case PUBLIC: {
                    builder.makePublic();
                    break;
                }
                case PRIVATE: {
                    builder.makePrivate();
                }
            }
        }
        ObjectParamDefinition objDef = builder.build();
        context.putToCache(cacheKey, objDef);
        List<PropertyDescriptor> properties = AnnotatedJavaBeanToParamDefinitionConverter.getClassProperties(beanClass);
        for (PropertyDescriptor property : properties) {
            ParamDefinition propDef = AnnotatedJavaBeanToParamDefinitionConverter.processAnnotatedProperty(beanClass, property, context);
            if (propDef == null) continue;
            objDef.addProperty(propDef);
        }
        return objDef;
    }

    private static void applyClassLevelAnnotations(ParamDefinition def, ParamDefinitionAnnotations.Description descAnno, ParamDefinitionAnnotations.Direction directionAnno, ParamDefinitionAnnotations.Visibility visibilityAnno) {
        if (descAnno != null) {
            def.setDescription(descAnno.value());
        }
        if (directionAnno != null) {
            switch (directionAnno.value()) {
                case INPUT: {
                    def.setDirection(ParamDirection.INPUT);
                    break;
                }
                case OUTPUT: {
                    def.setDirection(ParamDirection.OUTPUT);
                    break;
                }
                case BOTH: {
                    def.setDirection(ParamDirection.BOTH);
                }
            }
        }
        if (visibilityAnno != null) {
            switch (visibilityAnno.value()) {
                case PUBLIC: {
                    def.setVisibility(ParamVisibility.PUBLIC);
                    break;
                }
                case PRIVATE: {
                    def.setVisibility(ParamVisibility.PRIVATE);
                }
            }
        }
    }

    private static ParamDefinition processAnnotatedProperty(Class<?> beanClass, PropertyDescriptor property, ConversionContext context) {
        Method readMethod = property.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        String propName = property.getName();
        Class<?> propType = property.getPropertyType();
        Field field = AnnotatedJavaBeanToParamDefinitionConverter.findField(beanClass, propName);
        if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.Ignore.class) || readMethod.isAnnotationPresent(ParamDefinitionAnnotations.Ignore.class)) {
            return null;
        }
        if (field != null && (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()))) {
            return null;
        }
        ParamDefinitionAnnotations.ParamName paramNameAnno = null;
        if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.ParamName.class)) {
            paramNameAnno = field.getAnnotation(ParamDefinitionAnnotations.ParamName.class);
        } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.ParamName.class)) {
            paramNameAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.ParamName.class);
        }
        String finalPropName = paramNameAnno != null ? paramNameAnno.value() : propName;
        ParamDefinition propDef = null;
        propDef = AnnotatedJavaBeanToParamDefinitionConverter.isBasicType(propType) ? AnnotatedJavaBeanToParamDefinitionConverter.createBasicParamDefinition(propType, finalPropName) : (Collection.class.isAssignableFrom(propType) ? AnnotatedJavaBeanToParamDefinitionConverter.processAnnotatedCollectionProperty(readMethod, finalPropName, field, context) : (propType.isArray() ? AnnotatedJavaBeanToParamDefinitionConverter.processAnnotatedArrayProperty(propType.getComponentType(), finalPropName, field, context) : (Map.class.isAssignableFrom(propType) ? ParamDefinitionBuilder.object(finalPropName).build() : AnnotatedJavaBeanToParamDefinitionConverter.fromClass(propType, finalPropName, context))));
        if (propDef != null) {
            ParamDefinitionAnnotations.Description descAnno = null;
            if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.Description.class)) {
                descAnno = field.getAnnotation(ParamDefinitionAnnotations.Description.class);
            } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.Description.class)) {
                descAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.Description.class);
            }
            if (descAnno != null) {
                propDef.setDescription(descAnno.value());
            }
            ParamDefinitionAnnotations.Required requiredAnno = null;
            if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.Required.class)) {
                requiredAnno = field.getAnnotation(ParamDefinitionAnnotations.Required.class);
            } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.Required.class)) {
                requiredAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.Required.class);
            }
            if (requiredAnno != null) {
                propDef.setRequired(requiredAnno.value());
            }
            ParamDefinitionAnnotations.Direction directionAnno = null;
            if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.Direction.class)) {
                directionAnno = field.getAnnotation(ParamDefinitionAnnotations.Direction.class);
            } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.Direction.class)) {
                directionAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.Direction.class);
            }
            if (directionAnno != null) {
                switch (directionAnno.value()) {
                    case INPUT: {
                        propDef.setDirection(ParamDirection.INPUT);
                        break;
                    }
                    case OUTPUT: {
                        propDef.setDirection(ParamDirection.OUTPUT);
                        break;
                    }
                    case BOTH: {
                        propDef.setDirection(ParamDirection.BOTH);
                    }
                }
            }
            ParamDefinitionAnnotations.Visibility visibilityAnno = null;
            if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.Visibility.class)) {
                visibilityAnno = field.getAnnotation(ParamDefinitionAnnotations.Visibility.class);
            } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.Visibility.class)) {
                visibilityAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.Visibility.class);
            }
            if (visibilityAnno != null) {
                switch (visibilityAnno.value()) {
                    case PUBLIC: {
                        propDef.setVisibility(ParamVisibility.PUBLIC);
                        break;
                    }
                    case PRIVATE: {
                        propDef.setVisibility(ParamVisibility.PRIVATE);
                    }
                }
            }
            ParamDefinitionAnnotations.DefaultValue defaultValueAnno = null;
            if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.DefaultValue.class)) {
                defaultValueAnno = field.getAnnotation(ParamDefinitionAnnotations.DefaultValue.class);
            } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.DefaultValue.class)) {
                defaultValueAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.DefaultValue.class);
            }
            if (defaultValueAnno != null && propDef instanceof BasicParamDefinition) {
                AnnotatedJavaBeanToParamDefinitionConverter.applyDefaultValue((BasicParamDefinition)propDef, defaultValueAnno);
            }
        }
        return propDef;
    }

    private static void applyDefaultValue(BasicParamDefinition def, ParamDefinitionAnnotations.DefaultValue anno) {
        switch (def.getType()) {
            case STRING: {
                if (anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.AUTO && anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.STRING) break;
                def.setStringValue(anno.strValue());
                break;
            }
            case INTEGER: {
                if (anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.AUTO && anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.INTEGER) break;
                def.setIntegerValue((int)anno.intValue());
                break;
            }
            case FLOAT: {
                if (anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.AUTO && anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.FLOAT) break;
                def.setFloatValue(Float.valueOf((float)anno.floatValue()));
                break;
            }
            case BOOLEAN: {
                if (anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.AUTO && anno.useType() != ParamDefinitionAnnotations.DefaultValue.ValueType.BOOLEAN) break;
                def.setBooleanValue(anno.boolValue());
                break;
            }
        }
    }

    private static ParamDefinition processAnnotatedCollectionProperty(Method readMethod, String propName, Field field, ConversionContext context) {
        Class itemClass = Object.class;
        try {
            ParameterizedType paramType;
            Type[] typeArgs;
            Type returnType = readMethod.getGenericReturnType();
            if (returnType instanceof ParameterizedType && (typeArgs = (paramType = (ParameterizedType)returnType).getActualTypeArguments()).length > 0 && typeArgs[0] instanceof Class) {
                itemClass = (Class)typeArgs[0];
            }
        }
        catch (Exception returnType) {
            // empty catch block
        }
        ParamDefinitionAnnotations.ArrayItem arrayItemAnno = null;
        if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.ArrayItem.class)) {
            arrayItemAnno = field.getAnnotation(ParamDefinitionAnnotations.ArrayItem.class);
        } else if (readMethod.isAnnotationPresent(ParamDefinitionAnnotations.ArrayItem.class)) {
            arrayItemAnno = readMethod.getAnnotation(ParamDefinitionAnnotations.ArrayItem.class);
        }
        return AnnotatedJavaBeanToParamDefinitionConverter.processAnnotatedArrayProperty(itemClass, propName, arrayItemAnno, context);
    }

    private static ParamDefinition processAnnotatedArrayProperty(Class<?> itemClass, String propName, Field field, ConversionContext context) {
        ParamDefinitionAnnotations.ArrayItem arrayItemAnno = null;
        if (field != null && field.isAnnotationPresent(ParamDefinitionAnnotations.ArrayItem.class)) {
            arrayItemAnno = field.getAnnotation(ParamDefinitionAnnotations.ArrayItem.class);
        }
        return AnnotatedJavaBeanToParamDefinitionConverter.processAnnotatedArrayProperty(itemClass, propName, arrayItemAnno, context);
    }

    private static ParamDefinition processAnnotatedArrayProperty(Class<?> itemClass, String propName, ParamDefinitionAnnotations.ArrayItem arrayItemAnno, ConversionContext context) {
        if (AnnotatedJavaBeanToParamDefinitionConverter.isBasicType(itemClass)) {
            ParamDefinitionBuilder.ArrayParamBuilder builder;
            switch (AnnotatedJavaBeanToParamDefinitionConverter.getParamTypeForClass(itemClass)) {
                case STRING: {
                    builder = ParamDefinitionBuilder.stringArray(propName);
                    break;
                }
                case INTEGER: {
                    builder = ParamDefinitionBuilder.integerArray(propName);
                    break;
                }
                case FLOAT: {
                    builder = ParamDefinitionBuilder.floatArray(propName);
                    break;
                }
                case BOOLEAN: {
                    builder = ParamDefinitionBuilder.booleanArray(propName);
                    break;
                }
                case DATE: {
                    builder = ParamDefinitionBuilder.dateArray(propName);
                    break;
                }
                default: {
                    builder = ParamDefinitionBuilder.stringArray(propName);
                }
            }
            if (arrayItemAnno != null) {
                ArrayParamDefinition arrayDef = builder.build();
                ParamDefinition itemDef = arrayDef.getItemDefinition();
                if (!arrayItemAnno.description().isEmpty()) {
                    itemDef.setDescription(arrayItemAnno.description());
                }
                itemDef.setRequired(arrayItemAnno.required());
                return arrayDef;
            }
            return builder.build();
        }
        ParamDefinition itemDef = AnnotatedJavaBeanToParamDefinitionConverter.fromClass(itemClass, "item", context);
        if (arrayItemAnno != null) {
            if (!arrayItemAnno.description().isEmpty()) {
                itemDef.setDescription(arrayItemAnno.description());
            }
            itemDef.setRequired(arrayItemAnno.required());
        }
        return ParamDefinitionBuilder.array(propName, itemDef).build();
    }

    private static List<PropertyDescriptor> getClassProperties(Class<?> beanClass) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                if ("class".equals(descriptor.getName())) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting properties for class " + beanClass.getName() + ": " + e.getMessage());
        }
        return properties;
    }

    private static boolean isBasicType(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || String.class.equals(type) || Boolean.class.equals(type) || Character.class.equals(type) || Date.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type);
    }

    private static BasicParamDefinition createBasicParamDefinition(Class<?> type, String name) {
        ParamType paramType = AnnotatedJavaBeanToParamDefinitionConverter.getParamTypeForClass(type);
        return new BasicParamDefinition(name, paramType);
    }

    private static ParamType getParamTypeForClass(Class<?> type) {
        if (String.class.equals(type) || Enum.class.isAssignableFrom(type) || Character.class.equals(type) || Character.TYPE.equals(type)) {
            return ParamType.STRING;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return ParamType.BOOLEAN;
        }
        if (Date.class.isAssignableFrom(type)) {
            return ParamType.DATE;
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type) || Double.class.equals(type) || Double.TYPE.equals(type) || BigDecimal.class.equals(type)) {
            return ParamType.FLOAT;
        }
        if (Number.class.isAssignableFrom(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Short.TYPE.equals(type) || Byte.TYPE.equals(type)) {
            return ParamType.INTEGER;
        }
        return ParamType.STRING;
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        for (Class<?> searchType = clazz; searchType != null && !Object.class.equals(searchType); searchType = searchType.getSuperclass()) {
            try {
                return searchType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static class ConversionContext {
        private final Set<Class<?>> processedClasses = new HashSet();
        private final Map<String, ParamDefinition> typeCache = new HashMap<String, ParamDefinition>();

        private ConversionContext() {
        }

        public void addProcessedClass(Class<?> clazz) {
            this.processedClasses.add(clazz);
        }

        public boolean isProcessed(Class<?> clazz) {
            return this.processedClasses.contains(clazz);
        }

        public ParamDefinition getFromCache(String cacheKey) {
            return this.typeCache.get(cacheKey);
        }

        public void putToCache(String cacheKey, ParamDefinition definition) {
            this.typeCache.put(cacheKey, definition);
        }
    }
}

