/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.converter;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;

class JavaBeanToParamDefinitionConverter {
    JavaBeanToParamDefinitionConverter() {
    }

    public static ParamDefinition fromClass(Class<?> beanClass, String paramName) {
        return JavaBeanToParamDefinitionConverter.fromClass(beanClass, paramName, new ConversionContext());
    }

    private static ParamDefinition fromClass(Class<?> beanClass, String paramName, ConversionContext context) {
        if (context.isProcessed(beanClass)) {
            return ParamDefinitionBuilder.object(paramName).build();
        }
        String cacheKey = beanClass.getName() + "#" + paramName;
        ParamDefinition cachedDefinition = context.getFromCache(cacheKey);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        context.addProcessedClass(beanClass);
        if (JavaBeanToParamDefinitionConverter.isBasicType(beanClass)) {
            BasicParamDefinition basicDef = JavaBeanToParamDefinitionConverter.createBasicParamDefinition(beanClass, paramName);
            context.putToCache(cacheKey, basicDef);
            return basicDef;
        }
        if (Collection.class.isAssignableFrom(beanClass)) {
            ArrayParamDefinition arrayDef = ParamDefinitionBuilder.stringArray(paramName).build();
            context.putToCache(cacheKey, arrayDef);
            return arrayDef;
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            ObjectParamDefinition objDef = ParamDefinitionBuilder.object(paramName).build();
            context.putToCache(cacheKey, objDef);
            return objDef;
        }
        ObjectParamDefinition objDef = ParamDefinitionBuilder.object(paramName).build();
        context.putToCache(cacheKey, objDef);
        List<PropertyDescriptor> properties = JavaBeanToParamDefinitionConverter.getClassProperties(beanClass);
        for (PropertyDescriptor property : properties) {
            ParamDefinition propDef = JavaBeanToParamDefinitionConverter.processProperty(property, context);
            if (propDef == null) continue;
            objDef.addProperty(propDef);
        }
        return objDef;
    }

    private static ParamDefinition processProperty(PropertyDescriptor property, ConversionContext context) {
        Method readMethod = property.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        String propName = property.getName();
        Class<?> propType = property.getPropertyType();
        try {
            Field field = JavaBeanToParamDefinitionConverter.findField(readMethod.getDeclaringClass(), propName);
            if (field != null && (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()))) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (JavaBeanToParamDefinitionConverter.isBasicType(propType)) {
            return JavaBeanToParamDefinitionConverter.createBasicParamDefinition(propType, propName);
        }
        if (Collection.class.isAssignableFrom(propType)) {
            return JavaBeanToParamDefinitionConverter.processCollectionProperty(readMethod, propName, context);
        }
        if (propType.isArray()) {
            return JavaBeanToParamDefinitionConverter.processArrayProperty(propType.getComponentType(), propName, context);
        }
        if (Map.class.isAssignableFrom(propType)) {
            return ParamDefinitionBuilder.object(propName).build();
        }
        return JavaBeanToParamDefinitionConverter.fromClass(propType, propName, context);
    }

    private static ParamDefinition processCollectionProperty(Method readMethod, String propName, ConversionContext context) {
        Class itemClass = Object.class;
        try {
            ParameterizedType paramType;
            Type[] typeArgs;
            Type returnType = readMethod.getGenericReturnType();
            if (returnType instanceof ParameterizedType && (typeArgs = (paramType = (ParameterizedType)returnType).getActualTypeArguments()).length > 0 && typeArgs[0] instanceof Class) {
                itemClass = (Class)typeArgs[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JavaBeanToParamDefinitionConverter.processArrayProperty(itemClass, propName, context);
    }

    private static ParamDefinition processArrayProperty(Class<?> itemClass, String propName, ConversionContext context) {
        if (JavaBeanToParamDefinitionConverter.isBasicType(itemClass)) {
            switch (JavaBeanToParamDefinitionConverter.getParamTypeForClass(itemClass)) {
                case STRING: {
                    return ParamDefinitionBuilder.stringArray(propName).build();
                }
                case INTEGER: {
                    return ParamDefinitionBuilder.integerArray(propName).build();
                }
                case FLOAT: {
                    return ParamDefinitionBuilder.floatArray(propName).build();
                }
                case BOOLEAN: {
                    return ParamDefinitionBuilder.booleanArray(propName).build();
                }
                case DATE: {
                    return ParamDefinitionBuilder.dateArray(propName).build();
                }
            }
            return ParamDefinitionBuilder.stringArray(propName).build();
        }
        ParamDefinition itemDef = JavaBeanToParamDefinitionConverter.fromClass(itemClass, "item", context);
        return ParamDefinitionBuilder.array(propName, itemDef).build();
    }

    private static List<PropertyDescriptor> getClassProperties(Class<?> beanClass) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                if ("class".equals(descriptor.getName())) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting properties for class " + beanClass.getName() + ": " + e.getMessage());
        }
        return properties;
    }

    private static boolean isBasicType(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || String.class.equals(type) || Boolean.class.equals(type) || Character.class.equals(type) || Date.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type);
    }

    private static BasicParamDefinition createBasicParamDefinition(Class<?> type, String name) {
        ParamType paramType = JavaBeanToParamDefinitionConverter.getParamTypeForClass(type);
        return new BasicParamDefinition(name, paramType);
    }

    private static ParamType getParamTypeForClass(Class<?> type) {
        if (String.class.equals(type) || Enum.class.isAssignableFrom(type) || Character.class.equals(type) || Character.TYPE.equals(type)) {
            return ParamType.STRING;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return ParamType.BOOLEAN;
        }
        if (Date.class.isAssignableFrom(type)) {
            return ParamType.DATE;
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type) || Double.class.equals(type) || Double.TYPE.equals(type) || BigDecimal.class.equals(type)) {
            return ParamType.FLOAT;
        }
        if (Number.class.isAssignableFrom(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Short.TYPE.equals(type) || Byte.TYPE.equals(type)) {
            return ParamType.INTEGER;
        }
        return ParamType.STRING;
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        for (Class<?> searchType = clazz; searchType != null && !Object.class.equals(searchType); searchType = searchType.getSuperclass()) {
            try {
                return searchType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static ParamDefinition fromClassWithAnnotations(Class<?> beanClass, String paramName) {
        return JavaBeanToParamDefinitionConverter.fromClass(beanClass, paramName);
    }

    private static class ConversionContext {
        private final Set<Class<?>> processedClasses = new HashSet();
        private final Map<String, ParamDefinition> typeCache = new HashMap<String, ParamDefinition>();

        private ConversionContext() {
        }

        public void addProcessedClass(Class<?> clazz) {
            this.processedClasses.add(clazz);
        }

        public boolean isProcessed(Class<?> clazz) {
            return this.processedClasses.contains(clazz);
        }

        public ParamDefinition getFromCache(String cacheKey) {
            return this.typeCache.get(cacheKey);
        }

        public void putToCache(String cacheKey, ParamDefinition definition) {
            this.typeCache.put(cacheKey, definition);
        }
    }
}

