/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.bos.dataentity.resource.ResManager;

public class JsonSchemaToParamDefinitionConverter {
    public static ParamDefinition fromJsonSchema(String jsonSchemaStr, String paramName) {
        if (jsonSchemaStr == null || jsonSchemaStr.trim().isEmpty()) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"JsonSchema\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", (String)"JsonSchemaToParamDefinitionConverter_15095670", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        try {
            JSONObject schema = JSON.parseObject((String)jsonSchemaStr);
            return JsonSchemaToParamDefinitionConverter.fromJsonSchema(schema, paramName);
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u89e3\u6790JsonSchema\u5931\u8d25: ", (String)"JsonSchemaToParamDefinitionConverter_15095671", (String)"ai-gai-core", (Object[])new Object[0]) + e.getMessage(), e);
        }
    }

    public static ParamDefinition fromJsonSchema(JSONObject schema, String paramName) {
        if (schema == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"JsonSchema\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"JsonSchemaToParamDefinitionConverter_15095672", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        ConversionContext context = new ConversionContext(schema);
        ParamDefinition paramDefinition = JsonSchemaToParamDefinitionConverter.convertSchema(schema, paramName, context, "");
        return paramDefinition;
    }

    private static ParamDefinition convertSchema(JSONObject schema, String paramName, ConversionContext context, String currentPath) {
        if (schema == null) {
            return ParamDefinitionBuilder.string(paramName).build();
        }
        if (context.isProcessed(currentPath)) {
            return ParamDefinitionBuilder.object(paramName).build();
        }
        if (schema.containsKey((Object)"$ref")) {
            return JsonSchemaToParamDefinitionConverter.resolveReference(schema.getString("$ref"), paramName, context);
        }
        String cacheKey = currentPath + "#" + paramName;
        ParamDefinition cached = context.getFromCache(cacheKey);
        if (cached != null) {
            return cached;
        }
        context.addProcessedPath(currentPath);
        String type = schema.getString("type");
        String description = schema.getString("description") == null ? schema.getString("desc") : schema.getString("description");
        Object defaultValue = schema.get((Object)"default");
        String format = schema.getString("format");
        ParamDefinition result = null;
        result = "object".equals(type.toLowerCase()) ? JsonSchemaToParamDefinitionConverter.convertObjectSchema(schema, paramName, context, currentPath) : ("array".equals(type.toLowerCase()) || type.toLowerCase().contains("array") ? JsonSchemaToParamDefinitionConverter.convertArraySchema(schema, paramName, context, currentPath) : JsonSchemaToParamDefinitionConverter.convertPrimitiveSchema(type, format, paramName));
        if (result != null) {
            if (description != null && !description.trim().isEmpty()) {
                result.setDescription(description);
            }
            if (defaultValue != null && result instanceof BasicParamDefinition) {
                try {
                    result.setConstantValue(JsonSchemaToParamDefinitionConverter.convertDefaultValue(defaultValue, result));
                }
                catch (Exception e) {
                    System.err.println(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u5931\u8d25: ", (String)"JsonSchemaToParamDefinitionConverter_15095673", (String)"ai-gai-core", (Object[])new Object[0]) + e.getMessage());
                }
            }
        }
        context.putToCache(cacheKey, result);
        return result;
    }

    private static ParamDefinition convertObjectSchema(JSONObject schema, String paramName, ConversionContext context, String currentPath) {
        ParamDefinitionBuilder.ObjectParamBuilder builder = ParamDefinitionBuilder.object(paramName);
        JSONObject properties = schema.getJSONObject("properties");
        if (properties != null) {
            JSONArray requiredArray = schema.getJSONArray("required");
            HashSet<String> requiredFields = new HashSet<String>();
            if (requiredArray != null) {
                for (int i = 0; i < requiredArray.size(); ++i) {
                    requiredFields.add(requiredArray.getString(i));
                }
            }
            for (String propName : properties.keySet()) {
                String propPath;
                ParamDefinition propDef;
                JSONObject propSchema = properties.getJSONObject(propName);
                if (propSchema == null || (propDef = JsonSchemaToParamDefinitionConverter.convertSchema(propSchema, propName, context, propPath = currentPath.isEmpty() ? propName : currentPath + "." + propName)) == null) continue;
                if (requiredFields.contains(propName)) {
                    propDef.setRequired(true);
                }
                builder.property(propDef);
            }
        }
        return builder.build();
    }

    private static ParamDefinition convertArraySchema(JSONObject schema, String paramName, ConversionContext context, String currentPath) {
        Object itemsObj = schema.get((Object)"items");
        ParamDefinition itemDef = null;
        if (itemsObj instanceof JSONObject) {
            JSONObject itemSchema = (JSONObject)itemsObj;
            String itemPath = currentPath + "[*]";
            itemDef = JsonSchemaToParamDefinitionConverter.convertSchema(itemSchema, "item", context, itemPath);
        } else {
            itemDef = itemsObj instanceof JSONArray ? ParamDefinitionBuilder.object("item").build() : ParamDefinitionBuilder.string("item").build();
        }
        return ParamDefinitionBuilder.array(paramName, itemDef).build();
    }

    private static ParamDefinition convertPrimitiveSchema(String type, String format, String paramName) {
        if (type == null || type.isEmpty()) {
            return ParamDefinitionBuilder.string(paramName).build();
        }
        switch (type.toLowerCase()) {
            case "string": {
                if ("date-time".equals(format) || "date".equals(format) || "time".equals(format)) {
                    return ParamDefinitionBuilder.date(paramName).build();
                }
                return ParamDefinitionBuilder.string(paramName).build();
            }
            case "integer": 
            case "int": {
                return ParamDefinitionBuilder.integer(paramName).build();
            }
            case "number": {
                return ParamDefinitionBuilder.ffloat(paramName).build();
            }
            case "boolean": {
                return ParamDefinitionBuilder.bool(paramName).build();
            }
            case "null": {
                return ParamDefinitionBuilder.string(paramName).build();
            }
        }
        return ParamDefinitionBuilder.string(paramName).build();
    }

    private static ParamDefinition resolveReference(String ref, String paramName, ConversionContext context) {
        if (ref == null || !ref.startsWith("#/")) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684$ref\u683c\u5f0f: ", (String)"JsonSchemaToParamDefinitionConverter_15095674", (String)"ai-gai-core", (Object[])new Object[0]) + ref);
        }
        String[] pathParts = ref.substring(2).split("/");
        JSONObject current = context.getRootSchema();
        for (String part : pathParts) {
            Object next;
            if (current.containsKey((Object)part)) {
                next = current.get((Object)part);
                if (!(next instanceof JSONObject)) {
                    throw new RuntimeException(ResManager.loadKDString((String)"$ref\u8def\u5f84\u65e0\u6548: ", (String)"JsonSchemaToParamDefinitionConverter_15095675", (String)"ai-gai-core", (Object[])new Object[0]) + ref);
                }
            } else {
                throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230$ref\u5f15\u7528: ", (String)"JsonSchemaToParamDefinitionConverter_15095676", (String)"ai-gai-core", (Object[])new Object[0]) + ref);
            }
            current = (JSONObject)next;
        }
        return JsonSchemaToParamDefinitionConverter.convertSchema(current, paramName, context, ref);
    }

    private static Object convertDefaultValue(Object defaultValue, ParamDefinition paramDef) {
        if (!(paramDef instanceof BasicParamDefinition)) {
            return null;
        }
        BasicParamDefinition basicDef = (BasicParamDefinition)paramDef;
        ParamType paramType = basicDef.getType();
        try {
            switch (paramType) {
                case STRING: {
                    return defaultValue.toString();
                }
                case INTEGER: {
                    if (defaultValue instanceof Number) {
                        return ((Number)defaultValue).intValue();
                    }
                    return Integer.parseInt(defaultValue.toString());
                }
                case FLOAT: {
                    if (defaultValue instanceof Number) {
                        return Float.valueOf(((Number)defaultValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(defaultValue.toString()));
                }
                case BOOLEAN: {
                    if (defaultValue instanceof Boolean) {
                        return (Boolean)defaultValue;
                    }
                    return Boolean.parseBoolean(defaultValue.toString());
                }
                case DATE: {
                    if (defaultValue instanceof String) {
                        String dateStr = (String)defaultValue;
                        try {
                            SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            return iso8601.parse(dateStr);
                        }
                        catch (ParseException e) {
                            try {
                                SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd");
                                return simple.parse(dateStr);
                            }
                            catch (ParseException e2) {
                                throw new RuntimeException(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u65e5\u671f: ", (String)"JsonSchemaToParamDefinitionConverter_15095677", (String)"ai-gai-core", (Object[])new Object[0]) + dateStr);
                            }
                        }
                    }
                    break;
                }
                default: {
                    return defaultValue.toString();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8f6c\u6362\u9ed8\u8ba4\u503c\u5931\u8d25: ", (String)"JsonSchemaToParamDefinitionConverter_15095678", (String)"ai-gai-core", (Object[])new Object[0]) + e.getMessage(), e);
        }
        return null;
    }

    public static Map<String, ParamDefinition> fromJsonSchemaDefinitions(String jsonSchemaStr) {
        JSONObject schema = JSON.parseObject((String)jsonSchemaStr);
        return JsonSchemaToParamDefinitionConverter.fromJsonSchemaDefinitions(schema);
    }

    public static Map<String, ParamDefinition> fromJsonSchemaDefinitions(JSONObject schema) {
        HashMap<String, ParamDefinition> result = new HashMap<String, ParamDefinition>();
        JSONObject definitions = schema.getJSONObject("definitions");
        if (definitions == null) {
            definitions = schema.getJSONObject("$defs");
        }
        if (definitions != null) {
            ConversionContext context = new ConversionContext(schema);
            for (String defName : definitions.keySet()) {
                JSONObject defSchema = definitions.getJSONObject(defName);
                if (defSchema == null) continue;
                ParamDefinition paramDef = JsonSchemaToParamDefinitionConverter.convertSchema(defSchema, defName, context, "#/definitions/" + defName);
                result.put(defName, paramDef);
            }
        }
        return result;
    }

    public static boolean isValidJsonSchema(String jsonSchemaStr) {
        try {
            JSONObject schema = JSON.parseObject((String)jsonSchemaStr);
            return schema.containsKey((Object)"$schema") || schema.containsKey((Object)"type") || schema.containsKey((Object)"properties") || schema.containsKey((Object)"definitions") || schema.containsKey((Object)"$defs");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ParamDefinition fromOpenApiComponent(String openApiSpec, String componentName) {
        JSONObject apiSpec = JSON.parseObject((String)openApiSpec);
        JSONObject components = apiSpec.getJSONObject("components");
        if (components == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"OpenAPI\u89c4\u8303\u4e2d\u6ca1\u6709\u627e\u5230components", (String)"JsonSchemaToParamDefinitionConverter_15095679", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        JSONObject schemas = components.getJSONObject("schemas");
        if (schemas == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"OpenAPI\u89c4\u8303\u4e2d\u6ca1\u6709\u627e\u5230schemas", (String)"JsonSchemaToParamDefinitionConverter_15095680", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        JSONObject componentSchema = schemas.getJSONObject(componentName);
        if (componentSchema == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u4ef6: ", (String)"JsonSchemaToParamDefinitionConverter_15095681", (String)"ai-gai-core", (Object[])new Object[0]) + componentName);
        }
        return JsonSchemaToParamDefinitionConverter.fromJsonSchema(componentSchema, componentName);
    }

    private static class ConversionContext {
        private final JSONObject rootSchema;
        private final Set<String> processedPaths = new HashSet<String>();
        private final Map<String, ParamDefinition> definitionCache = new HashMap<String, ParamDefinition>();

        public ConversionContext(JSONObject rootSchema) {
            this.rootSchema = rootSchema;
        }

        public JSONObject getRootSchema() {
            return this.rootSchema;
        }

        public boolean isProcessed(String path) {
            return this.processedPaths.contains(path);
        }

        public void addProcessedPath(String path) {
            this.processedPaths.add(path);
        }

        public ParamDefinition getFromCache(String key) {
            return this.definitionCache.get(key);
        }

        public void putToCache(String key, ParamDefinition definition) {
            this.definitionCache.put(key, definition);
        }
    }
}

