/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.converter;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;

public class ObjectToParamValueConverter {
    public static Object toParamValue(ParamDefinition paramDef, Object javaObject) {
        if (javaObject == null) {
            return null;
        }
        return ObjectToParamValueConverter.toParamValue(paramDef, javaObject, new ConversionContext());
    }

    private static Object toParamValue(ParamDefinition paramDef, Object javaObject, ConversionContext context) {
        if (javaObject == null) {
            return null;
        }
        if (context.isProcessed(javaObject)) {
            return null;
        }
        if (javaObject instanceof Collection || !(javaObject instanceof String) && !(javaObject instanceof Number) && !(javaObject instanceof Boolean) && !(javaObject instanceof Date) && !(javaObject instanceof Enum)) {
            context.addProcessedObject(javaObject);
        }
        if (paramDef instanceof BasicParamDefinition) {
            return ObjectToParamValueConverter.processBasicType((BasicParamDefinition)paramDef, javaObject);
        }
        if (paramDef instanceof ArrayParamDefinition) {
            return ObjectToParamValueConverter.processArrayType((ArrayParamDefinition)paramDef, javaObject, context);
        }
        if (paramDef instanceof ObjectParamDefinition) {
            return ObjectToParamValueConverter.processObjectType((ObjectParamDefinition)paramDef, javaObject, context);
        }
        throw new RuntimeException("\u672a\u77e5\u53c2\u6570\u4e0d\u652f\u6301");
    }

    private static Object processBasicType(BasicParamDefinition paramDef, Object javaObject) {
        return paramDef.narrow(javaObject);
    }

    private static Object processArrayType(ArrayParamDefinition paramDef, Object javaObject, ConversionContext context) {
        if (!(javaObject instanceof Collection) && !javaObject.getClass().isArray()) {
            ArrayList<Object> singleItemList = new ArrayList<Object>(1);
            Object itemValue = ObjectToParamValueConverter.toParamValue(paramDef.getItemDefinition(), javaObject, context);
            singleItemList.add(itemValue);
            return singleItemList;
        }
        Collection<?> collection = ObjectToParamValueConverter.convertToCollection(javaObject);
        if (collection == null) {
            return null;
        }
        ArrayList<Object> resultList = new ArrayList<Object>(collection.size());
        ParamDefinition itemDef = paramDef.getItemDefinition();
        for (Object item : collection) {
            Object convertedItem = ObjectToParamValueConverter.toParamValue(itemDef, item, context);
            resultList.add(convertedItem);
        }
        return resultList;
    }

    private static Object processObjectType(ObjectParamDefinition paramDef, Object javaObject, ConversionContext context) {
        if (javaObject instanceof Map) {
            return ObjectToParamValueConverter.processMapToObject(paramDef, (Map)javaObject, context);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(javaObject.getClass());
            for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                Object propValue;
                Method readMethod;
                if ("class".equals(descriptor.getName()) || (readMethod = descriptor.getReadMethod()) == null) continue;
                String propName = descriptor.getName();
                try {
                    propValue = readMethod.invoke(javaObject, new Object[0]);
                }
                catch (Exception e) {
                    continue;
                }
                ParamDefinition propDef = paramDef.getProperty(propName);
                if (propDef == null) continue;
                Object convertedValue = ObjectToParamValueConverter.toParamValue(propDef, propValue, context);
                result.put(propName, convertedValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u5bf9\u8c61\u4e3aParamValue\u5931\u8d25: " + e.getMessage(), e);
        }
        return result;
    }

    private static Object processMapToObject(ObjectParamDefinition paramDef, Map<?, ?> sourceMap, ConversionContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : sourceMap.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            ParamDefinition propDef = paramDef.getProperty(key);
            if (propDef == null) continue;
            Object convertedValue = ObjectToParamValueConverter.toParamValue(propDef, value, context);
            result.put(key, convertedValue);
        }
        return result;
    }

    private static Collection<?> convertToCollection(Object obj) {
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(obj, i));
            }
            return result;
        }
        return null;
    }

    private static class ConversionContext {
        private final Set<Object> processedObjects = new HashSet<Object>();

        private ConversionContext() {
        }

        public void addProcessedObject(Object obj) {
            if (obj != null) {
                this.processedObjects.add(obj);
            }
        }

        public boolean isProcessed(Object obj) {
            return obj != null && this.processedObjects.contains(obj);
        }
    }
}

