/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.validate.JsonValidator;
import kd.ai.gai.flow.dt.CollectionDataType;
import kd.ai.gai.flow.dt.DataType;

public class ArrayParamDefinition
extends ParamDefinition
implements CollectionDataType,
JsonValidator {
    private ParamDefinition itemDefinition;
    private List<Object> constantList;

    public ArrayParamDefinition(String name, ParamDefinition itemDefinition) {
        super(name);
        if (itemDefinition == null) {
            throw new IllegalArgumentException("\u6570\u7ec4\u9879\u5b9a\u4e49(itemDefinition)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemDefinition = itemDefinition;
    }

    @Override
    public ParamType getType() {
        return ParamType.ARRAY;
    }

    @Override
    public void setDirection(ParamDirection direction) {
        super.setDirection(direction);
        if (this.itemDefinition != null) {
            this.itemDefinition.setDirection(direction);
        }
    }

    @Override
    public void setVisibility(ParamVisibility visibility) {
        super.setVisibility(visibility);
        if (visibility == ParamVisibility.PRIVATE && this.itemDefinition != null) {
            this.itemDefinition.setVisibility(ParamVisibility.PRIVATE);
        }
    }

    public ParamDefinition getItemDefinition() {
        return this.itemDefinition;
    }

    public void setItemDefinition(ParamDefinition itemDefinition) {
        if (itemDefinition == null) {
            throw new IllegalArgumentException("\u6570\u7ec4\u9879\u5b9a\u4e49(itemDefinition)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemDefinition = itemDefinition;
    }

    public void clearItemDefinition() {
        this.itemDefinition = null;
    }

    @Override
    public boolean isConstant() {
        return this.source == ParamSource.CONSTANT && this.constantList != null;
    }

    @Override
    public Object getConstantValue() {
        return this.constantList;
    }

    @Override
    protected void setConstantValueInternal(Object value) {
        this.constantList = (List)this.narrow(value);
    }

    @Override
    protected void validateConstantType(Object value) {
    }

    public DataType getElementType() {
        return this.itemDefinition;
    }

    public <T> List<T> getListValue(Object rootValue) {
        Object value = this.getValue(rootValue);
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.emptyList();
    }

    @Override
    public Object narrow(Object outerValue) {
        if (outerValue == null) {
            return new ArrayList(1);
        }
        try {
            if (outerValue instanceof List) {
                List inputList = (List)outerValue;
                ArrayList<Object> resultList = new ArrayList<Object>(inputList.size());
                for (Object item : inputList) {
                    resultList.add(this.itemDefinition.narrow(item));
                }
                return resultList;
            }
            if (outerValue.getClass().isArray()) {
                int length = Array.getLength(outerValue);
                ArrayList<Object> resultList = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(outerValue, i);
                    resultList.add(this.itemDefinition.narrow(item));
                }
                return resultList;
            }
            if (outerValue instanceof String) {
                String strValue = (String)outerValue;
                if (this.isJsonArray(strValue)) {
                    this.validContent(strValue);
                    try {
                        JSONArray jsonList = JSON.parseArray((String)strValue);
                        return this.narrow(jsonList);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\u89e3\u6790\u4e3a\u6709\u6548\u7684JSON\u6570\u7ec4: " + strValue, e);
                    }
                }
                String[] parts = strValue.split(",");
                ArrayList<Object> resultList = new ArrayList<Object>(parts.length);
                for (String part : parts) {
                    String trimmedPart = part.trim();
                    if (trimmedPart.isEmpty()) continue;
                    resultList.add(this.itemDefinition.narrow(trimmedPart));
                }
                if (resultList.size() == 1 && strValue.indexOf(44) == -1) {
                    ArrayList<Object> singleItemList = new ArrayList<Object>(1);
                    singleItemList.add(this.itemDefinition.narrow(strValue));
                    return singleItemList;
                }
                return resultList;
            }
            ArrayList<Object> singleItemList = new ArrayList<Object>(1);
            singleItemList.add(this.itemDefinition.narrow(outerValue));
            return singleItemList;
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new IllegalArgumentException("\u6570\u7ec4\u7c7b\u578b\u8f6c\u6362\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public Object forJson(Object innerValue) {
        if (innerValue == null) {
            return null;
        }
        Collection collection = (Collection)innerValue;
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        for (Object item : collection) {
            result.add(this.getItemDefinition().forJson(item));
        }
        return result;
    }

    @Override
    protected String toDetailedString(int level) {
        StringBuilder sb = new StringBuilder(super.toDetailedString(level));
        sb.append("\r\n");
        for (int i = 0; i < level + 1; ++i) {
            sb.append("-- ");
        }
        ParamDefinition itemDef = this.getItemDefinition();
        sb.append("items: ");
        if (itemDef != null) {
            String itemString = itemDef.toDetailedString(0);
            int nameEnd = itemString.indexOf(" [");
            if (nameEnd > 0) {
                sb.append("[").append((Object)itemDef.getType()).append("]");
                sb.append(itemString.substring(nameEnd + itemDef.getType().toString().length() + 2));
            } else {
                sb.append(itemString);
            }
        } else {
            sb.append("[\u672a\u5b9a\u4e49]");
        }
        return sb.toString();
    }
}

