/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.misc.Json;

public class BasicParamDefinition
extends ParamDefinition {
    private Object constantValue;

    public BasicParamDefinition(String name, ParamType type) {
        super(name);
        if (type == ParamType.OBJECT || type == ParamType.ARRAY) {
            throw new IllegalArgumentException("\u57fa\u672c\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u5bf9\u8c61\u6216\u6570\u7ec4\u7c7b\u578b");
        }
        this.type = type;
    }

    @Override
    public ParamType getType() {
        return this.type;
    }

    @Override
    public boolean isConstant() {
        return this.source == ParamSource.CONSTANT && this.constantValue != null;
    }

    @Override
    public Object getConstantValue() {
        if (Objects.requireNonNull(this.type) == ParamType.DATE && this.constantValue != null) {
            return ((Json.DateTimeFormat)Json.DATE_TIME_FORMAT.get()).format(new Date(D.l((Object)this.constantValue)));
        }
        return this.constantValue;
    }

    @Override
    protected void setConstantValueInternal(Object value) {
        this.constantValue = this.narrow(value);
    }

    @Override
    protected void validateConstantType(Object value) {
    }

    public void setStringValue(String value) {
        if (this.type != ParamType.STRING) {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b");
        }
        this.setConstantValue(value);
    }

    public void setIntegerValue(Integer value) {
        if (this.type != ParamType.INTEGER) {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u6574\u6570\u7c7b\u578b");
        }
        this.setConstantValue(value);
    }

    public void setFloatValue(Float value) {
        if (this.type != ParamType.FLOAT) {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u6d6e\u70b9\u6570\u7c7b\u578b");
        }
        this.setConstantValue(value);
    }

    public void setBooleanValue(Boolean value) {
        if (this.type != ParamType.BOOLEAN) {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u5e03\u5c14\u7c7b\u578b");
        }
        this.setConstantValue(value);
    }

    public void setDateValue(Date value) {
        if (this.type != ParamType.DATE) {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u65e5\u671f\u7c7b\u578b");
        }
        this.setConstantValue(value);
    }

    private void validateStringConstraints(String value) {
    }

    private void validateNumberConstraints(Number value) {
    }

    @Override
    public Object narrow(Object outerValue) {
        if (outerValue == null) {
            return null;
        }
        try {
            switch (this.type) {
                case STRING: {
                    if (outerValue instanceof Map || outerValue instanceof Collection) {
                        return JSON.toJSONString((Object)outerValue);
                    }
                    if (outerValue instanceof BigDecimal) {
                        return ((BigDecimal)outerValue).toPlainString();
                    }
                    return outerValue.toString();
                }
                case INTEGER: {
                    return D.l((Object)outerValue);
                }
                case FLOAT: {
                    return D.d((Object)outerValue);
                }
                case BOOLEAN: {
                    return D.x((Object)outerValue);
                }
                case DATE: {
                    return D.t((Object)outerValue).getTime();
                }
            }
            return super.narrow(outerValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u503c'" + outerValue + "'\u8f6c\u6362\u4e3a\u7c7b\u578b" + (Object)((Object)this.type), e);
        }
    }
}

