/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.alibaba.fastjson.JSON;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;

public class MessageParamDefinition
extends BasicParamDefinition {
    private MessageType messageType;

    public MessageParamDefinition(String name, MessageType messageType) {
        super(name, ParamType.STRING);
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getMessageTypeName() {
        return this.messageType != null ? this.messageType.getText() : null;
    }

    public String getMessageTypeCode() {
        return this.messageType != null ? this.messageType.getValue() : null;
    }

    @Override
    public Object narrow(Object outerValue) {
        if (outerValue == null) {
            return "";
        }
        String narrowed = outerValue.getClass().isPrimitive() || this.isWrapperType(outerValue.getClass()) ? outerValue.toString() : JSON.toJSONString((Object)outerValue);
        if (this.messageType != null) {
            switch (this.messageType) {
                case Picture: {
                    this.validatePictureUrl(narrowed);
                    break;
                }
                case HyperLink: {
                    this.validateHyperLink(narrowed);
                    break;
                }
                case Iframe: {
                    this.validateIframe(narrowed);
                    break;
                }
            }
        }
        return narrowed;
    }

    private void validatePictureUrl(String url) {
    }

    private void validateHyperLink(String url) {
    }

    private void validateIframe(String content) {
    }

    @Override
    public String toString() {
        return "MessageParamDefinition(" + this.getName() + ", " + (Object)((Object)this.messageType) + ")";
    }

    private boolean isWrapperType(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(String.class);
    }

    public static MessageParamDefinition from(ParamDefinition source, MessageType messageType) {
        if (source == null) {
            throw new IllegalArgumentException("\u6e90\u53c2\u6570\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (source instanceof MessageParamDefinition && ((MessageParamDefinition)source).getMessageType() == messageType) {
            return (MessageParamDefinition)source;
        }
        MessageParamDefinition messageDef = new MessageParamDefinition(source.getName(), messageType);
        messageDef.setDescription(source.getDescription());
        messageDef.setRequired(source.isRequired());
        messageDef.setDirection(source.getDirection());
        messageDef.setVisibility(source.getVisibility());
        if (source.isReference()) {
            messageDef.setReferencePath(source.getReferencePath());
        }
        if (source.isConstant()) {
            Object constantValue = source.getConstantValue();
            messageDef.setConstantValue(messageDef.narrow(constantValue));
        }
        return messageDef;
    }
}

