/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.alibaba.fastjson.annotation.JSONField;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;

public class NodeParamPath
implements Serializable {
    private String nodeId;
    private String outputParamName;
    private List<String> propertyPath;

    public NodeParamPath() {
        this.propertyPath = new ArrayList<String>();
    }

    public NodeParamPath(String nodeId, String outputParamName) {
        this.nodeId = nodeId;
        this.outputParamName = outputParamName;
        this.propertyPath = new ArrayList<String>();
    }

    public NodeParamPath(String nodeId, String outputParamName, List<String> propertyPath) {
        this.nodeId = nodeId;
        this.outputParamName = outputParamName;
        this.propertyPath = propertyPath;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Transient
    @JSONField(serialize=false)
    public int getNodeIdAtInt() {
        try {
            return Integer.parseInt(this.nodeId);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getOutputParamName() {
        return this.outputParamName;
    }

    public void setOutputParamName(String outputParamName) {
        this.outputParamName = outputParamName;
    }

    public List<String> getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(List<String> propertyPath) {
        this.propertyPath = propertyPath;
    }

    public void addPropertyPathSegment(String segment) {
        if (this.propertyPath == null) {
            this.propertyPath = new ArrayList<String>();
        }
        this.propertyPath.add(segment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nodeId).append(".").append(this.outputParamName);
        if (this.propertyPath != null && !this.propertyPath.isEmpty()) {
            for (String segment : this.propertyPath) {
                if (segment.matches("\\d+")) {
                    sb.append("[").append(segment).append("]");
                    continue;
                }
                sb.append(".").append(segment);
            }
        }
        return sb.toString();
    }

    public static NodeParamPath parse(String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int firstDotIndex = path.indexOf(46);
        if (firstDotIndex == -1) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8def\u5f84\u683c\u5f0f: " + path);
        }
        String nodeId = path.substring(0, firstDotIndex);
        String remaining = path.substring(firstDotIndex + 1);
        NodeParamPath result = new NodeParamPath();
        result.setNodeId(nodeId);
        int nextDotIndex = remaining.indexOf(46);
        int nextBracketIndex = remaining.indexOf(91);
        if (nextDotIndex == -1 && nextBracketIndex == -1) {
            result.setOutputParamName(remaining);
            return result;
        }
        int endIndex = nextDotIndex == -1 ? nextBracketIndex : (nextBracketIndex == -1 ? nextDotIndex : Math.min(nextDotIndex, nextBracketIndex));
        result.setOutputParamName(remaining.substring(0, endIndex));
        String propertyPathStr = remaining.substring(endIndex);
        List<String> propertySegments = NodeParamPath.parsePropertyPath(propertyPathStr);
        result.setPropertyPath(propertySegments);
        return result;
    }

    private static List<String> parsePropertyPath(String pathStr) {
        ArrayList<String> segments = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\.([^.\\[\\]]+)|\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(pathStr);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String arrayIndex = matcher.group(2);
            if (propertyName != null) {
                segments.add(propertyName);
                continue;
            }
            if (arrayIndex == null) continue;
            segments.add(arrayIndex);
        }
        return segments;
    }

    @Transient
    @JSONField(serialize=false)
    public String getPropertyPathString() {
        return ParamPathHelper.generatePathSegments(this.propertyPath);
    }

    @Transient
    @JSONField(serialize=false)
    public String getFullPath() {
        return ParamPathHelper.generateFullPath(this.nodeId, this.outputParamName, this.propertyPath);
    }
}

