/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.flow.param.converter.ObjectToParamValueConverter;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.validate.JsonValidator;

public class ObjectParamDefinition
extends ParamDefinition
implements JsonValidator {
    private List<ParamDefinition> properties = new ArrayList<ParamDefinition>();
    private Map<String, Object> constantMap;

    public ObjectParamDefinition(String name) {
        super(name);
    }

    @Override
    public ParamType getType() {
        return ParamType.OBJECT;
    }

    @Override
    public void setDirection(ParamDirection direction) {
        super.setDirection(direction);
        if (this.properties != null) {
            for (ParamDefinition property : this.properties) {
                property.setDirection(direction);
            }
        }
    }

    @Override
    public void setVisibility(ParamVisibility visibility) {
        super.setVisibility(visibility);
        if (visibility == ParamVisibility.PRIVATE && this.properties != null) {
            for (ParamDefinition property : this.properties) {
                property.setVisibility(ParamVisibility.PRIVATE);
            }
        }
    }

    public List<ParamDefinition> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<ParamDefinition> properties) {
        this.properties = new ArrayList<ParamDefinition>(properties);
    }

    public void addProperty(ParamDefinition property) {
        this.properties.add(property);
    }

    public ParamDefinition getProperty(String name) {
        return this.properties.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public boolean isConstant() {
        return this.source == ParamSource.CONSTANT && this.constantMap != null;
    }

    @Override
    public Object getConstantValue() {
        return this.constantMap;
    }

    @Override
    protected void setConstantValueInternal(Object value) {
        this.constantMap = (Map)this.narrow(value);
    }

    @Override
    protected void validateConstantType(Object value) {
    }

    @Override
    public Object narrow(Object outerValue) {
        if (outerValue == null) {
            return null;
        }
        try {
            String strValue;
            if (outerValue instanceof Map) {
                Map inputMap = (Map)outerValue;
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (ParamDefinition propDef : this.getProperties()) {
                    String propName = propDef.getName();
                    Object propValue = inputMap.get(propName);
                    if (propValue == null && !propDef.isRequired()) continue;
                    resultMap.put(propName, propDef.narrow(propValue));
                }
                return resultMap;
            }
            if (outerValue instanceof String && this.isJsonObject(strValue = (String)outerValue)) {
                this.validContent(strValue);
                try {
                    JSONObject jsonMap = JSON.parseObject((String)strValue);
                    return this.narrow(jsonMap);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\u89e3\u6790\u4e3a\u6709\u6548\u7684JSON\u5bf9\u8c61: " + strValue, e);
                }
            }
            try {
                return ObjectToParamValueConverter.toParamValue(this, outerValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u7c7b\u578b [" + outerValue.getClass().getName() + "] \u7684\u503c '" + outerValue + "' \u8f6c\u6362\u4e3a\u5bf9\u8c61\u7c7b\u578b");
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new IllegalArgumentException("\u5bf9\u8c61\u7c7b\u578b\u8f6c\u6362\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public Object forSave(Object innerValue) {
        return JSON.toJSONString((Object)innerValue);
    }

    @Override
    public Object forJson(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e0d\u5339\u914d: \u53c2\u6570[" + this.getName() + "]\u671f\u671b\u5bf9\u8c61\u7c7b\u578b(Map)\uff0c\u5b9e\u9645\u4e3a" + object.getClass().getName());
        }
        Map map = (Map)object;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ParamDefinition property : this.getProperties()) {
            String propName = property.getName();
            if (!map.containsKey(propName)) continue;
            result.put(propName, property.forJson(map.get(propName)));
        }
        return result;
    }

    @Override
    protected String toDetailedString(int level) {
        StringBuilder sb = new StringBuilder(super.toDetailedString(level));
        sb.append("\r\n");
        for (ParamDefinition property : this.getProperties()) {
            sb.append(property.toDetailedString(level + 1)).append("\r\n");
        }
        if (!this.getProperties().isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

