/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamSource;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.helper.ParamValueHelper;
import kd.ai.gai.flow.dt.DataType;

public abstract class ParamDefinition
implements DataType,
Serializable {
    protected String name;
    protected String displayName;
    protected String description;
    protected boolean required;
    protected ParamType type;
    protected ParamDirection direction = ParamDirection.BOTH;
    protected ParamVisibility visibility = ParamVisibility.PUBLIC;
    protected ParamSource source = ParamSource.DYNAMIC;
    protected NodeParamPath referencePath;
    protected boolean heterogeneousReference = false;
    protected Map<String, String> customProperties;

    protected ParamDefinition(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.name = name;
        this.type = this.getType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public ParamDirection getDirection() {
        return this.direction;
    }

    public void setDirection(ParamDirection direction) {
        this.direction = direction;
    }

    public ParamVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(ParamVisibility visibility) {
        this.visibility = visibility;
    }

    public abstract ParamType getType();

    public ParamSource getSource() {
        return this.source;
    }

    public void setSource(ParamSource source) {
        this.source = source;
    }

    public NodeParamPath getReferencePath() {
        return this.referencePath;
    }

    public void setReferencePath(NodeParamPath referencePath) {
        this.referencePath = referencePath;
        if (referencePath != null) {
            this.source = ParamSource.REFERENCE;
        }
    }

    public void setReferencePath(String referencePathStr) {
        if (referencePathStr != null && !referencePathStr.trim().isEmpty()) {
            this.referencePath = NodeParamPath.parse(referencePathStr);
            this.source = ParamSource.REFERENCE;
        } else {
            this.referencePath = null;
        }
    }

    public boolean isHeterogeneousReference() {
        return this.heterogeneousReference;
    }

    public void setHeterogeneousReference(boolean heterogeneousReference) {
        this.heterogeneousReference = heterogeneousReference;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public abstract boolean isConstant();

    public abstract Object getConstantValue();

    protected abstract void setConstantValueInternal(Object var1);

    public void setConstantValue(Object value) {
        if (value != null) {
            this.validateConstantType(value);
        }
        this.setConstantValueInternal(value);
        if (value != null) {
            this.source = ParamSource.CONSTANT;
        }
    }

    protected abstract void validateConstantType(Object var1);

    public boolean isInput() {
        return this.direction == ParamDirection.INPUT || this.direction == ParamDirection.BOTH;
    }

    public boolean isOutput() {
        return this.direction == ParamDirection.OUTPUT || this.direction == ParamDirection.BOTH;
    }

    public boolean isReference() {
        return this.source == ParamSource.REFERENCE;
    }

    public boolean isDynamic() {
        return this.source == ParamSource.DYNAMIC;
    }

    public boolean isPublic() {
        return this.visibility == ParamVisibility.PUBLIC;
    }

    public boolean isPrivate() {
        return this.visibility == ParamVisibility.PRIVATE;
    }

    public Object getValue(Object rootValue) {
        if (rootValue == null) {
            return null;
        }
        switch (this.source) {
            case CONSTANT: {
                return this.getConstantValue();
            }
            case REFERENCE: {
                if (this.referencePath == null) {
                    throw new IllegalStateException("\u53c2\u6570[" + this.name + "]\u662f\u5f15\u7528\u7c7b\u578b\uff0c\u4f46\u5f15\u7528\u8def\u5f84\u4e3a\u7a7a");
                }
                Object refValue = ParamValueHelper.resolveValue(rootValue, this.referencePath);
                return this.narrow(refValue);
            }
            case DYNAMIC: {
                throw new UnsupportedOperationException("\u52a8\u6001\u53c2\u6570 [" + this.name + "] \u4e0d\u652f\u6301\u76f4\u63a5\u83b7\u53d6\u503c");
            }
        }
        throw new UnsupportedOperationException("\u672a\u5b9a\u4e49\u7684\u53c2\u6570\u7c7b\u578b [" + (Object)((Object)this.source) + ":" + this.name + "]");
    }

    public Object narrow(Object outerValue) {
        return outerValue;
    }

    public Object forSave(Object innerValue) {
        return innerValue;
    }

    public Object forJson(Object object) {
        return object;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name=" + this.name + ", type=" + (Object)((Object)this.getType()) + ", source=" + (Object)((Object)this.source) + ")";
    }

    public String toDetailedString() {
        return this.toDetailedString(0);
    }

    protected String toDetailedString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("-- ");
        }
        sb.append(this.name).append(" [").append((Object)this.getType()).append("]");
        sb.append(" (");
        switch (this.direction) {
            case INPUT: {
                sb.append("\u8f93\u5165");
                break;
            }
            case OUTPUT: {
                sb.append("\u8f93\u51fa");
                break;
            }
            case BOTH: {
                sb.append("\u8f93\u5165/\u8f93\u51fa");
                break;
            }
            default: {
                sb.append("\u672a\u77e5");
            }
        }
        sb.append(")");
        sb.append(" {");
        switch (this.source) {
            case CONSTANT: {
                sb.append("\u5e38\u91cf");
                break;
            }
            case REFERENCE: {
                sb.append("\u5f15\u7528");
                break;
            }
            case DYNAMIC: {
                sb.append("\u52a8\u6001");
                break;
            }
            default: {
                sb.append("\u672a\u77e5");
            }
        }
        if (this.isReference() && this.referencePath != null) {
            sb.append(": ").append(this.referencePath);
        } else if (this.isConstant()) {
            Object value = this.getConstantValue();
            sb.append(": ");
            if (value == null) {
                sb.append("null");
            } else if (value instanceof String) {
                String str = (String)value;
                if (str.length() > 20) {
                    sb.append("\"").append(str.substring(0, 17)).append("...\"");
                } else {
                    sb.append("\"").append(str).append("\"");
                }
            } else if (value instanceof Collection) {
                sb.append("\u96c6\u5408(").append(((Collection)value).size()).append("\u9879)");
            } else if (value instanceof Map) {
                sb.append("\u5bf9\u8c61(").append(((Map)value).size()).append("\u5c5e\u6027)");
            } else {
                sb.append(value);
            }
        }
        sb.append("}");
        sb.append(" [").append((Object)this.visibility).append("]");
        if (this.isRequired()) {
            sb.append(" *");
        }
        return sb.toString();
    }
}

