/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.define;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.FormatDateParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.flow.dt.D;

public class ParamDefinitionTypeAdapter
implements JsonDeserializer<ParamDefinition>,
JsonSerializer<ParamDefinition> {
    public JsonElement serialize(ParamDefinition src, Type typeOfSrc, JsonSerializationContext context) {
        return new Gson().toJsonTree((Object)src).getAsJsonObject();
    }

    public ParamDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ParamDefinition paramDefinition;
        ParamType paramType;
        JsonObject obj = json.getAsJsonObject();
        if (!obj.has("type")) {
            throw new JsonParseException("Missing 'type' field in ParamDefinition JSON");
        }
        try {
            paramType = ParamType.valueOf(obj.get("type").getAsString());
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid ParamType: " + obj.get("type").getAsString(), (Throwable)e);
        }
        switch (paramType) {
            case OBJECT: {
                paramDefinition = (ParamDefinition)context.deserialize(json, ObjectParamDefinition.class);
                break;
            }
            case ARRAY: {
                paramDefinition = (ParamDefinition)context.deserialize(json, ArrayParamDefinition.class);
                break;
            }
            case STRING: 
            case INTEGER: 
            case FLOAT: 
            case BOOLEAN: 
            case DATE: {
                if (obj.has("messageType")) {
                    paramDefinition = (ParamDefinition)context.deserialize(json, MessageParamDefinition.class);
                    break;
                }
                if (obj.has("format")) {
                    paramDefinition = (ParamDefinition)context.deserialize(json, FormatDateParamDefinition.class);
                    break;
                }
                paramDefinition = (ParamDefinition)context.deserialize(json, BasicParamDefinition.class);
                break;
            }
            default: {
                throw new JsonParseException("Unsupported ParamType: " + (Object)((Object)paramType));
            }
        }
        this.rebuildConstant(obj, paramDefinition);
        return paramDefinition;
    }

    private void rebuildConstant(JsonObject obj, ParamDefinition paramDefinition) {
        JsonElement constElement;
        String constantValue;
        if (obj.has("constantList") && !obj.get("constantList").isJsonNull() && (constantValue = (constElement = obj.get("constantList")).toString()) != null) {
            paramDefinition.setConstantValue(constantValue);
        }
        if (obj.has("constantMap") && !obj.get("constantMap").isJsonNull() && (constantValue = (constElement = obj.get("constantMap")).toString()) != null) {
            paramDefinition.setConstantValue(constantValue);
        }
        this.rebuildConstantValue(paramDefinition.getType(), obj, paramDefinition);
    }

    private void rebuildConstantValue(ParamType paramType, JsonObject obj, ParamDefinition paramDefinition) {
        if (obj.has("constantValue") && !obj.get("constantValue").isJsonNull()) {
            JsonElement constElement = obj.get("constantValue");
            Object constantValue = null;
            switch (paramType) {
                case INTEGER: {
                    if (!constElement.isJsonPrimitive() || !constElement.getAsJsonPrimitive().isNumber()) break;
                    constantValue = constElement.getAsLong();
                    break;
                }
                case FLOAT: {
                    if (!constElement.isJsonPrimitive() || !constElement.getAsJsonPrimitive().isNumber()) break;
                    constantValue = constElement.getAsDouble();
                    break;
                }
                case BOOLEAN: {
                    if (!constElement.isJsonPrimitive() || !constElement.getAsJsonPrimitive().isBoolean()) break;
                    constantValue = constElement.getAsBoolean();
                    break;
                }
                case STRING: {
                    if (!constElement.isJsonPrimitive() || !constElement.getAsJsonPrimitive().isString()) break;
                    constantValue = constElement.getAsString();
                    break;
                }
                case DATE: {
                    if (!constElement.isJsonPrimitive()) break;
                    constantValue = constElement.getAsString();
                    constantValue = D.t((Object)constantValue);
                }
            }
            if (constantValue != null) {
                paramDefinition.setConstantValue(constantValue);
            }
        }
    }
}

