/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum ParamType {
    STRING("String", true, false),
    INTEGER("Integer", true, false),
    FLOAT("Float", true, false),
    BOOLEAN("Boolean", true, false),
    DATE("Date", true, false),
    OBJECT("Object", false, false),
    ARRAY("Array", false, true);

    private final String desc;
    private final boolean basic;
    private final boolean array;
    public static final ParamType[] VALUES;

    private ParamType(String desc, boolean basic, boolean array) {
        this.desc = desc;
        this.basic = basic;
        this.array = array;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public boolean isArray() {
        return this.array;
    }

    public static ParamType parse(String desc) {
        for (ParamType paramType : VALUES) {
            if (!paramType.getDesc().equals(desc)) continue;
            return paramType;
        }
        throw new IllegalArgumentException("Can not find a valid Param Type");
    }

    public static List<ParamType> getParamTypesByBasic(boolean basic) {
        ArrayList paramTypes = Lists.newArrayList();
        for (ParamType paramType : VALUES) {
            if (paramType.isBasic() != basic) continue;
            paramTypes.add(paramType);
        }
        return paramTypes;
    }

    public static List<ParamType> getParamTypesByArr(boolean array) {
        ArrayList paramTypes = Lists.newArrayList();
        for (ParamType paramType : VALUES) {
            if (paramType.isArray() != array) continue;
            paramTypes.add(paramType);
        }
        return paramTypes;
    }

    public static ParamType convertStringToParamType(String typeStr) {
        if (StringUtils.isBlank((CharSequence)typeStr)) {
            return STRING;
        }
        switch (typeStr.toLowerCase()) {
            case "integer": 
            case "long": {
                return INTEGER;
            }
            case "double": 
            case "float": {
                return FLOAT;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "date": {
                return DATE;
            }
            case "object": {
                return OBJECT;
            }
            case "array<string>": 
            case "array<integer>": 
            case "array<object>": 
            case "array<float>": 
            case "array<boolean>": 
            case "array<date>": 
            case "array<array>": 
            case "array": {
                return ARRAY;
            }
        }
        return STRING;
    }

    public static ParamType getItemParmType(String typeStr) {
        ParamType paramType = ParamType.convertStringToParamType(typeStr);
        if (paramType != ARRAY) {
            return paramType;
        }
        if ("ARRAY".equalsIgnoreCase(typeStr)) {
            return null;
        }
        String itemTypeStr = typeStr.replace("Array<", "").replace(">", "");
        if (StringUtils.isBlank((CharSequence)itemTypeStr)) {
            return null;
        }
        return ParamType.convertStringToParamType(itemTypeStr);
    }

    static {
        VALUES = ParamType.values();
    }
}

