/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.example;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamValueBuilder;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FC;
import kd.ai.gai.flow.flow.core.Flow;
import kd.ai.gai.flow.flow.core.FlowBuilder;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;

public class ParamDefinitionFlowExample {
    public static void main(String[] args) {
        Flow flow = ParamDefinitionFlowExample.createFlow();
        FlowRuntime runtime = flow.newInstance("instance-1");
        Object inputData = ParamDefinitionFlowExample.createInputData();
        System.out.println("\u6267\u884c\u6d41\u7a0b...");
        runtime.execute(new Object[]{inputData});
        Object result = runtime.getOutput().get(0);
        System.out.println("\n\u6267\u884c\u7ed3\u679c: " + result);
        ParamDefinitionFlowExample.testSerialization(flow, runtime);
    }

    private static Flow createFlow() {
        System.out.println("\u521b\u5efa\u6d41\u7a0b\u5b9a\u4e49...");
        FlowBuilder fb = FC.getFactory().newInstance("complexParamFlow", "\u590d\u6742\u53c2\u6570\u6d41\u7a0b\u793a\u4f8b");
        ParamDefinition personParam = ParamDefinitionFlowExample.createPersonParamDefinition();
        ParamDefinition resultParam = ParamDefinitionFlowExample.createResultParamDefinition();
        fb.variable("v1", "person", "\u4eba\u5458\u4fe1\u606f", (DataType)personParam);
        fb.variable("v2", "result", "\u5904\u7406\u7ed3\u679c", (DataType)resultParam);
        fb.addInput("person");
        fb.addOutput("result");
        fb.node("start", "\u5f00\u59cb\u8282\u70b9").asStart();
        fb.node("process", "\u5904\u7406\u8282\u70b9").biz((Application)new ProcessApplication());
        fb.node("end", "\u7ed3\u675f\u8282\u70b9").asEnd();
        fb.transition("t1", "\u5f00\u59cb\u5230\u5904\u7406", "start", "process", Transition.Type.NORMAL);
        fb.transition("t2", "\u5904\u7406\u5230\u7ed3\u675f", "process", "end", Transition.Type.NORMAL);
        return fb.end();
    }

    private static ParamDefinition createPersonParamDefinition() {
        ObjectParamDefinition contactDef = ParamDefinitionBuilder.object("contact").property(ParamDefinitionBuilder.string("type").required(true).build()).property(ParamDefinitionBuilder.string("value").required(true).build()).build();
        return ParamDefinitionBuilder.object("person").asInput().required(true).property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.integer("age").build()).property(ParamDefinitionBuilder.array("contacts", contactDef).build()).build();
    }

    private static ParamDefinition createResultParamDefinition() {
        ObjectParamDefinition contactDef = ParamDefinitionBuilder.object("contact").property(ParamDefinitionBuilder.string("type").build()).property(ParamDefinitionBuilder.string("value").build()).build();
        return ParamDefinitionBuilder.object("result").asOutput().property(ParamDefinitionBuilder.bool("success").build()).property(ParamDefinitionBuilder.string("message").build()).property(ParamDefinitionBuilder.string("processedName").build()).property(ParamDefinitionBuilder.array("processedContacts", contactDef).build()).property(ParamDefinitionBuilder.date("processTime").build()).build();
    }

    private static Object createInputData() {
        System.out.println("\u521b\u5efa\u8f93\u5165\u6570\u636e...");
        return ParamValueBuilder.forDefinition(ParamDefinitionFlowExample.createPersonParamDefinition()).setValue("name", "\u5f20\u4e09").setValue("age", 30).array("contacts", contacts -> {
            contacts.object(c -> c.setValue("type", "PHONE").setValue("value", "13800138000"));
            contacts.object(c -> c.setValue("type", "EMAIL").setValue("value", "example@example.com"));
        }).build();
    }

    private static void testSerialization(Flow flow, FlowRuntime runtime) {
        System.out.println("\n\u6d4b\u8bd5\u5e8f\u5217\u5316\u548c\u53cd\u5e8f\u5217\u5316...");
        try {
            Map serializedState = runtime.toJson();
            System.out.println("\u5df2\u5e8f\u5217\u5316\u6d41\u7a0b\u72b6\u6001");
            FlowRuntime restoredRuntime = flow.fromJson(serializedState);
            System.out.println("\u5df2\u53cd\u5e8f\u5217\u5316\u4e3a\u65b0\u7684\u6d41\u7a0b\u5b9e\u4f8b");
            Object originalPerson = runtime.get("person");
            Object restoredPerson = restoredRuntime.get("person");
            System.out.println("\u9a8c\u8bc1person\u53d8\u91cf\u5e8f\u5217\u5316/\u53cd\u5e8f\u5217\u5316:");
            System.out.println("- \u539f\u59cbperson: " + originalPerson);
            System.out.println("- \u6062\u590d\u540eperson: " + restoredPerson);
            boolean personEquals = Objects.equals(originalPerson, restoredPerson);
            System.out.println("person\u5bf9\u8c61\u4e00\u81f4\u6027: " + personEquals);
            if (!personEquals && originalPerson instanceof Map && restoredPerson instanceof Map) {
                Map origMap = (Map)originalPerson;
                Map restMap = (Map)restoredPerson;
                System.out.println("\u8be6\u7ec6\u6bd4\u8f83:");
                System.out.println("- \u540d\u79f0\u4e00\u81f4: " + Objects.equals(origMap.get("name"), restMap.get("name")));
                System.out.println("- \u5e74\u9f84\u4e00\u81f4: " + Objects.equals(origMap.get("age"), restMap.get("age")));
                List origContacts = (List)origMap.get("contacts");
                List restContacts = (List)restMap.get("contacts");
                boolean contactsEqual = Objects.equals(origContacts, restContacts);
                System.out.println("- \u8054\u7cfb\u65b9\u5f0f\u4e00\u81f4: " + contactsEqual);
                if (!contactsEqual && origContacts != null && restContacts != null) {
                    System.out.println("  \u8054\u7cfb\u65b9\u5f0f\u6570\u91cf: \u539f\u59cb=" + origContacts.size() + ", \u6062\u590d=" + restContacts.size());
                    int minSize = Math.min(origContacts.size(), restContacts.size());
                    for (int i = 0; i < minSize; ++i) {
                        Object origItem = origContacts.get(i);
                        Object restItem = restContacts.get(i);
                        System.out.println("  \u8054\u7cfb\u65b9\u5f0f[" + i + "]\u4e00\u81f4: " + Objects.equals(origItem, restItem));
                    }
                }
            }
            Object originalResult = runtime.getOutput().get(0);
            Object restoredResult = restoredRuntime.getOutput().get(0);
            boolean resultEquals = Objects.equals(originalResult, restoredResult);
            System.out.println("result\u5bf9\u8c61\u4e00\u81f4\u6027: " + resultEquals);
            System.out.println("\u5e8f\u5217\u5316/\u53cd\u5e8f\u5217\u5316\u6d4b\u8bd5" + (personEquals && resultEquals ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        catch (Exception e) {
            System.err.println("\u5e8f\u5217\u5316/\u53cd\u5e8f\u5217\u5316\u6d4b\u8bd5\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static class ProcessApplication
    implements Application {
        ProcessApplication() {
        }

        public void compile(VariableScope scope) {
        }

        public void invoke(Execution e) {
            System.out.println("\u5904\u7406\u6570\u636e...");
            Map person = (Map)e.get("person");
            String name = (String)person.get("name");
            List contacts = (List)person.get("contacts");
            Object result = ParamValueBuilder.forDefinition(ParamDefinitionFlowExample.createResultParamDefinition()).setValue("success", true).setValue("message", "\u5904\u7406\u6210\u529f").setValue("processedName", "\u5904\u7406\u540e: " + name).setValue("processTime", new Date()).array("processedContacts", resultContacts -> {
                if (contacts != null) {
                    for (Map contact : contacts) {
                        resultContacts.object(c -> c.setValue("type", contact.get("type")).setValue("value", "\u5df2\u9a8c\u8bc1: " + contact.get("value")));
                    }
                }
            }).build();
            e.set("result", result);
        }
    }
}

