/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.example;

import java.util.List;
import java.util.Map;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamPathBuilder;
import kd.ai.gai.core.flow.param.builder.ParamValueBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;

public class ParamDefinitionInputOutputExample {
    public static void main(String[] args) {
        ParamDefinitionInputOutputExample.scenario1_ObjectProperty();
        ParamDefinitionInputOutputExample.scenario2_ArrayItemProperty();
        ParamDefinitionInputOutputExample.scenario3_NestedArrayStructure();
    }

    public static void scenario1_ObjectProperty() {
        System.out.println("\n=== \u573a\u666f1: \u4e0a\u6e38\u53d8\u91cf\u662fObject\uff0c\u4e0b\u6e38\u5f15\u7528Object\u91cc\u7684\u5c5e\u6027 ===");
        ObjectParamDefinition userInfoDef = ParamDefinitionBuilder.object("userInfo").direction(ParamDirection.OUTPUT).makePublic().property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.integer("age").build()).property(ParamDefinitionBuilder.string("email").build()).property(ParamDefinitionBuilder.object("address").property(ParamDefinitionBuilder.string("street").build()).property(ParamDefinitionBuilder.string("city").build()).property(ParamDefinitionBuilder.string("zipCode").build()).build()).build();
        System.out.println();
        System.out.println("------------ \u4e0a\u6e38\u8f93\u51fa\u53d8\u91cf:userInfo ---------------");
        System.out.println(userInfoDef.toDetailedString());
        Object userInfoValue = ParamValueBuilder.forDefinition(userInfoDef).setValue("name", "\u5f20\u4e09").setValue("age", 30).setValue("email", "zhangsan@example.com").object("address", address -> address.setValue("street", "\u4e2d\u5173\u6751\u5927\u88571\u53f7").setValue("city", "\u5317\u4eac").setValue("zipCode", "100080")).build();
        System.out.println("\u4e0a\u6e38\u8282\u70b9\u53d8\u91cf\u503c: " + userInfoValue);
        ParamDefinition userNameDef = ParamReferenceHelper.resolveReference("userName", userInfoDef, ParamPathBuilder.from("userNode", "userInfo").property("name").build());
        System.out.println();
        System.out.println("------------ \u4e0b\u6e38\u8f93\u5165\u53d8\u91cf:userName ---------------");
        System.out.println(userNameDef.toDetailedString());
        ParamDefinition userAddressDef = ParamReferenceHelper.resolveReference("userAddress", userInfoDef, ParamPathBuilder.from("userNode", "userInfo").property("address").build());
        System.out.println();
        System.out.println("------------ \u4e0b\u6e38\u8f93\u5165\u53d8\u91cf:userAddress ---------------");
        System.out.println(userAddressDef.toDetailedString());
        ParamDefinition userCityDef = ParamReferenceHelper.resolveReference("userCity", userInfoDef, ParamPathBuilder.from("userNode", "userInfo").property("address").property("city").build());
        System.out.println();
        System.out.println("------------ \u4e0b\u6e38\u8f93\u5165\u53d8\u91cf:userCity ---------------");
        System.out.println(userCityDef.toDetailedString());
        System.out.println();
        Object userNameValue = userNameDef.getValue(userInfoValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u7528\u6237\u540d: " + userNameValue);
        Object userAddressValue = userAddressDef.getValue(userInfoValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u5730\u5740: " + userAddressValue);
        Object userCityValue = userCityDef.getValue(userInfoValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u57ce\u5e02: " + userCityValue);
    }

    public static void scenario2_ArrayItemProperty() {
        System.out.println("\n=== \u573a\u666f2: \u4e0a\u6e38\u53d8\u91cf\u662fArray<Object>\uff0c\u4e0b\u6e38\u5f15\u7528Array\u4e2dObject\u7684\u5c5e\u6027 ===");
        ObjectParamDefinition userDef = ParamDefinitionBuilder.object("user").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(ParamDefinitionBuilder.string("email").build()).property(ParamDefinitionBuilder.string("role").build()).build();
        ArrayParamDefinition usersListDef = ParamDefinitionBuilder.array("usersList", userDef).build();
        Object usersListValue = ParamValueBuilder.forDefinition(usersListDef).array(items -> {
            items.object(user -> user.setValue("id", "user001").setValue("name", "\u5f20\u4e09").setValue("email", "zhangsan@example.com").setValue("role", "admin"));
            items.object(user -> user.setValue("id", "user002").setValue("name", "\u674e\u56db").setValue("email", "lisi@example.com").setValue("role", "user"));
            items.object(user -> user.setValue("id", "user003").setValue("name", "\u738b\u4e94").setValue("email", "wangwu@example.com").setValue("role", "user"));
        }).build();
        System.out.println("\u4e0a\u6e38\u8282\u70b9\u53d8\u91cf\u503c: " + usersListValue);
        ParamDefinition firstUserDef = ParamReferenceHelper.resolveReference("firstUser", usersListDef, ParamPathBuilder.from("usersNode", "usersList").index(0).build());
        ParamDefinition allNamesDef = ParamReferenceHelper.resolveReference("allNames", usersListDef, ParamPathBuilder.from("usersNode", "usersList").allItemsProperty("name").build());
        ParamDefinition adminEmailsDef = ParamReferenceHelper.resolveReference("adminEmails", usersListDef, ParamPathBuilder.from("usersNode", "usersList").allItemsProperty("email").build());
        Object firstUserValue = firstUserDef.getValue(usersListValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u7b2c\u4e00\u4e2a\u7528\u6237: " + firstUserValue);
        Object allNamesValue = allNamesDef.getValue(usersListValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u6240\u6709\u7528\u6237\u540d: " + allNamesValue);
        Object allEmailsValue = adminEmailsDef.getValue(usersListValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u6240\u6709\u90ae\u7bb1: " + allEmailsValue);
    }

    public static void scenario3_NestedArrayStructure() {
        System.out.println("\n=== \u573a\u666f3: \u591a\u5c42\u6570\u7ec4\u7ed3\u6784 ===");
        ArrayParamDefinition skillsArrayDef = ParamDefinitionBuilder.stringArray("skills").build();
        ObjectParamDefinition employeeDef = ParamDefinitionBuilder.object("employee").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(skillsArrayDef).build();
        ArrayParamDefinition employeesArrayDef = ParamDefinitionBuilder.array("employees", employeeDef).build();
        ObjectParamDefinition departmentDef = ParamDefinitionBuilder.object("department").property(ParamDefinitionBuilder.string("id").required(true).build()).property(ParamDefinitionBuilder.string("name").required(true).build()).property(employeesArrayDef).build();
        ArrayParamDefinition departmentsArrayDef = ParamDefinitionBuilder.array("departments", departmentDef).build();
        Object departmentsValue = ParamValueBuilder.forDefinition(departmentsArrayDef).array(depts -> {
            depts.object(dept -> dept.setValue("id", "dept001").setValue("name", "\u6280\u672f\u90e8").array("employees", emps -> {
                emps.object(emp -> emp.setValue("id", "emp001").setValue("name", "\u5f20\u5de5").array("skills", skills -> {
                    skills.item("Java");
                    skills.item("Python");
                    skills.item("Go");
                }));
                emps.object(emp -> emp.setValue("id", "emp002").setValue("name", "\u674e\u5de5").array("skills", skills -> {
                    skills.item("React");
                    skills.item("Vue");
                    skills.item("Angular");
                }));
            }));
            depts.object(dept -> dept.setValue("id", "dept002").setValue("name", "\u5e02\u573a\u90e8").array("employees", emps -> emps.object(emp -> emp.setValue("id", "emp003").setValue("name", "\u738b\u7ecf\u7406").array("skills", skills -> {
                skills.item("Marketing");
                skills.item("Sales");
            }))));
        }).build();
        System.out.println("\u4e0a\u6e38\u8282\u70b9\u53d8\u91cf\u503c(\u90e8\u5206): " + ((List)departmentsValue).size() + " \u4e2a\u90e8\u95e8");
        ParamDefinition deptNamesDef = ParamReferenceHelper.resolveReference("departmentNames", departmentsArrayDef, ParamPathBuilder.from("companyNode", "departments").allItemsProperty("name").build());
        ParamDefinition techEmployeesDef = ParamReferenceHelper.resolveReference("techEmployees", departmentsArrayDef, ParamPathBuilder.from("companyNode", "departments").index(0).property("employees").build());
        ParamDefinition allSkillsDef = ParamReferenceHelper.resolveReference("allSkills", departmentsArrayDef, ParamPathBuilder.from("companyNode", "departments").allItemsProperty("employees").allItemsProperty("skills").build());
        Object deptNamesValue = deptNamesDef.getValue(departmentsValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u6240\u6709\u90e8\u95e8\u540d\u79f0: " + deptNamesValue);
        Object techEmployeesValue = techEmployeesDef.getValue(departmentsValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u6280\u672f\u90e8\u5458\u5de5: " + techEmployeesValue);
        if (techEmployeesValue instanceof List) {
            List employees = (List)techEmployeesValue;
            System.out.println("  \u6280\u672f\u90e8\u5458\u5de5\u6570\u91cf: " + employees.size());
            if (!employees.isEmpty() && employees.get(0) instanceof Map) {
                Map firstEmp = (Map)employees.get(0);
                System.out.println("  \u7b2c\u4e00\u4f4d\u5458\u5de5: " + firstEmp.get("name"));
            }
        }
        Object allSkillsValue = allSkillsDef.getValue(departmentsValue);
        System.out.println("\u4e0b\u6e38\u5f15\u7528\u7684\u6240\u6709\u6280\u80fd: " + allSkillsValue);
        System.out.println("\n\u6700\u7ec8\u7ed3\u6784\u5206\u6790:");
        System.out.println("\u6240\u6709\u6280\u80fd\u7684\u7c7b\u578b: " + (allSkillsValue != null ? allSkillsValue.getClass().getName() : "null"));
        if (allSkillsValue instanceof List) {
            List skills = (List)allSkillsValue;
            System.out.println("\u6280\u80fd\u5217\u8868\u957f\u5ea6: " + skills.size());
            if (!skills.isEmpty()) {
                System.out.println("\u7b2c\u4e00\u4e2a\u6280\u80fd\u7684\u7c7b\u578b: " + skills.get(0).getClass().getName());
                System.out.println("\u6280\u80fd\u5217\u8868\u5185\u5bb9: " + skills);
            }
        }
    }
}

