/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.param.example;

import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.builder.ParamPathBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;

public class ParamPathBuilderExample {
    public static void main(String[] args) {
        ParamPathBuilderExample e = new ParamPathBuilderExample();
        e.basicPathBuilding();
        e.referenceStringExample();
        e.paramDefinitionExample();
    }

    public void basicPathBuilding() {
        System.out.println("=== \u57fa\u672c\u8def\u5f84\u6784\u5efa\u793a\u4f8b ===");
        NodeParamPath simplePath = ParamPathBuilder.from("userNode", "userData").build();
        System.out.println("\u7b80\u5355\u8def\u5f84: " + simplePath);
        NodeParamPath propertyPath = ParamPathBuilder.from("userNode", "userData").property("profile").property("name").build();
        System.out.println("\u5c5e\u6027\u8def\u5f84: " + propertyPath);
        NodeParamPath arrayIndexPath = ParamPathBuilder.from("orderNode", "orders").index(0).property("items").index(2).property("price").build();
        System.out.println("\u6570\u7ec4\u7d22\u5f15\u8def\u5f84: " + arrayIndexPath);
        NodeParamPath wildcardPath = ParamPathBuilder.from("orderNode", "orders").allItems().build();
        System.out.println("\u901a\u914d\u7b26\u8def\u5f84: " + wildcardPath);
        NodeParamPath wildcardPropertyPath = ParamPathBuilder.from("userNode", "users").allItemsProperty("email").build();
        System.out.println("\u901a\u914d\u7b26\u5c5e\u6027\u8def\u5f84: " + wildcardPropertyPath);
        NodeParamPath complexPath = ParamPathBuilder.from("companyNode", "departments").allItems().property("employees").allItemsProperty("skills").allItems().build();
        System.out.println("\u590d\u6742\u5d4c\u5957\u8def\u5f84: " + complexPath);
    }

    public void referenceStringExample() {
        System.out.println("\n=== \u5f15\u7528\u5b57\u7b26\u4e32\u793a\u4f8b ===");
        String simpleRef = ParamPathBuilder.from("userNode", "userData").property("profile").buildReferenceString();
        System.out.println("\u7b80\u5355\u5f15\u7528\u5b57\u7b26\u4e32: " + simpleRef);
        String arrayRef = ParamPathBuilder.from("orderNode", "items").index(1).property("details").buildReferenceString();
        System.out.println("\u6570\u7ec4\u5f15\u7528\u5b57\u7b26\u4e32: " + arrayRef);
        String wildcardRef = ParamPathBuilder.from("userNode", "users").allItemsProperty("email").buildReferenceString();
        System.out.println("\u901a\u914d\u7b26\u5f15\u7528\u5b57\u7b26\u4e32: " + wildcardRef);
        String complexRefString = "companyNode.departments[*].employees[*].name";
        NodeParamPath parsedPath = ParamPathBuilder.parseReferenceString(complexRefString);
        System.out.println("\u89e3\u6790\u7684\u8def\u5f84\u8282\u70b9ID: " + parsedPath.getNodeId());
        System.out.println("\u89e3\u6790\u7684\u8def\u5f84\u53c2\u6570\u540d: " + parsedPath.getOutputParamName());
        System.out.println("\u89e3\u6790\u7684\u8def\u5f84\u6bb5\u6570\u91cf: " + parsedPath.getPropertyPath().size());
        String reBuiltString = ParamPathHelper.toString(parsedPath);
        System.out.println("\u91cd\u5efa\u7684\u5f15\u7528\u5b57\u7b26\u4e32: " + reBuiltString);
        System.out.println("\u4e0e\u539f\u59cb\u5b57\u7b26\u4e32\u4e00\u81f4: " + complexRefString.equals(reBuiltString));
    }

    public void paramDefinitionExample() {
        System.out.println("\n=== \u53c2\u6570\u5b9a\u4e49\u4e2d\u4f7f\u7528\u8def\u5f84\u793a\u4f8b ===");
        BasicParamDefinition userNameParam = ParamDefinitionBuilder.string("userName").reference(ParamPathBuilder.from("userNode", "userData").property("name").buildReferenceString()).build();
        System.out.println("\u7528\u6237\u540d\u53c2\u6570\u5f15\u7528: " + userNameParam.getReferencePath());
        ObjectParamDefinition firstOrderParam = ParamDefinitionBuilder.object("firstOrder").reference(ParamPathBuilder.from("orderNode", "orders").index(0).buildReferenceString()).build();
        System.out.println("\u7b2c\u4e00\u4e2a\u8ba2\u5355\u53c2\u6570\u5f15\u7528: " + firstOrderParam.getReferencePath());
        ArrayParamDefinition allUserEmailsParam = ParamDefinitionBuilder.stringArray("allUserEmails").reference(ParamPathBuilder.from("123", "user").buildReferenceString()).build();
        System.out.println("\u6240\u6709\u7528\u6237\u90ae\u7bb1\u53c2\u6570\u5f15\u7528: " + allUserEmailsParam.getReferencePath());
    }
}

